#ifndef SCREENORIENTATION_H
#define SCREENORIENTATION_H

#include <QObject>

class ScreenOrientation : public QObject
{
    Q_OBJECT

    Q_ENUMS(Orientation)

public:
    enum Orientation {
#ifdef SAILFISH_OS
        LockPortrait = 1,
        LockLandscape = 2,
        LockPortraitInverted = 4,
        LockLandcapeInverted = 8,
        Automatic = 15
#else
        Automatic = 0,
        LockPortrait,
        LockLandscape
#endif
    };

    inline static QString orientationString(Orientation orientation) {
        switch (orientation) {
            case Automatic:
            return tr("Automatic");
        case LockPortrait:
            return tr("Portrait");
        case LockLandscape:
            return tr("Landscape");
#ifdef SAILFISH_OS
        case LockPortraitInverted:
            return tr("Portrait (inverted)");
        case LockLandscapeInverted:
            return tr("Landscape (inverted)");
#endif
        default:
            return tr("Unknown");
        }
    }

private:
    ScreenOrientation() {}
    ~ScreenOrientation() {}
};

#endif // SCREENORIENTATION_H
