#include "valueselectoraction.h"
#include "valueselector.h"
#include "../shared/selectionmodel.h"

ValueSelectorAction::ValueSelectorAction(QWidget *parent) :
    QWidgetAction(parent)
{
}

ValueSelectorAction::~ValueSelectorAction() {}

SelectionModel* ValueSelectorAction::model() const {
    return m_model;
}

void ValueSelectorAction::setModel(SelectionModel *model) {
    m_model = model;
}

QVariant ValueSelectorAction::value() const {
    return m_value;
}

void ValueSelectorAction::setValue(const QVariant &value) {
    if (value != this->value()) {
        m_value = value;
        emit valueChanged(value);
    }
}

QWidget* ValueSelectorAction::createWidget(QWidget *parent) {
    ValueSelector *selector = new ValueSelector(this->text(), parent);

    if (this->model()) {
        selector->setModel(this->model());

        if (this->value().isValid()) {
            selector->setValue(this->value());
        }
    }

    this->connect(selector, SIGNAL(valueChanged(QVariant)), this, SLOT(setValue(QVariant)));

    return selector;
}
