#include "separatorlabel.h"
#include <QHBoxLayout>
#include <QLabel>
#include <QMaemo5Style>

SeparatorLabel::SeparatorLabel(const QString &text, QWidget *parent) :
    QWidget(parent),
    m_label(new QLabel(text, this))
{
    this->setStyleSheet("color: " + QMaemo5Style::standardColor("SecondaryTextColor").name());

    QFont font;
    font.setPixelSize(20);
    m_label->setFont(font);

    QHBoxLayout *hbox = new QHBoxLayout(this);
    QFrame *line = new QFrame(this);

    line->setFrameShape(QFrame::HLine);
    line->setLineWidth(1);

    hbox->addWidget(line, 1);
    hbox->addWidget(m_label, 0, Qt::AlignVCenter);
}
