import QtQuick 1.1
import com.nokia.meego 1.0

Sheet {
    id: root

    platformStyle: SheetStyle {
        background: window.platformStyle.background
    }

    buttons: [
        SheetButton {
            anchors.left: parent.left
            anchors.leftMargin: root.platformStyle.rejectButtonLeftMargin
            anchors.verticalCenter: parent.verticalCenter
            text: root.rejectButtonText
            visible: text != ""
            onClicked: reject()
        },

        SheetButton {
            anchors.right: parent.right
            anchors.rightMargin: root.platformStyle.acceptButtonRightMargin
            anchors.verticalCenter: parent.verticalCenter
            platformStyle: SheetButtonAccentStyle {
                background: "image://theme/color14-meegotouch-sheet-button-accent"+__invertedString+"-background"
                pressedBackground: "image://theme/color14-meegotouch-sheet-button-accent"+__invertedString+"-background-pressed"
                disabledBackground: "image://theme/color14-meegotouch-sheet-button-accent"+__invertedString+"-background-disabled"
            }
            text: root.acceptButtonText
            visible: text != ""
            onClicked: accept()
        }
    ]

    MouseArea {
        z: -1
        anchors.fill: parent
    }
}
