/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.action;

import ch.elca.el4j.services.xmlmerge.AbstractXmlMergeException;
import ch.elca.el4j.services.xmlmerge.Action;
import ch.elca.el4j.services.xmlmerge.DocumentException;
import ch.elca.el4j.services.xmlmerge.ElementException;
import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

public class DtdInsertAction
implements Action {
    static Map s_dtdMap = new Hashtable();
    private static Log s_logger = LogFactory.getLog(DtdInsertAction.class);

    public void perform(Element originalElement, Element patchElement, Element outputParentElement) throws AbstractXmlMergeException {
        Element element = originalElement != null ? (Element)originalElement.clone() : (Element)patchElement.clone();
        DTD dtd = this.getDTD(outputParentElement);
        Vector dtdElements = dtd.getItemsByType(DTDElement.class);
        DTDElement parentDtdElement = null;
        for (DTDElement dtdElement : dtdElements) {
            if (!dtdElement.getName().equals(outputParentElement.getName())) continue;
            parentDtdElement = dtdElement;
        }
        if (parentDtdElement == null) {
            throw new ElementException(element, "Element " + outputParentElement.getName() + " not defined in DTD");
        }
        DTDItem item = parentDtdElement.getContent();
        if (item instanceof DTDAny) {
            outputParentElement.addContent(element);
        } else if (item instanceof DTDContainer) {
            List existingChildren = outputParentElement.getChildren();
            if (existingChildren.size() == 0) {
                outputParentElement.addContent(element);
            } else {
                List orderedDtdElements = this.getOrderedDtdElements((DTDContainer)item);
                int indexOfNewElementInDtd = orderedDtdElements.indexOf(element.getName());
                s_logger.debug("index of element " + element.getName() + ": " + indexOfNewElementInDtd);
                int pos = existingChildren.size();
                for (int i = 0; i < existingChildren.size(); ++i) {
                    String elementName = ((Element)existingChildren.get(i)).getName();
                    s_logger.debug("index of child " + elementName + ": " + orderedDtdElements.indexOf(elementName));
                    if (orderedDtdElements.indexOf(elementName) <= indexOfNewElementInDtd) continue;
                    pos = i;
                    break;
                }
                s_logger.debug("adding element " + element.getName() + " add in pos " + pos);
                outputParentElement.addContent(pos, element);
            }
        }
    }

    public DTD getDTD(Element element) throws DocumentException {
        if (element.getDocument().getDocType() != null) {
            String systemId = element.getDocument().getDocType().getSystemID();
            DTD dtd = (DTD)s_dtdMap.get(systemId);
            if (dtd == null) {
                URL url;
                try {
                    url = new URL(systemId);
                }
                catch (MalformedURLException e) {
                    throw new DocumentException(element.getDocument(), (Throwable)e);
                }
                try {
                    dtd = new DTDParser((Reader)new InputStreamReader(url.openStream())).parse();
                }
                catch (IOException ioe) {
                    throw new DocumentException(element.getDocument(), (Throwable)ioe);
                }
                s_dtdMap.put(systemId, dtd);
            }
            return dtd;
        }
        throw new DocumentException(element.getDocument(), "No DTD specified in document " + element.getDocument());
    }

    public List getOrderedDtdElements(DTDContainer container) {
        ArrayList<String> result = new ArrayList<String>();
        DTDItem[] items = container.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] instanceof DTDContainer) {
                result.addAll(this.getOrderedDtdElements((DTDContainer)items[i]));
                continue;
            }
            if (!(items[i] instanceof DTDName)) continue;
            result.add(((DTDName)items[i]).getValue());
        }
        return result;
    }
}

