/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.KeyFactorySpi;
import java.security.PublicKey;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.JCEDHPublicKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JCEElGamalPublicKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.jce.provider.JDKDSAPublicKey;
import org.bouncycastle.jce.provider.JDKGOST3410PublicKey;
import org.bouncycastle.jce.provider.RSAUtil;

public abstract class JDKKeyFactory
extends KeyFactorySpi {
    private boolean elGamalFactory = false;

    static PublicKey createPublicKeyFromPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        DERObjectIdentifier dERObjectIdentifier = subjectPublicKeyInfo.getAlgorithmId().getObjectId();
        if (RSAUtil.isRsaOid(dERObjectIdentifier)) {
            return new JCERSAPublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            return new JCEDHPublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(X9ObjectIdentifiers.dhpublicnumber)) {
            return new JCEDHPublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            return new JCEElGamalPublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(X9ObjectIdentifiers.id_dsa)) {
            return new JDKDSAPublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            return new JDKDSAPublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new JDKGOST3410PublicKey(subjectPublicKeyInfo);
        }
        if (dERObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            return new JCEECPublicKey(subjectPublicKeyInfo);
        }
        throw new RuntimeException("algorithm identifier " + dERObjectIdentifier + " in key not recognised");
    }
}

