/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jce.provider.asymmetric.ec.ECUtil;

public final class RSAKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    public final void init$7345ead7(ASN1Dump aSN1Dump) {
        this.param = (RSAKeyGenerationParameters)aSN1Dump;
    }

    public final ECUtil generateKeyPair$4c63f72c() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n = this.param.getStrength();
        int n2 = (n + 1) / 2;
        int n3 = n - n2;
        int n4 = n / 3;
        BigInteger bigInteger4 = this.param.getPublicExponent();
        while ((bigInteger3 = new BigInteger(n2, 1, this.param.getRandom())).mod(bigInteger4).equals(ONE) || !bigInteger3.isProbablePrime(this.param.getCertainty()) || !bigInteger4.gcd(bigInteger3.subtract(ONE)).equals(ONE)) {
        }
        while (true) {
            if ((bigInteger2 = new BigInteger(n3, 1, this.param.getRandom())).subtract(bigInteger3).abs().bitLength() < n4 || bigInteger2.mod(bigInteger4).equals(ONE) || !bigInteger2.isProbablePrime(this.param.getCertainty()) || !bigInteger4.gcd(bigInteger2.subtract(ONE)).equals(ONE)) {
                continue;
            }
            bigInteger = bigInteger3.multiply(bigInteger2);
            if (bigInteger.bitLength() == this.param.getStrength()) break;
            bigInteger3 = bigInteger3.max(bigInteger2);
        }
        if (bigInteger3.compareTo(bigInteger2) < 0) {
            BigInteger bigInteger5 = bigInteger3;
            bigInteger3 = bigInteger2;
            bigInteger2 = bigInteger5;
        }
        BigInteger bigInteger6 = bigInteger3.subtract(ONE);
        BigInteger bigInteger7 = bigInteger2.subtract(ONE);
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7);
        bigInteger8 = bigInteger4.modInverse(bigInteger8);
        bigInteger6 = bigInteger8.remainder(bigInteger6);
        bigInteger7 = bigInteger8.remainder(bigInteger7);
        BigInteger bigInteger9 = bigInteger2.modInverse(bigInteger3);
        return new ECUtil(new RSAKeyParameters(false, bigInteger, bigInteger4), new RSAPrivateCrtKeyParameters(bigInteger, bigInteger4, bigInteger8, bigInteger3, bigInteger2, bigInteger6, bigInteger7, bigInteger9));
    }
}

