//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "wlanadr.h"
#include <QDebug>
#include <QNetworkInterface>
#include <QHostAddress>


WlanIp::WlanIp(){
    this->ip_adr="300.300.300.300";
    this->bcast_adr="400.400.400.400";
    this->net_mask="500.500.500.500";
    this->ip_err=true;
    this->bcast_err=true;
    this->mask_err=true;
}
WlanIp::~WlanIp(){}

QString WlanIp::get_ip_adr(){
    return this->ip_adr;
}
QString WlanIp::get_net_mask(){
    return this->net_mask;
}
QString WlanIp::get_bcast_adr(){
    return this->bcast_adr;
}

bool WlanIp::get_ip_err(){
    return this->ip_err;
}
bool WlanIp::get_mask_err(){
    return this->mask_err;
}
bool WlanIp::get_bcast_err(){
    return this->bcast_err;
}

void WlanIp::set_adr(){

    QNetworkInterface intf=QNetworkInterface::interfaceFromName("wlan0");
    if(intf.addressEntries().size()>0){
        this->ip_adr=intf.addressEntries()[0].ip().toString();
        this->ip_err=false;
        this->bcast_adr=intf.addressEntries()[0].broadcast().toString();
        this->bcast_err=false;
        this->net_mask=intf.addressEntries()[0].netmask().toString();
        this->mask_err=false;

    }
    else {
        this->ip_adr="300.300.300.300";
        this->bcast_adr="400.400.400.400";
        this->net_mask="500.500.500.500";
        this->ip_err=true;
        this->bcast_err=true;
        this->mask_err=true;
    }
}

void WlanIp::set_adr(QString ipadr, QString netmask, QString bcast){
    QRegExp rx("[0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?");

    if (rx.exactMatch(ipadr)) {
        this->ip_adr=ipadr;
        this->ip_err=false;
    }
    if (rx.exactMatch(bcast)) {
        this->bcast_adr=bcast;
        this->bcast_err=false;
    }
    if (rx.exactMatch(netmask)) {
        this->net_mask=netmask;
        this->mask_err=false;
    }
}
