#ifndef TINYSMBCFG_H
#define TINYSMBCFG_H

#include <QObject>
#include <QString>
#include <QStringList>

class TinySmbCfg {
public:
    TinySmbCfg();
    TinySmbCfg(const TinySmbCfg&);
    TinySmbCfg(QString ip, QString snm, QString host, QString wrkgr, QString pwds, QString pwchk);
    ~TinySmbCfg();

    TinySmbCfg &operator=(const TinySmbCfg&);

    void set_ipadr(QString);
    void set_subnet(QString);
    void set_hostname(QString);
    void set_workgroup(QString);
    void set_passwords(QString);
    void set_passwd_check(QString);
    void set_all(QString ip, QString snm, QString host, QString wrkgr, QString pwds, QString pwchk);

    QString get_ipadr();
    QString get_subnet();
    QString get_hostname();
    QString get_workgroup();
    QString get_passwords();
    QString get_passwd_check();
    QStringList get_all();

private:
    QString ipaddress;
    QString subnetmask;
    QString hostname;
    QString workgroup;
    QString passwords;
    QString passwd_ckeck;
};

#endif // TINYSMBCFG_H
