//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "tinysmbcfg.h"

TinySmbCfg::TinySmbCfg(){
    this->ipaddress="";
    this->subnetmask="";
    this->hostname="";
    this->workgroup="";
    this->passwords="/etc/tinysmb/tinypasswd";
    this->passwd_ckeck="no";
}
TinySmbCfg::TinySmbCfg(const TinySmbCfg &src){
    this->ipaddress=src.ipaddress;
    this->subnetmask=src.subnetmask;
    this->hostname=src.hostname;
    this->workgroup=src.workgroup;
    this->passwords=src.passwords;
    this->passwd_ckeck=src.passwd_ckeck;
}

TinySmbCfg::TinySmbCfg(QString ip, QString snm, QString host="Nokia-N900", QString wrkgr="WORKGROUP", QString pwds="/etc/tinysmb/tinypasswd", QString pwchk="no"){
    this->ipaddress=ip;
    this->subnetmask=snm;
    this->hostname=host;
    this->workgroup=wrkgr;
    this->passwords=pwds;
    this->passwd_ckeck=pwchk;
}
TinySmbCfg::~TinySmbCfg(){}

TinySmbCfg &TinySmbCfg::operator =(const TinySmbCfg &src){
    this->ipaddress=src.ipaddress;
    this->subnetmask=src.subnetmask;
    this->hostname=src.hostname;
    this->workgroup=src.workgroup;
    this->passwords=src.passwords;
    this->passwd_ckeck=src.passwd_ckeck;
    return *this;
}

void TinySmbCfg::set_ipadr(QString ip){
    this->ipaddress=ip;
}
void TinySmbCfg::set_subnet(QString snm){
    this->subnetmask=snm;
}
void TinySmbCfg::set_hostname(QString host){
    this->hostname=host;
}
void TinySmbCfg::set_workgroup(QString wrkgr){
    this->workgroup=wrkgr;
}
void TinySmbCfg::set_passwords(QString pwds){
    this->passwords=pwds;
}
void TinySmbCfg::set_passwd_check(QString pwchk){
    this->passwd_ckeck=pwchk;
}
void TinySmbCfg::set_all(QString ip, QString snm, QString host="Nokia-N900", QString wrkgr="WORKGROUP", QString pwds="/etc/tinysmb/tinypasswd", QString pwchk="no"){
    this->ipaddress=ip;
    this->subnetmask=snm;
    this->hostname=host;
    this->workgroup=wrkgr;
    this->passwords=pwds;
    this->passwd_ckeck=pwchk;
}

QString TinySmbCfg::get_ipadr(){return this->ipaddress;}
QString TinySmbCfg::get_subnet(){return this->subnetmask;}
QString TinySmbCfg::get_hostname(){return this->hostname;}
QString TinySmbCfg::get_workgroup(){return this->workgroup;}
QString TinySmbCfg::get_passwords(){return this->passwords;}
QString TinySmbCfg::get_passwd_check(){return this->passwd_ckeck;}
QStringList TinySmbCfg::get_all(){
     QStringList tmpl;
     tmpl.append(this->ipaddress);
     tmpl.append(this->subnetmask);
     tmpl.append(this->hostname);
     tmpl.append(this->workgroup);
     tmpl.append(this->passwords);
     tmpl.append(this->passwd_ckeck);
     return tmpl;
}
