#ifndef TINYSHARE_H
#define TINYSHARE_H

#include <QObject>
#include <QString>

class TinyShare {
public:
    TinyShare();
    TinyShare(const TinyShare&);
    TinyShare(QString sname, QString pth, QString allw, QString allusr, QString acs);
    ~TinyShare();

    TinyShare &operator=(const TinyShare&);
    bool operator==(const TinyShare&);

    void set_share_name(QString sname);
    void set_path(QString pth);
    void set_allow(QString allw);
    void set_all_users(QString allusr);
    void set_access(QString acs);

    QString get_share_name();
    QString get_path();
    QString get_allow();
    QString get_all_users();
    QString get_access();

private:
    QString share_name;     // Example: "[MyShare]"
    QString path;           // Example: "/home/user/MyDocs"
    QString allow;          // Users who has access (Example: "thomas frank mike user_a user_b guest")
    QString all_users;      // "yes" or "no"
    QString access;         // "vo" = view only, "ro" = read only, "rw" = read and write access
};


#endif // TINYSHARE_H
