//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "settings.h"
#include "ui_settings.h"
#include <QDebug>

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);
    cfg.set_ipadr("10.0.0.1");
    cfg.set_subnet("255.0.0.0");
    cfg.set_hostname("Nokia-N900");
    cfg.set_workgroup("WORKGROUP");
    cfg.set_passwords("/etc/tinysmb/tinypasswd");
    cfg.set_passwd_check("no");
    labelrefresh();
}

Settings::~Settings()
{
    delete ui;
}

TinySmbCfg Settings::get_cfg(){
    return cfg;
}

void Settings::set_cfg(TinySmbCfg c){
    cfg=c;
    labelrefresh();
}

void Settings::labelrefresh(){
    adr.set_adr();
    if(adr.get_ip_adr()=="300.300.300.300"){
        ui->label_wlan->setText("Wlan offline?");

    }
    else ui->label_wlan->setText("");
    ui->lineEdit_ip->setText(cfg.get_ipadr());
    ui->lineEdit_snm->setText(cfg.get_subnet());
    ui->lineEdit_hname->setText(cfg.get_hostname());
    ui->lineEdit_wrkgr->setText(cfg.get_workgroup());

}

void Settings::on_pushButton_wlan_clicked()
{
    adr.set_adr();
    if(adr.get_ip_adr()=="300.300.300.300"){
        ui->label_wlan->setText("Wlan offline?");
        return;
    }
    else {
        cfg.set_ipadr(adr.get_ip_adr());
        cfg.set_subnet(adr.get_net_mask());
        ui->lineEdit_ip->setText(cfg.get_ipadr());
        ui->lineEdit_snm->setText(cfg.get_subnet());
        ui->label_wlan->setText("");
    }
}

void Settings::on_lineEdit_hname_editingFinished()
{
    QRegExp rx("\\w+-*\\w*");
    if(rx.exactMatch(ui->lineEdit_hname->text())) {
        cfg.set_hostname(ui->lineEdit_hname->text());
    }
    else ui->lineEdit_hname->setText(cfg.get_hostname());

}

void Settings::on_lineEdit_wrkgr_editingFinished()
{
    QRegExp rx("\\w+");
    if(rx.exactMatch(ui->lineEdit_wrkgr->text())) {
        cfg.set_workgroup(ui->lineEdit_wrkgr->text());
    }
    else ui->lineEdit_wrkgr->setText(cfg.get_workgroup());

}

void Settings::on_lineEdit_ip_editingFinished()
{
    QRegExp rx("[0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?");
    if(rx.exactMatch(ui->lineEdit_ip->text())) {
        cfg.set_ipadr(ui->lineEdit_ip->text());
    }
    else ui->lineEdit_ip->setText(cfg.get_ipadr());
}

void Settings::on_lineEdit_snm_cursorPositionChanged(int , int )
{
    QRegExp rx("[0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?[.][0-9][0-9]?[0-9]?");
    if(rx.exactMatch(ui->lineEdit_snm->text())){
        cfg.set_subnet(ui->lineEdit_snm->text());
    }
    else ui->lineEdit_snm->setText(cfg.get_subnet());

}

void Settings::on_pushButton_save_clicked()
{
    this->accept();
}
