//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "server.h"
#include <QDebug>


Server::Server(){
    this->status=this->get_server_status();
}
Server::~Server(){}

bool Server::get_status(){
    return status;
}

bool Server::get_server_status(){
    QString tmp="";     // temp QString for pgrep Output
    QProcess server;
    QByteArray output;  // temp QByteArray for QProcess readAll()
    server.setProcessChannelMode(QProcess::MergedChannels);
    server.start("pgrep tinysmbd");
    while(server.waitForReadyRead()){
        output+=server.readAll();
    }
    tmp=output;
    if(tmp!="") {
        this->status=true;
        return true;
    }
    this->status=false;
    return false;
}

void Server::start_server(){
    QProcess server;
    QByteArray output;  // temp QByteArray for QProcess readAll()
    server.setProcessChannelMode(QProcess::MergedChannels);
    server.start("sudo /etc/init.d/tinysmb start");
    while(server.waitForReadyRead()){
        output+=server.readAll();
    }
    //qDebug()<<output;
    get_server_status();
}

void Server::stop_server(){
    QProcess server;
    QByteArray output;  // temp QByteArray for QProcess readAll()
    server.setProcessChannelMode(QProcess::MergedChannels);
    server.start("sudo /etc/init.d/tinysmb stop");
    while(server.waitForReadyRead()){
        output+=server.readAll();
    }
    //qDebug()<<output;
    get_server_status();
}
