#ifndef TIMER_H
#define TIMER_H

#include <QtGui/QMainWindow>
#include <QtGui/QListWidgetItem>
#ifdef Q_WS_HILDON
#include "mnpPhonon.h"
#else // #ifdef Q_WS_HILDON
#include <phonon>
#endif // #ifdef Q_WS_HILDON

namespace Ui
{
  class timeout;
}

class timeout : public QMainWindow
{
  Q_OBJECT

enum TimerListMode { kListModeHours, kListModeMins, kListModeSecs, kListModeRingtones };

public:
  timeout(QWidget *parent = 0);
  ~timeout();

private slots:
  void on_btnMins_clicked();
  void on_btnHours_clicked();
  void on_btnSecs_clicked();
  void on_btnRingtones_clicked();
  void on_listWidget_itemSelectionChanged();
  void on_btnStart_clicked();
  void on_btnReset_clicked();

protected:
  virtual void timerEvent(QTimerEvent* event);

private: // methods
  void setupMusic();

private: // members
  Ui::timeout *ui;
  QStringList iTitles;
  int iTimerId;
  TimerListMode iListMode;

  Phonon::MediaObject* iMusic;

  // inital values when the start button gets pressed
  int iInitialSecs, iInitialMins, iInitialHours;

  int iSelectedSound;

};

#endif // TIMER_H
