#include "timeout.h"
#include "ui_timeout.h"
#include <QtGlobal>
#include <QtCore/QSignalMapper>
#include <QDir>


timeout::timeout(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::timeout)
{
  setupMusic();
  ui->setupUi(this);
  on_btnRingtones_clicked(); // the default list is the ringtone selector

  if (iTitles.count() != 0)
  {
    ui->lblMusic->setText(iTitles[0]);
  }
  else
  {
    ui->lblMusic->setText("<< empty >>");
  }

  ui->lblMusic->setFocusPolicy(Qt::NoFocus);
  ui->listWidget->setFocusPolicy(Qt::NoFocus);
  ui->btnStart->setFocusPolicy(Qt::NoFocus);
  ui->btnHours->setFocusPolicy(Qt::NoFocus);
  ui->btnMins->setFocusPolicy(Qt::NoFocus);
  ui->btnSecs->setFocusPolicy(Qt::NoFocus);
  ui->btnRingtones->setFocusPolicy(Qt::NoFocus);

  iMusic = NULL;

  iInitialSecs = 0;
  iInitialMins = 1;
  iInitialHours = 0;

  iSelectedSound = 0;

  iTimerId = 0;
}

timeout::~timeout()
{
  delete ui;
}

void timeout::setupMusic()
{
  iTitles.clear();
  QString path("/home/user/MyDocs/.sounds/Ringtones");
  QDir currentDir = QDir(path);
  currentDir.setNameFilters(QStringList("*.aac"));
  currentDir.setFilter(QDir::Files | QDir::NoSymLinks);
  currentDir.setSorting(QDir::Name);
  iTitles = currentDir.entryList();
  iTitles.replaceInStrings(".aac","");
}

void timeout::on_btnSecs_clicked()
{
  ui->listWidget->clear();
  iListMode = kListModeSecs;
  QListWidgetItem* listItem;
  for(int i = 0 ; i < 60 ; ++i)
  {
    QString str; str.setNum(i);
    listItem = new QListWidgetItem(str, ui->listWidget);
    ui->listWidget->addItem(listItem);
  }
  ui->listWidget->setCurrentRow(ui->lcdSecs->intValue());
}

void timeout::on_btnMins_clicked()
{
  ui->listWidget->clear();
  iListMode = kListModeMins;
  QListWidgetItem* listItem;
  for(int i = 0 ; i < 60 ; ++i)
  {
    QString str; str.setNum(i);
    listItem = new QListWidgetItem(str, ui->listWidget);
    ui->listWidget->addItem(listItem);
  }
  ui->listWidget->setCurrentRow(ui->lcdMins->intValue());
}

void timeout::on_btnHours_clicked()
{
  ui->listWidget->clear();
  iListMode = kListModeHours;
  QListWidgetItem* listItem;
  for(int i = 0 ; i < 24 ; ++i)
  {
    QString str; str.setNum(i);
    listItem = new QListWidgetItem(str, ui->listWidget);
    ui->listWidget->addItem(listItem);
  }
  ui->listWidget->setCurrentRow(ui->lcdHours->intValue());

}

void timeout::on_btnRingtones_clicked()
{
  setupMusic();
  ui->listWidget->clear();
  iListMode = kListModeRingtones;
  QListWidgetItem* listItem;
  for(int i = 0 ; i < iTitles.count() ; ++i)
  {
    listItem = new QListWidgetItem(iTitles[i], ui->listWidget);
    ui->listWidget->addItem(listItem);
  }
  ui->listWidget->setCurrentRow(iSelectedSound);
}

void timeout::on_listWidget_itemSelectionChanged()
{
  int itemSelected = ui->listWidget->currentRow();
  QListWidgetItem* listItem = ui->listWidget->item(itemSelected);

  switch (iListMode)
  {
    case kListModeRingtones:
    {
      // the sound (and the sound only) is saved when it gets selected
      iSelectedSound = itemSelected;
      ui->lblMusic->setText(listItem->text());
      break;
    }
    case kListModeHours:
    {
      ui->lcdHours->display(itemSelected);
      break;
    }
    case kListModeMins:
    {
      ui->lcdMins->display(itemSelected);
      break;
    }
    case kListModeSecs:
    {
      ui->lcdSecs->display(itemSelected);
      break;
    }
    default:
      break;
  }
}

void timeout::on_btnStart_clicked()
{
  QString text = ui->btnStart->text();
  if (text.compare(QString("Start")) == 0)
  {
    iTimerId = startTimer(1000);
    ui->btnStart->setText(QString("Stop"));
    iInitialSecs = ui->lcdSecs->intValue();
    iInitialMins = ui->lcdMins->intValue();
    iInitialHours = ui->lcdHours->intValue();
    // load the selected sound
    QString path("/home/user/MyDocs/.sounds/Ringtones/");
    path.append(ui->lblMusic->text()).append(".aac");
    iMusic = Phonon::createPlayer(Phonon::MusicCategory, Phonon::MediaSource(path));
  }
  else // the button was "Stop"
  {
    killTimer(iTimerId);
    iTimerId = 0;
    if (iMusic)
    {
      iMusic->stop();
      iMusic->clear();
    }
    ui->btnStart->setText(QString("Start"));
  }
}

void timeout::timerEvent(QTimerEvent* event)
{
  int secs = ui->lcdSecs->intValue();
  int mins = ui->lcdMins->intValue();
  int hours = ui->lcdHours->intValue();

  if (secs > 0) { secs--; }
  else if (mins > 0) // secs == 0
  {
    mins--;
    secs = 59;
  }
  else if (hours > 0) // mins == 0 && secs == 0
  {
    hours--;
    mins = 59;
    secs = 59;
  }
  // if everything is 0 let's play the music and and reset the counters
  if ((secs == 0) && (mins == 0) && (hours == 0)) // timeout expired
  {
    Q_ASSERT(iTimerId == event->timerId());
    if (iTimerId != 0)
    {
      killTimer(iTimerId);
      iTimerId = 0;
    }

    ui->btnStart->setText(QString("Start"));

    // play the music
    Q_ASSERT(iMusic);
    iMusic->play();
  }

  ui->lcdHours->display(hours);
  ui->lcdMins->display(mins);
  ui->lcdSecs->display(secs);
}

void timeout::on_btnReset_clicked()
{
  // stop the countdown if running
  if (iTimerId != 0)
  {
    killTimer(iTimerId);
    iTimerId = 0;
  }
  ui->btnStart->setText(QString("Start"));

  // stop the music, if playing
  if (iMusic)
  {
    iMusic->stop();
    iMusic->clear();
  }

  // reset the counters to the original value
  ui->lcdHours->display(iInitialHours);
  ui->lcdMins->display(iInitialMins);
  ui->lcdSecs->display(iInitialSecs);
}
