/*
    A Qt game based on Tic Tac Toe for Maemo
    Copyright (C) 2010  Victor Blazquez Francisco <victor.blazquez@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "shape.h"

#include <QPainter>
#include <QDebug>

Shape::Shape(int pos, QGraphicsItem* parent, Qt::WindowFlags wFlags): QGraphicsWidget(parent, wFlags)
{
	resize(100,100);
	
	int x = (pos%3) *100 -100;
	int y = (pos/3) *100 -100;
	setPos(x, y);
	addData(Positions, pos);
	addData(Shapes, Empty);
}

void Shape::addData(int kindOfData, int value)
{
	setData(kindOfData, value);
	
	if (kindOfData == Shapes && ( value == Human || value == Machine))
		update();
}

int Shape::getData(int kindOfData)
{
		return data(kindOfData).toInt();
}


void Shape::paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget)
{
	if (data(Shapes) == Machine)
		painter->drawPixmap(0,0 ,QPixmap("/usr/share/threetictac/x.png"));
	if (data(Shapes) == Human)
		painter->drawPixmap(0,0 ,QPixmap("/usr/share/threetictac/o.png"));
	
}

// #include "shape.moc"
