/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include <gtkmm/dialog.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/container.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/togglebutton.h>

#include "stdafx.hpp"
#include "OptionsDialog.hpp"



OptionsDialog::OptionsDialog(Gtk::Window &parent, bool theremin) :
		Gtk::Dialog("Options", parent, true),
		oneOctaveRadioButton("One octave"),
		twoOctavesRadioButton("Two octaves"),
		threeOctavesRadioButton("Three octaves"),
		lockCurrentOctaveCheckbox("Lock to tapped octave")
{
	Gtk::HBox *hBox = new Gtk::HBox();
	this->get_vbox()->add(*Gtk::manage(hBox));

	if(theremin){
		Gtk::Frame *fr = new Gtk::Frame("Number of octaves");
		hBox->add(*Gtk::manage(fr));

		Gtk::VBox *octavesBox = new Gtk::VBox();
		fr->add(*Gtk::manage(octavesBox));

		{//group octaves radio buttons
			Gtk::RadioButtonGroup gr = this->oneOctaveRadioButton.get_group();
			this->twoOctavesRadioButton.set_group(gr);
			this->threeOctavesRadioButton.set_group(gr);
		}
		octavesBox->add(this->oneOctaveRadioButton);
		this->oneOctaveRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
		octavesBox->add(this->twoOctavesRadioButton);
		this->twoOctavesRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
		octavesBox->add(this->threeOctavesRadioButton);
		this->threeOctavesRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
	}

	{
		Gtk::VBox *vbox = new Gtk::VBox();
		hBox->add(*Gtk::manage(vbox));

		Gtk::Frame *timbreFrame = new Gtk::Frame("Timbre");
		vbox->add(*Gtk::manage(timbreFrame));
		timbreFrame->add(this->timbreComboBox);

		this->timbreComboBox.set_size_request(-1, DFingerFriendlyMinSize());
		for(unsigned t = 0; t < unsigned(NUM_TIMBRES); ++t){
			this->timbreComboBox.append_text(TimbreTypeToName(E_Timbre(t)));
		}

		if(theremin){
			this->lockCurrentOctaveCheckbox.set_size_request(-1, DFingerFriendlyMinSize());
			vbox->add(this->lockCurrentOctaveCheckbox);
		}
	}

	this->add_button("Ok", Gtk::RESPONSE_OK);
	this->add_button("Cancel", Gtk::RESPONSE_CANCEL);

	this->show_all_children();//Show all window child widgets
}



unsigned OptionsDialog::GetNumOctaves()const{
	if(this->oneOctaveRadioButton.get_active())
		return 1;
	else if(this->twoOctavesRadioButton.get_active())
		return 2;
	else if(this->threeOctavesRadioButton.get_active())
		return 3;
	else
		return 0;
}



void OptionsDialog::SetNumOctaves(unsigned num){
	switch(num){
		case 1:
			this->oneOctaveRadioButton.set_active(true);
			break;
		case 2:
			this->twoOctavesRadioButton.set_active(true);
			break;
		case 3:
			this->threeOctavesRadioButton.set_active(true);
		default:
			break;
	}
}



E_Timbre OptionsDialog::GetTimbre()const{
	int sel = this->timbreComboBox.get_active_row_number();

	if(sel < 0 || sel >= int(NUM_TIMBRES))
		return SINE_PLUS_ADSR;

	return E_Timbre(sel);
}



void OptionsDialog::SetTimbre(E_Timbre timbre){
	this->timbreComboBox.set_active(int(timbre));
}



bool OptionsDialog::GetLockToTappedOctave()const{
	return this->lockCurrentOctaveCheckbox.get_active();
}



void OptionsDialog::SetLockToTappedOctave(bool lockToOctave){
	this->lockCurrentOctaveCheckbox.set_active(lockToOctave);
}
