/* The MIT License:

Copyright (c) 2010 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include <gtkmm/label.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>

#include <ting/debug.hpp>
#include <ting/Singleton.hpp>

#include "AboutDialog.hpp"

#ifndef M_NON_MAEMO_LINUX
#include "LibOSSO.hpp"
#endif



AboutDialog::AboutDialog(Gtk::Window &parent) :
		Gtk::Dialog("About", parent, true)
{
	Gtk::VBox *vbox = this->get_vbox();
	ASSERT(vbox)

	Gtk::Label *topLabel = new Gtk::Label();
	vbox->add(*Gtk::manage(topLabel));
	topLabel->set_markup(
			"<span foreground=\"darkred\" size=\"larger\">Maemo Theremin v1.8.1</span>\n"
			"\n"
			"A touchscreen musical instrument.\n"
		);


	Gtk::Label *middleLabel = new Gtk::Label();
	vbox->add(*Gtk::manage(middleLabel));
	middleLabel->set_markup(
			"<small>Project homepage:</small>"
		);

	{
		Gtk::Button *butt = new Gtk::Button();
		vbox->add(*Gtk::manage(butt));
		butt->signal_clicked().connect(
				sigc::mem_fun(*this, &AboutDialog::OpenHomePageInBrowser)
			);

		Gtk::Label *buttLabel = new Gtk::Label();
		butt->add(*Gtk::manage(buttLabel));
		buttLabel->set_markup(
				"<span foreground=\"darkblue\">http://theremin.garage.maemo.org</span>"
			);
	}


	Gtk::Label *bottomLabel = new Gtk::Label();
	vbox->add(*Gtk::manage(bottomLabel));
	bottomLabel->set_markup(
			"\n<small>Copyright 2010 Ivan Gagis &lt;igagis@gmail.com&gt;</small>"
		);


	this->add_button("Ok", 0);

	this->show_all_children();//Show all window child widgets
}



void AboutDialog::OpenHomePageInBrowser(){
#ifndef M_NON_MAEMO_LINUX
	try{
		LibOSSO::Inst().StartBrowser("http://theremin.garage.maemo.org");
	}catch(ting::Exc& e){
		//ignore. Normally, should not be thrown
		ASSERT(false)
	}
#endif
}

