#include <glibmm/dispatcher.h>

#include "utils.hpp"
#include "Preferences.hpp"


using namespace ting;



//static
std::string TimbreTypeToName(E_Timbre timbre){
	switch(timbre){
		default:
		case SINE_PLUS_ADSR:
			return "Sine Wave";
			break;
		case PLUCKED_STRING:
			return "Plucked String";
			break;
		case TROMBONE:
			return "Trombone";
			break;
		case CLARINET:
			return "Clarinet";
			break;
		case VIOLIN:
			return "Violin";
			break;
		case PIANO:
			return "Piano";
			break;
		case SAWTOOTH:
			return "Sawtooth";
			break;
		case THEREMIN:
			return "Theremin";
			break;
	}
}



//static
E_Timbre TimbreNameToType(std::string name){
	for(ting::uint t = 0; t < ting::uint(NUM_TIMBRES); ++t){
		if(TimbreTypeToName(E_Timbre(t)).compare(name) == 0)
			return E_Timbre(t);
	}
	return SINE_PLUS_ADSR;
}



GlibDispatcher::GlibDispatcher() :
		nextId(0)
{
	//connect dispatcher
	this->glibDispatcher.connect(
			sigc::mem_fun(*this, &GlibDispatcher::GlibDispatcherHandler)
		);
}



ting::uint GlibDispatcher::Connect(ting::Ptr<ting::Signal0> signal){
	Mutex::Guard mutexGuard(this->mutex);

	ting::uint id = this->nextId;

	this->sigMap.insert(std::pair<ting::uint, Ptr<Signal0> >(id, signal));

	++this->nextId;
	ASSERT(this->nextId != 0) //no warp
	
	return id;
}



void GlibDispatcher::Disconnect(ting::uint id){
	Mutex::Guard mutexGuard(this->mutex);

	T_SigIter i = this->sigMap.find(id);

	if(i == this->sigMap.end()){
		ASSERT_INFO(false, "signal id not found")
		return;
	}

	this->sigMap.erase(i);
}



void GlibDispatcher::GlibDispatcherHandler(){
	Mutex::Guard mutexGuard(this->mutex);

	ting::uint id = this->glibDispatcherArg.front();
	this->glibDispatcherArg.pop_front();

	T_SigIter i = this->sigMap.find(id);
	if(i == this->sigMap.end()){
		//signal id not found, probably it was disconnected
		TRACE(<< "GlibDispatcher::GlibDispatcherHandler(): signal id not found, probably it was disconnected" << std::endl)
		return;
	}

	i->second->Emit();
}



void GlibDispatcher::Emit(ting::uint id){
	Mutex::Guard mutexGuard(this->mutex);

	this->glibDispatcherArg.push_back(id);
	this->glibDispatcher.emit();
}



void MonotonicInstrumentHolder::ApplyTimbre(E_Timbre timbre){
	switch(timbre){
		default:
		case SINE_PLUS_ADSR:
			this->instr = aumiks::SineWaveInstrument::New();
			break;
		case PLUCKED_STRING:
			this->instr = aumiks::PluckedStringInstrument::New();
			break;
		case TROMBONE:
			this->instr = aumiks::TromboneInstrument::New();
			break;
		case CLARINET:
			this->instr = aumiks::ClarinetInstrument::New();
			break;
		case VIOLIN:
			this->instr = aumiks::ViolinInstrument::New();
			break;
		case PIANO:
			this->instr = aumiks::PianoInstrument::New();
			break;
		case SAWTOOTH:
			this->instr = aumiks::SawtoothInstrument::New();
			break;
		case THEREMIN:
			this->instr = aumiks::ThereminInstrument::New();
			break;
	}
}



E_Timbre MonotonicInstrumentHolder::GetCurrentTimbreType()const{
	if(this->instr.DynamicCast<aumiks::SineWaveInstrument>().IsValid()){
		return SINE_PLUS_ADSR;
	}else if(this->instr.DynamicCast<aumiks::PluckedStringInstrument>().IsValid()){
		return PLUCKED_STRING;
	}else if(this->instr.DynamicCast<aumiks::TromboneInstrument>().IsValid()){
		return TROMBONE;
	}else if(this->instr.DynamicCast<aumiks::ClarinetInstrument>().IsValid()){
		return CLARINET;
	}else if(this->instr.DynamicCast<aumiks::ViolinInstrument>().IsValid()){
		return VIOLIN;
	}else if(this->instr.DynamicCast<aumiks::PianoInstrument>().IsValid()){
		return PIANO;
	}else if(this->instr.DynamicCast<aumiks::SawtoothInstrument>().IsValid()){
		return SAWTOOTH;
	}else if(this->instr.DynamicCast<aumiks::ThereminInstrument>().IsValid()){
		return THEREMIN;
	}else{
		ASSERT_INFO(false, "unknown instrument")
		return SINE_PLUS_ADSR;
	}
}



void MonotonicInstrumentHolder::Stop(){
	if(this->ch.IsValid()){
		this->ch->Stop();
	}
}



