// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import QtWebKit 1.0

Item
{
    id : register_item
    property int mobileView : tepee.mobileRes
    width: main_win_rec.width - (2 * mobileView)
    height: main_win_rec.height -(2 * mobileView)
    y : mobileView
    x : mobileView

    Item
    {
        id : account_check_item
        opacity: 1
        Behavior on opacity {NumberAnimation {duration : 500}}
        anchors.fill: parent
        Rectangle
        {
            anchors.fill: parent
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 15
        }
        Text
        {
            anchors.centerIn: parent
            text : "Have you got a tepee account ?"
            color : "white"
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
        }
        Button
        {
            id : yesButton
            anchors.bottom: parent.bottom
            anchors.bottomMargin: mobileView
            anchors.right: parent.horizontalCenter
            buttonColor: "blue"
            buttonShape: "rectangle"
            text : "Yes"
            resImg : tepee.mobileRes
            opacity : 1
            onButtonClicked:
            {
                menu_settings.source =  "SettingsMenu.qml"
            }
        }
        Button
        {
            id : noButton
            anchors.bottom: parent.bottom
            anchors.bottomMargin: tepee.mobileRes
            anchors.left  : parent.horizontalCenter
            buttonColor: "red"
            buttonShape: "rectangle"
            text : "No"
            resImg : tepee.mobileRes
            numId : 171
            opacity : 1
            onButtonClicked:
            {
                account_check_item.opacity = 0;
                register_web.opacity = 1;
            }
        }
    }
    Item
    {
        id : register_web
        opacity : 0
        anchors.fill: parent
        Behavior on opacity {NumberAnimation {duration : 500}}

        Item
        {
            id : webbrowser
            anchors.fill: parent
            Flickable
            {
                id : webview_flick
                anchors.fill: parent
//                anchors.topMargin: tepee.mobileRes * 4 / 5
//                anchors.bottomMargin: tepee.mobileRes / 8
//                anchors.leftMargin: 2
//                anchors.rightMargin: 2
                contentWidth : web.width
                contentHeight: web.height
                clip : true;
                boundsBehavior: Flickable.StopAtBounds

                WebView
                {
                    id : web
                    preferredWidth :  main_win_rec.width - (2 * mobileView)
                    preferredHeight:  main_win_rec.height - (2 * mobileView)
                    url : "http://tepee.epitech-nantes.fr/siteTepee/register.php"
                    onLoadFinished:
                    {
                        if (web.url ==  "http://tepee.epitech-nantes.fr/siteTepee/index.php")
                            menu_settings.source =  "SettingsMenu.qml"

                    }
                    onLoadFailed:
                    {
                        failLoad.opacity = 1;

                        webbrowser.opacity = 0;
                    }

                }

                states:
                    [
                    State
                    {
                        name: "ShowBarsWeb"
                        when: webview_flick.movingVertically || webview_flick.movingVertically
                        PropertyChanges { target: verticalScrollBarWeb; opacity: 1 }
                        PropertyChanges { target: horizontalScrollBarWeb; opacity: 1}
                    }
                ]
            }

            states:
                State   {
                name : "full_web"
                when : web_item.fullscreen
                PropertyChanges {
                    target: web_item;
                    width : main_win_rec.width;
                    height : main_win_rec.height;
                    x : -tepee.mobileRes
                    y : -tepee.mobileRes
                }
            }

            transitions: Transition {
                NumberAnimation { target: web_item; property: "height"; duration: 250 }
                NumberAnimation { target: web_item; property: "width"; duration: 250 }
                NumberAnimation { target: web_item; property: "x"; duration: 250 }
                NumberAnimation { target: web_item; property: "y"; duration: 250 }
            }
            ScrollBar
            {
                id: verticalScrollBarWeb
                width: 12; height: webview_flick.height-12
                anchors.right: webview_flick.right
                anchors.top: webview_flick.top
                opacity: 0
                orientation: Qt.Vertical
                position: webview_flick.visibleArea.yPosition
                pageSize: webview_flick.visibleArea.heightRatio
            }

            ScrollBar
            {
                id: horizontalScrollBarWeb
                width: webview_flick.width-12; height: 12
                anchors.bottom: webview_flick.bottom
                opacity: 0
                orientation: Qt.Horizontal
                position: webview_flick.visibleArea.xPosition;
                pageSize: webview_flick.visibleArea.widthRatio
            }

        }
        Text
        {
            id : failLoad
            anchors.centerIn: parent
            opacity :0
            text : "Service not available"
            color : "white"
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
        }


    }

}
