#include "appcontroler.h"

AppControler::AppControler() : QObject()
{
    this->donefile = 0;
    this->totalfile = 0;
    this->connect = false;
    this->isSetting = false;
    this->isInfo = false;
    this->servPort = 20004;
    this->servAddr = "tepee.epitech-nantes.fr";
    this->styleOpacity = 0.4;
    this->cT = new ConnectionThread;
    this->notes = new NoteLogic;
    this->books = new BookMarkLogic;
    this->agenda = new AgendaLogic;
    this->contacts = new ContactLogic;
    this->weather = new weatherlogic;
    this->fileftp = new Filelogic;
    this->event = new eventLogic;
    this->visibilityUser = false;
    // CONNECTION BETWEEN EACH MODULE AND THE DATABASE
    QObject::connect(this->books, SIGNAL(SendQueryBM(QString,int)), this->cT, SIGNAL(queryBM(QString,int)));
    QObject::connect(this->cT, SIGNAL(retQueryBm(QList<QSqlRecord>,int)), this->books, SLOT(rcvBM(QList<QSqlRecord>,int)));
    QObject::connect(this, SIGNAL(queryApp(QString,int)), this->cT, SIGNAL(queryBM(QString,int)));
    QObject::connect(this->cT, SIGNAL(retQueryBm(QList<QSqlRecord>,int)), this, SLOT(retQuerySetting(QList<QSqlRecord>,int)));
    QObject::connect(this->notes, SIGNAL(SendQueryNote(QString,int)), this->cT, SIGNAL(queryBM(QString,int)));
    QObject::connect(this->cT, SIGNAL(retQueryBm(QList<QSqlRecord>,int)), this->notes, SLOT(rcvNote(QList<QSqlRecord>,int)));
    QObject::connect(this->contacts, SIGNAL(SendQueryContact(QString,int)), this->cT, SIGNAL(queryBM(QString,int)));
    QObject::connect(this->cT, SIGNAL(retQueryBm(QList<QSqlRecord>,int)), this->contacts, SLOT(rcvContact(QList<QSqlRecord>,int)));
    QObject::connect(this->weather, SIGNAL(SendQueryW(QString,int)), this->cT, SIGNAL(queryBM(QString,int)));
    QObject::connect(this->cT, SIGNAL(retQueryBm(QList<QSqlRecord>,int)), this->weather, SLOT(rcvW(QList<QSqlRecord>,int)));
    QObject::connect(this->fileftp, SIGNAL(dataProgress(qint64,qint64)), this, SLOT(updateDataProgress(qint64,qint64)));
    QObject::connect(this->agenda, SIGNAL(SendQueryAgenda(QString,int)), this->cT, SIGNAL(queryBM(QString,int)));
    QObject::connect(this->cT, SIGNAL(retQueryBm(QList<QSqlRecord>,int)), this->agenda, SLOT(rcvTask(QList<QSqlRecord>,int)));
    QObject::connect(this->cT, SIGNAL(synchingProgress(QVariant)), this, SIGNAL(synchingProgress(QVariant)));
    QObject::connect(this->event, SIGNAL(SendQueryEvent(QString,int)), this->cT, SIGNAL(queryBM(QString,int)));
    QObject::connect(this->cT, SIGNAL(retQueryBm(QList<QSqlRecord>,int)), this->event, SLOT(rcvEvent(QList<QSqlRecord>,int)));
}

AppControler::~AppControler()
{
}

void       AppControler::initDBLoading()
{
    this->checkSetting();
    this->LoadInfoUserDBApp();
    this->LoadBMfromDBApp();
    this->LoadNotefromDBApp();
    this->LoadContactfromDBApp();
    this->LoadLocationWeatherfromDBApp();
    this->LoadTasksfromDBApp();
    this->LoadEventfromDBApp();
}

ListModel* AppControler::getClientNotes()
{
    return (this->notes->getNotesModel());
}

bool    AppControler::addNote(QString t, QString c)
{
    return (this->notes->addNote(t, c));
}

void    AppControler::setInfoUser(QString firstName, QString lastName, QString hnum, QString cnum, QString email, QString addr, bool visibility)
{
    QString query = "";
    if (this->isInfo)
        query = "UPDATE infouser SET lastup = '" + QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz") + "',firstname = '" + firstName + "', lastname = '" + lastName + "', mail = '" + email + "', adress = '" + addr + "', homephone = '" + hnum + "', cellphone = '" + cnum + "', visibility = " + QString::number((visibility) ? PUBLIC : PRIVATE) + " WHERE firstname ='" + this->firstNameUser + "'";
    else
    {
        QString curTime = QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        if (!firstName.isEmpty() && !lastName.isEmpty())
            query = "INSERT INTO infouser (firstname, lastname, mail, adress, homephone, cellphone, birthday, id, lastup, status, visibility) VALUES ( '" + firstName + "','" + lastName + "','" + email + "','" + addr+ "','" + hnum + "','" + cnum + "','" + "222222222" + "','" + curTime + "','" + curTime + "', " + QString::number(VALID) + " ," + QString::number((visibility) ? PUBLIC : PRIVATE) + ")";
    }
    emit (queryApp(query, SETUSERINFO));
}

void    AppControler::LoadInfoUserDBApp()
{
    QString q = "SELECT * FROM infouser";
    emit(queryApp(q, FILLUSERINFO));
}

bool     AppControler::getUserVisibility() const
{
    return this->visibilityUser;
}

QString AppControler::getUserFirstName() const
{
    return this->firstNameUser;
}

QString AppControler::getUserLastName() const
{
    return this->lastNameUser;
}

QString AppControler::getUserHNum() const
{
    return this->hNumUser;
}

QString AppControler::getUserCNum() const
{
    return this->cNumUser;
}

QString AppControler::getUserEmail() const
{
    return this->emailUser;
}

QString AppControler::getUserAddress() const
{
    return this->addressUser;
}

void    AppControler::LoadBMfromDBApp()
{
    this->books->LoadBMfromDB();
}

void    AppControler::LoadLocationWeatherfromDBApp()
{
    this->weather->LoadWeatherLocation();
}

void    AppControler::LoadNotefromDBApp()
{
    this->notes->LoadNote();
}

void    AppControler::LoadContactfromDBApp()
{
    this->contacts->LoadContactfromDB();
}

void    AppControler::LoadTasksfromDBApp()
{
    this->agenda->loadTasksFromDB();
}

void    AppControler::LoadEventfromDBApp()
{
    this->event->loadEventsFromDB();
}

void    AppControler::LoadWeatherfromDBapp()
{
    this->weather->LoadWeatherfromDB(this->city, this->country);
}

void AppControler::deleteDBWeather(QString country, QString city)
{
    this->weather->deleteDBday(country, city);
}

void AppControler::setWeatherDay(int numday , int nummonth, int numyear , QString nameday, QString namemonth, int highttemp, int lowtemp, QString conditions, QString country, QString city)
{
    this->weather->setWeatherDay(numday, nummonth,numyear, nameday, namemonth,highttemp,lowtemp,conditions, country, city);
}

void    AppControler::editNote(QString a, QString b, int c)
{
    this->notes->editNote(a, b, c);
}

void    AppControler::removeNote(int d)
{
    this->notes->removeNote(d);
}

ListModel* AppControler::getfileftpMod()
{
    return (this->fileftp->getfileftpMod());
}

ListModel* AppControler::getBookMarksMod()
{
    return (this->books->getBookMarksModel());
}

ListModel * AppControler::getweatherMod()
{
    return this->weather->getWeatherModel();
}

ListModel * AppControler::getweatherLocationMod()
{
    return this->weather->getWeatherLocationModel();
}

ListModel *        AppControler::getEventModel()
{
    return this->event->getEventModel();
}

void                AppControler::addEvent(QString title_, QString description_, QString country_, QString city_, QString date_, QString hour_, QString creatorFName_, QString creatorLName_, QString contactList_)
{
    this->event->addEvent(title_, description_, country_, city_, date_, hour_, creatorFName_, creatorLName_, contactList_);
}

void                AppControler::editEvent(QString title_, QString description_, QString country_, QString city_, QString date_, QString hour_, QString creatorFName_, QString creatorLName_, QString contactList_, int id)
{
    this->event->editEvent(title_, description_, country_, city_, date_, hour_, creatorFName_, creatorLName_, contactList_, id);
}

void                AppControler::removeEvent(int id)
{
    this->event->rmEvent(id);
}

bool        AppControler::addBookMark(QString t, QString c)
{
    return (this->books->addBookMark(t, c));
}

void        AppControler::editBookMark(QString t, QString c, int i)
{
    this->books->editBookMark(t, c, i);
}

void        AppControler::removeBookMark(int i)
{
    this->books->removeBookMark(i);
}

void        AppControler::addTask(QString t, QString c, int hs, int ms, int ds, int mts, int ys, int he, int me, int de, int mte, int ye)
{
    std::cout << "ADDING TASK" << std::endl;
    this->agenda->addTask(t, c, hs, ms, ds, mts, ys, he, me, de, mte, ye);
}

void        AppControler::editTask(QString t, QString c, int hs, int ms, int ds, int mts, int ys, int he, int me, int de, int mte, int ye, int id)
{
    std::cout << "EDITING TASK " << id << std::endl;
    this->agenda->editTask(t, c, hs, ms, ds, mts, ys, he, me, de, mte, ye, id);
}

void        AppControler::rmTask(int id)
{
    std::cout << "<<<<<<<<<<<<<<<<<<RM IN APP <<<<<<<<<<<<<<<<" << std::endl;
    this->agenda->removeTask(id);
}

ListModel   *AppControler::getTaskModel()
{
    return this->agenda->getCurTaskModel();
}

ListModel   *AppControler::getWeekTaskModel()
{
    return this->agenda->getCurWeekTaskModel();
}

void        AppControler::setTaskModelDate(int currentDay, int currentMonth, int currentYear)
{
    this->agenda->setTaskModelDate(currentDay, currentMonth, currentYear);
}

ListModel*  AppControler::getContactsMod()
{
    return (this->contacts->getContactModel());
}

bool        AppControler::addContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, bool fr, QString uc)
{
    if (fr)
        std::cout << "ADDDDDDDDDDDDDDDDDDDDDDDDDDD CONT true USERNAMEEEEE " << uc.toStdString()  << std::endl;
    else
        std::cout << "ADDDDDDDDDDDDDDDDDDDDDD NOT FRIEND" << std::endl;
    return this->contacts->addContact(f, l, e, a, h, c, i, d, fr, uc);
}

void        AppControler::editContact(QString f, QString l, QString e, QString a, QString h, QString c, QString i, QDate d, int id)
{
    this->contacts->editContact(f, l, e, a, h, c, i, d, id);
}

void        AppControler::removeContact(int id)
{
    this->contacts->removeContact(id);
}


void        AppControler::setServerSetting(QString u, QString p, QString add, QString po, QString ba, QColor cS, double Opacity)
{
    this->userName = u;
    this->userPass = p;
    this->servAddr = QUrl(add);
    this->servPort = po.toInt();
    this->background = ba;
    this->styleColor = cS;
    this->styleOpacity = Opacity;
    QString query;
    if  (!this->isSetting)
    {
        std::cout << "INSERT SET" << std::endl;
        query += "INSERT INTO settings (username, password, adress, port, background, styleColor, styleOpacity) VALUES ('" ;
        query += u;
        query += "','";
        query += p;
        query += "','";
        query += add;
        query += "','";
        query += po;
        query += "','";
        query += ba;
        query += "','";
        query += this->styleColor.name();
        query += "',";
        query += QString::number(this->styleOpacity);
        query += ")";
        this->isSetting = true;
    }
    else
    {
        std::cout << "UPDATE SET" << std::endl;
        query += "UPDATE  settings SET username = '";
        query += u;
        query += "', password = '";
        query += p;
        query += "', adress ='";
        query += add;
        query += "',port ='";
        query += po;
        query += "',background ='";
        query += ba;
        query += "', styleColor ='";
        query += this->styleColor.name();
        query += "', styleOpacity =";
        query += QString::number(this->styleOpacity);
    }
    emit (queryApp(query,SETSETTING));
}

QColor      AppControler::getStyleColor()
{
    return this->styleColor;
}

double      AppControler::getStyleOpacity()
{
    return this->styleOpacity;
}

void        AppControler::checkSetting()
{
    QString query;

    query = "SELECT * FROM settings";
    emit(queryApp(query, ASKSETTINGCONF));
}

void AppControler::retQuerySetting(QList<QSqlRecord> q, int i)
{
    if (i == ASKSETTINGCONF)
    {
        bool set = false;
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        if (it != q.end())
        {
            if ((*it).value("username").toString().size() > 0)
            {
                std::cout << "1111111111111111111 "<< std::endl;
                this->userName = (*it).value("username").toString();
                this->userPass = (*it).value("password").toString();
                this->servPort = (*it).value("port").toInt();
                this->servAddr = QUrl((*it).value("adress").toString());
                this->background = (*it).value("background").toString();
                this->city = (*it).value("city").toString();
                this->country = (*it).value("country").toString();

                this->styleColor = QColor((*it).value("styleColor").toString());
                this->styleOpacity = (*it).value("styleOpacity").toDouble();
                std::cout << "IN SETING" << std::endl;
                set = true;

                std::cout << "222222222222222222222222222 "<< std::endl;
                // LOAD METEO
                if (!this->isSetting)
                {
                    this->LoadWeatherfromDBapp();
                    std::cout << "APP LOAD WEATHER" << std::endl;
                }
            }
        }
        this->isSetting = set;
    }
    if (i == FILLUSERINFO)
    {
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        if (it != q.end())
        {
            this->firstNameUser = (*it).value("firstname").toString();
            if (!(*it).value("id").toString().isEmpty())
                this->isInfo = true;
            this->lastNameUser = (*it).value("lastname").toString();
            this->emailUser = (*it).value("mail").toString();
            this->addressUser = (*it).value("adress").toString();
            this->hNumUser = (*it).value("homephone").toString();
            this->cNumUser = (*it).value("cellphone").toString();
            this->visibilityUser = ((*it).value("visibility").toInt() == PUBLIC) ? true : false;
            ++it;
        }
    }
}

bool       AppControler::getSettingSet()
{
    return this->isSetting;
}

QString       AppControler::getCity()
{
    return this->city;
}

QString       AppControler::getCityDefaults()
{
    return this->cityDefaults;
}

QString       AppControler::getUsername()
{
    return this->userName;
}

QString       AppControler::getCountry()
{
    return this->country;
}

QString       AppControler::getCountryDefaults()
{
    return this->countryDefaults;
}

QString       AppControler::getpassword()
{
    return this->userPass;
}


QString       AppControler::getAdress()
{
    std::cout << "qwerty"<< std::endl;
    return this->servAddr.toString();
       std::cout << "qwerty2"<< std::endl;
}

QString       AppControler::getPort()
{
    return QString::number(this->servPort);
}

QString       AppControler::getBackGround()
{
    return this->background;
}

void        AppControler::syncWithServer()
{
    //    this->cT->initConnection(this->servAddr, this->servPort);
    this->cT->initSyncServer(this->servAddr.toString(), this->servPort, this->userName, this->userPass);
}

bool        AppControler::restoreModelsFromDB()
{
    return true;
}

void         AppControler::setCountry(QString a)
{
    this->country = a;
}

void         AppControler::setCity(QString a)
{
    this->city = a;
}

void         AppControler::setCountryDefaults(QString a)
{
    this->countryDefaults = a;
}

void         AppControler::setCityDefaults(QString a)
{
    this->cityDefaults = a;
}

void        AppControler::addNewLocation(QString country, QString city)
{
    this->weather->addWeatherLocation(country, city);
}

void        AppControler::deleteWeatherFromListViewAp()
{
    this->weather->deleteWeatherFromListView();
}

void AppControler::deleteWeatherLocationFromListView()
{
    this->weather->deleteWeatherLocationFromListView();
}

void AppControler::deleteWeatherLocationFromDb(QString country, QString city)
{
    this->weather->deleteWeatherLocationfromDb(country,city);
}

void AppControler::connectToFtp()
{
    if (this->isSetting)
    {
        this->fileftp->connectToFtp(this->userName, this->userPass, this->servAddr);
    }
}

void AppControler::dowloadFile(QString name)
{
    this->fileftp->dowloadFile(name);
}

void AppControler::delFile(QString name, int id)
{
    this->fileftp->delFile(name, id);
}

void AppControler::updateDataProgress(qint64 donee,qint64 totall)
{
    this->donefile = donee;
    this->totalfile = totall;
}

qint64 AppControler::getTotal()
{
    return this->totalfile;
}

qint64 AppControler::getDone()
{
    return this->donefile;
}

void AppControler::setDone(qint64 a)
{
    std::cout << "SET DONE = " << a << std::endl;
    this->donefile = a;
}
void AppControler::setTotal(qint64 a)
{
    std::cout << "SET TOTAL = " << a << std::endl;
    this->totalfile = a;
}
void AppControler::listFile()
{
    this->fileftp->listFile();
}

void AppControler::openFile(QString s)
{
    std::cout << "open " << s.toStdString() << std::endl;
    QDesktopServices::openUrl(QUrl(s.toStdString().c_str(), QUrl::TolerantMode));
}

QString AppControler::getDirFtp()
{
    std::cout << "PATH " << this->fileftp->getDirFtp().toStdString()<< std::endl;
    return this->fileftp->getDirFtp();
}

void AppControler::uploadFile(QString filename)
{
    this->fileftp->uploadFile(filename);
}


