#ifndef AGENDALOGIC_H
#define AGENDALOGIC_H

#include <QDateTime>
#include <QString>
#include <QAbstractListModel>
#include <QDateTime>
#include "listmodel.h"
#include "Description.h"
#include <QList>
#include <QSqlRecord>


class TaskElem : public ListItem
{
    Q_OBJECT
public :
    enum TaskRoles
    {
        taskName = Qt::UserRole + 1,
        taskStartHour,
        taskStartMin,
        taskStartDay,
        taskStartMonth,
        taskStartYear,

        taskEndHour,
        taskEndMin,
        taskEndDay,
        taskEndMonth,
        taskEndYear,

        taskComment,
        taskId
    };

    TaskElem(QObject *p = 0);
    TaskElem(QString idT, QString name, QString comment,
             int hoursStart, int minStart, int dayStart,
             int monthStart, int yearStart,
             int hourEnd, int minEnd,
             int dayEnd, int monthEnd, int yearEnd,
             int id = -1, QObject *p = 0);

    int     id() const;
    QString getTaskName()       const;
    QString getTaskComment()    const;
    QString getIdTime()         const;

    int     getHourStart()      const;
    int     getMinStart()      const;
    int     getDayStart()       const;
    int     getMonthStart()     const;
    int     getYearStart()      const;

    int     getDayEnd()         const;
    int     getMonthEnd()         const;
    int     getYearEnd()         const;
    int     getHourEnd()         const;
    int     getMinEnd()         const;

    QVariant    data(int role) const;
    QHash<int, QByteArray> roleNames() const;

    void    setTaskName(QString);
    void    setComment(QString);
    void    setHourStart(int);
    void    setHourEnd(int);
    void    setMinStart(int);
    void    setMinEnd(int);
    void    setDayStart(int);
    void    setDayEnd(int);
    void    setMonthStart(int);
    void    setMonthEnd(int);
    void    setYearStart(int);
    void    setYearEnd(int);

private :
    int task_id;
    static int nextId;

    QString     task_name;
    QString     task_comment;
    QString     idTime;

    int         task_start_hour;
    int         task_start_min;
    int         task_start_day;
    int         task_start_month;
    int         task_start_year;

    int         task_end_hour;
    int         task_end_min;
    int         task_end_day;
    int         task_end_month;
    int         task_end_year;

};

// A PARTIR DE LA LISTE DES TASK, DE LEUR DATE DE DEBUT ET DE FIN, DAY ELEM VERIFIERA SI UNE OU PLUSIEURS TASKS ONT LIEUX SUR UNE JOURNEE

class AgendaLogic : public QObject
{
    Q_OBJECT
signals :
    void    SendQueryAgenda(QString query, int);

private :
    ListModel*  taskModel;
    ListModel*  curDayTaskModel;
    ListModel*  curWeekTaskModel;

    void        updateDayModel();
    void        updateWeekModel();
    QDate       curDate;

public:
    AgendaLogic();
    ListModel*  getCurTaskModel();
    ListModel*  getCurWeekTaskModel();
    void        setTaskModelDate(int d, int m, int y);
    void        addTask(QString, QString, int, int, int, int, int, int, int, int, int, int);
    void        editTask(QString, QString, int, int, int, int, int, int, int, int, int, int, int);
    void        removeTask(int taskId);
    void        loadTasksFromDB();
public slots :
    void        rcvTask(QList<QSqlRecord>, int);
};



#endif // AGENDALOGIC_H
