#include "Command.h"

Command::Command()
{
    this->valid = false;
    this->TabCmdHead[HEADERNOTE] = &Command::SaveHeaderNote;
    this->TabCmdHead[HEADERFILE] = &Command::SaveHeaderFile;
    this->TabCmdHead[HEADERCONTACT] = &Command::SaveHeaderContact;
    this->TabCmdHead[HEADERBOOKMARK] = &Command::SaveHeaderBookmark;
    this->TabCmdHead[HEADERAGENDA] = &Command::SaveHeaderAgenda;
    this->TabCmdHead[HEADERWEATHER] = &Command::SaveHeaderWeather;
    this->TabCmdHead[HEADERSETTING] = &Command::SaveHeaderSetting;
    this->TabCmdHead[HEADEREVENT] = &Command::SaveHeaderEvent;
    this->TabCmdHead[HEADERSYS] = &Command::SaveHeaderSys;
    this->n = NULL;
    this->f = NULL;
    this->c = NULL;
    this->b = NULL;
    this->a = NULL;
    this->w = NULL;
    this->se = NULL;
    this->e = NULL;
    this->sy = NULL;
    this->TabConvert[HEADERNOTE] = &Command::ConvertToAnswerNote;
    this->TabConvert[HEADERFILE] = &Command::ConvertToAnswerFile;
    this->TabConvert[HEADERCONTACT] = &Command::ConvertToAnswerContact;
    this->TabConvert[HEADERBOOKMARK] = &Command::ConvertToAnswerBookmark;
    this->TabConvert[HEADERAGENDA] = &Command::ConvertToAnswerAgenda;
    this->TabConvert[HEADERWEATHER] = &Command::ConvertToAnswerWeather;
    this->TabConvert[HEADERSETTING] = &Command::ConvertToAnswerSetting;
    this->TabConvert[HEADEREVENT] = &Command::ConvertToAnswerEvents;
    this->TabConvert[HEADERSYS] = &Command::ConvertToAnswerSys;
}


unsigned char *Command::ConvertToAnswer()
{
    if (this->TabConvert.find(this->IdHeader) != this->TabConvert.end())
        return ((this->*this->TabConvert[this->IdHeader])());
    return NULL;
}

bool Command::isCommandValid() const
{
    return this->valid;
}


int Command::getSize() const
{
    return this->size;
}

int Command::getIdCmd() const
{
    return this->IdCmd;
}

int Command::getIdHeader() const
{
    return this->IdHeader;
}


void Command::setIdCmd(int a)
{
    this->IdCmd = a;
}

void Command::setIdHeader(int a)
{
    this->IdHeader = a;
}

void Command::setSize(int a)
{
    this->size = a;
}

int	Command::parseCmd(unsigned char *data, int sizecmd)
{
    std::cout << "PARSING COMMAND" << std::endl;
    std::cout << "SIZECMD = " << sizecmd << " sieof(command) =" << sizeof(command) << std::endl;
    std::cout << "SIZE CMD " << sizecmd << " SIZE OF COMMAND " << sizeof(command) << std::endl;
    if ((unsigned int)sizecmd <= sizeof(command) || data == NULL)
    {
        std::cout << "command size not ok" << std::endl;
        return 0;
    }
    unsigned char buff[sizeof(command)];
    memcpy(buff, data, sizeof(command));
    command *c = (command*)buff;
    this->IdHeader = c->idHeader;
    data += sizeof(command);
    if (this->TabCmdHead.find(this->IdHeader) != this->TabCmdHead.end())
    {
        std::cout << "CALLING CMD HEADER TAB " << std::endl;
        return ((this->*this->TabCmdHead[this->IdHeader])(data, sizecmd));
    }
    else
    {
        std::cout << "RETURN SIZE BECAUSE HEADER NOT IN CMD HEADER TAB " << std::endl;
        return sizecmd;
    }
    return 0;
}


int Command::SaveHeaderNote(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(note)))
    {
        unsigned char *buff = new unsigned char[sizeof(note)];
        memcpy(buff, data, sizeof(note));
        this->n = (note*)buff;
        this->valid = true;
        this->IdCmd = n->idCmd;
        this->size = (sizeof(command) + sizeof(note));
        return (sizeof(command) + sizeof(note));
    }
    return 0;
}

int Command::SaveHeaderFile(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(file)))
    {
        unsigned char *buff = new unsigned char[sizeof(file)];
        memcpy(buff, data, sizeof(file));
        this->f = (file*)buff;
        this->valid = true;
        this->IdCmd = f->idCmd;
        this->size = (sizeof(command) + sizeof(file));
        return (sizeof(command) + sizeof(file));
    }
    return 0;
}

int Command::SaveHeaderContact(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(contact)))
    {
        unsigned char *buff = new unsigned char[sizeof(contact)];
        memcpy(buff, data, sizeof(contact));
        this->c = (contact*)buff;
        this->valid = true;
        this->IdCmd = c->idCmd;
        this->size = (sizeof(command) + sizeof(contact));
        return (sizeof(command) + sizeof(contact));
    }
    return 0;
}

int Command::SaveHeaderBookmark(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(bookmark)))
    {
        unsigned char *buff = new unsigned char[sizeof(bookmark)];
        memcpy(buff, data, sizeof(bookmark));
        this->b = (bookmark*)buff;
        this->valid = true;
        this->IdCmd = b->idCmd;
        this->size = (sizeof(command) + sizeof(bookmark));
        return (sizeof(command) + sizeof(bookmark));
    }
    return 0;
}

int Command::SaveHeaderAgenda(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(agenda)))
    {
        unsigned char *buff = new unsigned char[sizeof(agenda)];
        memcpy(buff, data, sizeof(agenda));
        this->a = (agenda*)buff;
        this->valid = true;
        this->IdCmd = a->idCmd;
        this->size = (sizeof(command) + sizeof(agenda));
        return (sizeof(command) + sizeof(agenda));
    }
    return 0;
}
int Command::SaveHeaderWeather(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(weather)))
    {
        unsigned char *buff = new unsigned char[sizeof(weather)];
        memcpy(buff, data, sizeof(weather));
        this->w = (weather*)buff;
        this->valid = true;
        this->IdCmd = w->idCmd;
        this->size = (sizeof(command) + sizeof(weather));
        return (sizeof(command) + sizeof(weather));
    }
    return 0;
}
int Command::SaveHeaderSetting(unsigned char *data, int sizecmd)
{   if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(setting)))
    {
        unsigned char *buff = new unsigned char[sizeof(setting)];
        memcpy(buff, data, sizeof(setting));
        this->se = (setting*)buff;
        this->valid = true;
        this->IdCmd = se->idCmd;
        this->size = (sizeof(command) + sizeof(setting));
        return (sizeof(command) + sizeof(setting));
    }
    return 0;
}
int Command::SaveHeaderEvent(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(events)))
    {
        std::cout << "SAVING  EVENT CMD OK" << std::endl;
        unsigned char *buff = new unsigned char[sizeof(events)];
        memcpy(buff, data, sizeof(events));
        this->e = (events*)buff;
        this->IdCmd = e->idCmd;
        this->valid = true;
        this->size = (sizeof(command) + sizeof(events));
        return (sizeof(command) + sizeof(events));
    }
    else
    std::cout << "SAVING  EVENT CMD NOT OK" << std::endl;
    return 0;
}
int Command::SaveHeaderSys(unsigned char *data, int sizecmd)
{
    if ((unsigned int)sizecmd >= (sizeof(command) + sizeof(sys)))
    {
        unsigned char *buff = new unsigned char [sizeof(sys)];
        memcpy(buff, data, sizeof(sys));
        this->sy = new sys;
        this->sy = (sys*)buff;
        this->IdCmd = sy->idCmd;
        this->valid = true;
        this->size = (sizeof(command) + sizeof(sys));
        return (sizeof(command) + sizeof(sys));
    }
    return 0;
}

unsigned char *Command::ConvertToAnswerNote()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(note)];
    command *c = new command;
    c->idHeader = HEADERNOTE;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->n, sizeof(note));
    return data;
}

unsigned char *Command::ConvertToAnswerFile()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(file)];
    command *c = new command;
    c->idHeader = HEADERFILE;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->f, sizeof(file));
    return data;
}

unsigned char *Command::ConvertToAnswerContact()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(contact)];
    command *d = new command;
    d->idHeader = HEADERCONTACT;
    memcpy(data, d, sizeof(command));
    memcpy(data + sizeof(command) , this->c, sizeof(contact));
    return data;
}

unsigned char *Command::ConvertToAnswerBookmark()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(bookmark)];
    command *c = new command;
    c->idHeader = HEADERBOOKMARK;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->b, sizeof(bookmark));
    return data;
}

unsigned char *Command::ConvertToAnswerAgenda()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(agenda)];
    command *c = new command;
    c->idHeader = HEADERAGENDA;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->a, sizeof(agenda));
    return data;
}

unsigned char *Command::ConvertToAnswerWeather()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(weather)];
    command *c = new command;
    c->idHeader = HEADERWEATHER;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->w, sizeof(weather));
    return data;
}

unsigned char *Command::ConvertToAnswerSetting()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(setting)];
    command *c = new command;
    c->idHeader = HEADERSETTING;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->se, sizeof(setting));
    return data;
}

unsigned char *Command::ConvertToAnswerEvents()
{
    std::cout << "convert to events "<< std::endl;
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(events)];
    command *c = new command;
    c->idHeader = HEADEREVENT;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->e, sizeof(events));
    return data;
}

unsigned char *Command::ConvertToAnswerSys()
{
    unsigned char *data = new unsigned char[sizeof(command) + sizeof(sys)];
    command *c = new command;
    c->idHeader = HEADERSYS;
    memcpy(data, c, sizeof(command));
    memcpy(data + sizeof(command) , this->sy, sizeof(sys));
    return data;
}
