#ifndef MANAGE_H
#define MANAGE_H

#include <QObject>
#include <QString>
#include <QVariant>
#include <QSqlDatabase>
#include <QSqlRecord>
#include <QList>
#include "Command.h"

#define SYNC_START 0.0
#define SYNC_END   1.0
#define SYNC_BM    0.15
#define SYNC_NOTE  0.3
#define SYNC_CONTACT  0.45
#define SYNC_AGENDA 0.6
#define SYNC_WEATHERLOC 0.75
#define SYNC_INFOUSER  0.9

class Manage : public QObject
{
    Q_OBJECT
public:
    Manage();
    ~Manage();

    bool    openDatabase(QString);
    bool    checkExistLocalDatabase();
    bool    fillInfo(QString data);
    void    createLocalDatabase();
    void    insertBdd(QString data);
    void    analyse(Command*);
    QList<QSqlRecord> execQuery(QString);

public slots:
    void    execQuery(QString Query, int);
    void    recvFromServer(unsigned char *data, int len);
    void    lostServerConnection();
    void    AuthOnServer(QString user, QString pass);

signals:

    void    queryRet(QList<QSqlRecord>, int);
    void    clearOutBuffer(int);
    void    sendQuery(QString, int);
    void    sendData(unsigned char *, int);
    void    synchingProgress(QVariant);

private :
    QString         localDBName;
    QString         field;
    QString         username;

    QSqlDatabase    dataBase;

    QList<QString>  fieldName ;
    QList<QString>  value;

    bool isConnect;
    bool isSynching;
    std::map<int, void (Manage::*)(Command *) > TabCmdHead;
    std::map<int, void (Manage::*)(QList<QSqlRecord>, int) > TabRet;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdSys;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdBookmark;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdNote;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdContact;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdAgenda;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdWeather;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdSetting;
    std::map<int, void (Manage::*)(Command *) > TabCmdIdEvent;

    void ActionCommand(Command*);
    void ActionHeaderNote(Command*);
    void ActionHeaderFile(Command*);
    void ActionHeaderContact(Command*);
    void ActionHeaderBookmark(Command*);
    void ActionHeaderAgenda(Command*);
    void ActionHeaderWeather(Command*);
    void ActionHeaderSetting(Command*);
    void ActionHeaderEvent(Command*);
    void ActionHeaderSys(Command*);


    // id sys
    void SysAskConnection(Command *);
    void StartSync();
    void EndSync(Command *);

        // SYNCHRO ACTION FUNC
    void    SyncBookMark(Command *);
    void    SyncEndBookMark(Command *);

    void    SyncNote(Command *);
    void    SyncEndNote(Command *);

    void    SyncContact(Command *);
    void    SyncEndContact(Command *);

    void    SyncAgenda(Command *);
    void    SyncEndAgenda(Command *);

    void    SyncWeather(Command *);
    void    SyncEndWeather(Command *);


    void    SyncSetting(Command *);
    void    SyncEndSetting(Command *);

    void    SyncEvent(Command *);
    void    SyncEndEvent(Command *);

};



#endif // MANAGE_H
