#ifndef WEBPREVIEWELEM_H
#define WEBPREVIEWELEM_H

#include <QDeclarativeItem>
#include <QObject>
#include <QPixmap>
#include <QUrl>
#include <QPainter>
#include "thumbnailloader.h"


class ThumbnailLoader;

class webPreviewElem : public QDeclarativeItem
{
    Q_OBJECT
    Q_ENUMS(Status)

    Q_PROPERTY(QUrl url READ getUrl WRITE setUrl NOTIFY urlChanged);
    Q_PROPERTY(int progress READ getProgress NOTIFY progressChanged);
    Q_PROPERTY(int radius READ getRadius WRITE setRadius);
    Q_PROPERTY(Status status READ getStatus NOTIFY statusChanged);
    Q_PROPERTY(ThumbnailLoader * context READ getContext WRITE setContext);

signals:
    void    urlChanged();
    void    statusChanged();
    void    progressChanged();

public :
    webPreviewElem(QObject *parent = 0);
    ~webPreviewElem();

    enum Status
    {
        Idle,
        Queued,
        Loading,
        Ready,
        Error
    };

    QUrl        getUrl() const;
    int         getProgress() const;
    Status         getStatus() const;
    int         getRadius() const;
    ThumbnailLoader *getContext() const;


    void        setRadius(int);
    void        setUrl(QUrl);
    void        setContext(ThumbnailLoader *);

public slots:
    void        started();
    void        progress(int);
    void        finished(const QPixmap&);
    void        error();

protected :
    QPixmap         webPix;

    void            paint(QPainter *, const QStyleOptionGraphicsItem *, QWidget *);
    void            componentComplete();

private :
    Status          currentStatus;
    QUrl            currentUrl;
    int             currentProgress;
    int             radius;
    ThumbnailLoader *ctx;
};

#endif // WEBPREVIEWELEM_H
