//import QtQuick 1.1
 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5

Item
{
    id : button_item
    property int mobileView

    // BUTTON STATES ARE DEFINED IN BUTTON
    Rectangle
    {
        id : shadowBar1; color : "#000000"; opacity: 0;
        Behavior on opacity {SequentialAnimation{PauseAnimation {duration : (button6.numId + 1) * 500} NumberAnimation {duration : 1000}}}
        width : button6.x - button1.x ; height: button1.height / 2;
        x : button1.x + button1.width / 2; y : (button1.height - shadowBar1.height) / 2;
    }
    ButtonSelect { id : button1; anchors.left : parent.left; anchors.leftMargin: (main_win_rec.width - (6 * button1.width + 5 * 38)) / 2;
        numId : 0; Component.onCompleted : {button2.opacity = 1; shadowBar1.opacity = 0.70} text : "Notes";
        resImg : mobileView; clickActionState : "Notes State";
        onButtonClicked : {background_rect.state = clickActionState; main_note.source = "Notes.qml";}
        onButtonReleased : {button_item.clearSelected();}
    }

    ButtonSelect { id : button2; anchors.left : button1.right; anchors.leftMargin: 38;
        numId : 1; Component.onCompleted : button3.opacity = 1; text : "Files";
        resImg : mobileView; clickActionState : "Files State"
        onButtonClicked : {background_rect.state = clickActionState; main_fileftp.source = "File.qml"}
        onButtonReleased : {button_item.clearSelected();}
    }

    ButtonSelect { id : button3; anchors.left : button2.right; anchors.leftMargin: 38;
        numId : 2; Component.onCompleted : button4.opacity = 1; text : "Contacts";
        resImg : mobileView; clickActionState : "Contacts State";
        onButtonClicked : {contact_win.source = "Contact.qml"; background_rect.state = clickActionState;}
        onButtonReleased : {button_item.clearSelected()}
    }

    ButtonSelect { id : button4; anchors.left : button3.right; anchors.leftMargin: 38;
        numId : 3; Component.onCompleted : button5.opacity = 1; text : " Book\nMarks";
        resImg : mobileView; clickActionState : "BookMarks State";
        onButtonClicked : {main_bookmarks.source = "BookMarks.qml"; console.log("BookMarks Loaded"); background_rect.state = clickActionState}
        onButtonReleased : {button_item.clearSelected();}
    }

    ButtonSelect { id : button5; anchors.left : button4.right; anchors.leftMargin: 38;
        numId : 4; Component.onCompleted : button6.opacity = 1; text : "Agenda";
        resImg : mobileView; clickActionState : "Agenda State";
        onButtonClicked : {agenda_win.source = "Agenda.qml"; background_rect.state = clickActionState}
        onButtonReleased : {button_item.clearSelected();}
    }

    ButtonSelect { id : button6; anchors.left : button5.right; anchors.leftMargin: 38;
        numId : 5; Component.onCompleted : button1.opacity = 1; text : "Weather";
        loadPath: "Weather.qml";
        resImg : mobileView; clickActionState : "Weather State"
        onButtonClicked:
        {
            weather_win.source = "Weather.qml";
            background_rect.state = clickActionState;
        }
        onButtonReleased : {button_item.clearSelected();}
    }

    function clearSelected()
    {
        button1.selectedButton = false;
        button2.selectedButton = false;
        button3.selectedButton = false;
        button4.selectedButton = false;
        button5.selectedButton = false;
        button6.selectedButton = false;
        button1.setNormalButton();
        button2.setNormalButton();
        button3.setNormalButton();
        button4.setNormalButton();
        button5.setNormalButton();
        button6.setNormalButton();
    }


    function changeSelectedRight()
    {
        background_rect.state = "base state";
        var buttonsTab = [button1, button2, button3, button4, button5, button6];
        var i = 0;
        while (i < buttonsTab.length && !buttonsTab[i].selectedButton)
            i++;
        button_item.clearSelected();
        if (i == buttonsTab.length)
            i = 0;
        else
            i = (i + 1) % buttonsTab.length;
        buttonsTab[i].selectedButton = true;
        console.log(buttonsTab[i].clickActionState);
        background_rect.state = buttonsTab[i].clickActionState;
        buttonsTab[i].buttonClicked();
        buttonsTab[i].setNormalButton();
    }

    function changeSelectedLeft()
    {
        background_rect.state = "base state";
        var buttonsTab = [button1, button2, button3, button4, button5, button6];
        var i = 0;
        while (i < buttonsTab.length && !buttonsTab[i].selectedButton)
            i++;
        button_item.clearSelected();
        if (i == buttonsTab.length)
            i = 0;
        else
            i = (i - 1 >= 0) ? (i - 1) : (buttonsTab.length - 1);
        buttonsTab[i].selectedButton = true;
        console.log(buttonsTab[i].clickActionState);
        background_rect.state = buttonsTab[i].clickActionState;
        buttonsTab[i].buttonClicked();
        buttonsTab[i].setNormalButton();
    }
}
