//import QtQuick 1.1
import webthumbnail 1.0
 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5

Item
{
    id : bookmark_item
    property int mobileView : tepee.mobileRes
    property int curBookId;
    property bool addInBrows;

    width: main_win_rec.width - (2 * mobileView)
    height: main_win_rec.height -(2 * mobileView)
    y : mobileView
    x : mobileView

    // NEW BOOKMARK INPUT ELEM

    Rectangle
    {
        id : new_book_input
        //radius:  25
        color : "transparent"
        opacity : 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        width : bookmarkListRec.width / 2
        height : bookmarkListRec.width / 2
        anchors.centerIn: parent

        Rectangle
        {
            anchors.fill : parent;
            opacity : tepee.elemBackOpacity
            color : tepee.elemBackColor
            smooth : true
            radius : 45
            border.color : "grey"
            border.width : 2
        }
        function checkInput(textInputElem)
        {
            console.log("check");
            if (textInputElem.text.length > 32 || textInputElem.text.length == 0)
            {
                input_title.inputRight(false);
            }
            else
                input_title.inputRight(true);
        }
        TextBox
        {
            id : input_title
            inline : false
            titleText : "BookMark Name :"
            inputText: ""
            mobileView : bookmark_item.mobileView
            width : parent.width - mobileView / 2
           // height : (mobileView == 139) ? 55 : (mobileView == 80) ? 50 : 35
            anchors.top : parent.top
            anchors.topMargin: 30
            anchors.horizontalCenter: parent.horizontalCenter
            function checkInput()
            {
                line_edit = true;
                if (inputText.length >= 32)
                    line_edit = false;
                if (inputText.length == 0)
                    line_edit = false;
                inputRight(line_edit)
            }

            onInputTextChanged:
            {
                checkInput();
            }
            Component.onCompleted:
            {
                checkInput();
            }
        }

        TextBox
        {
            bColor: "blue"
            id : input_addr
            inline : false
            titleText : "BookMark Address : "
            inputText: "http://"
            mobileView : bookmark_item.mobileView
            width : parent.width - mobileView / 2
           // height : (mobileView == 139) ? 55 : (mobileView == 80) ? 50 : 35
            anchors.top: input_title.bottom
            anchors.topMargin: 10
            anchors.horizontalCenter: parent.horizontalCenter
        }
        Button
        {
            id : addBookButton
            buttonColor: "blue"
            buttonShape: "rectangle"
            text : "Add"
            resImg: bookmark_item.mobileView
            numId : 500
            opacity : 1
            x : (new_book_input.width / 2) - addBookButton.width
            anchors.top : input_addr.bottom
            anchors.topMargin: 10
            onButtonClicked:
            {
                if (input_title.line_edit)
                {
                    new_book_input.opacity = 0;
                    if (!addInBrows)
                        bookmarkListRec.opacity = 1;
                    else
                    {
                        bookMarkFull.opacity = 1;
                        addInBrows = false;
                    }
                    if (text == "Add")
                    {
                        apCtrl.addBookMark(input_title.inputText, input_addr.inputText);
                    }
                    else if (text == "Update")
                    {
                        console.log("UPDATING BOOKMARK");
                        apCtrl.editBookMark(input_title.inputText, input_addr.inputText, curBookId);
                        addBookButton.text = "Add";
                        delBookButton.text = "Cancel";
                        input_title.inputText = "";
                        input_addr.inputText = "http://";
                    }
                }
            }
        }

        Button
        {
            id : delBookButton
            text : "Cancel"
            buttonColor: "red"
            buttonShape: "rectangle"
            resImg: bookmark_item.mobileView
            numId : 500
            opacity : 1
            anchors.left: addBookButton.right
            anchors.top : input_addr.bottom
            anchors.topMargin: 10
            onButtonClicked :
            {
                new_book_input.opacity = 0;
                if (!addInBrows)
                    bookmarkListRec.opacity = 1;
                else
                {
                    bookMarkFull.opacity = 1;
                    addInBrows = false;
                }
                if (text == "Cancel")
                {
                }
                else if (text == "Del")
                {
                    apCtrl.removeBookMark(curBookId);
                }
            }
        }

    }

    Flipable
    {
        id : book_flip
        property bool flipped : false
        anchors.fill: parent

        function    flipView()
        {
            flipped = !flipped;
        }

        transform: Rotation {
            id: rotation_flip
            origin.x: (parent.x + parent.width) / 2
            origin.y: (parent.y + parent.height) / 2
            axis.x: 1; axis.y: 0; axis.z: 0
            angle: 0
        }

        back :  BookmarkWebview {
            id : bookMarkFull
            opacity : 1
            mobileView: mobileView
            width : parent.width
            height : parent.height

            onAddBookMark:
            {
                new_book_input.opacity = 1;
                input_addr.inputText = s_url;
                input_title.inputText = s_title;
                bookMarkFull.opacity = 0;
                addInBrows = true;
            }


            onWebMinimized :
            {
                book_flip.flipView();
            }
        }

        front : Item      {
            id : bookmarkListRec
            anchors.fill: parent

            opacity : 1
//            color : "transparent"
            Behavior on opacity {NumberAnimation {duration : 500}}

            Rectangle
            {
                id : font
                anchors.fill : parent;
                opacity : tepee.elemBackOpacity
                color : tepee.elemBackColor
                smooth : true
                radius : 45
                border.color : "grey"
                border.width : 2
            }

            WebThumbnailLoader
            {
                id : thumbloader
                concurrency: 1
            }

            GridView
            {
                id : bookMarkGrid
                model : bookmarkModel
                clip : true
                anchors.fill : parent
                cellWidth: Math.floor(width / 3)
                cellHeight: cellWidth
                delegate: book_del
            }
            ScrollBar
            {
                id: verticalScrollBar
                width: 12; height: bookmarkListRec.height-12
                anchors.right: bookmarkListRec.right
                opacity: 0
                orientation: Qt.Vertical
                position: bookMarkGrid.visibleArea.yPosition
                pageSize: bookMarkGrid.visibleArea.heightRatio
            }
            states:
                [
                State
                {
                    name: "ShowBars"
                    when: bookMarkGrid.movingVertically
                    PropertyChanges { target: verticalScrollBar; opacity: 1 }
                }]
        }
    }

    transitions: Transition {
        PropertyAnimation { target: rotation_flip; property: "angle"; duration: 1000 }
    }

    states:
        [
        State {
            name : "FlippedState"
            PropertyChanges {target: rotation_flip; angle : 180}
            when : book_flip.flipped
        }
    ]

    Component
    {
        id : book_del
        Item               {
            width : bookMarkGrid.cellWidth
            height : bookMarkGrid.cellHeight
            scale : del_ma.pressed ? 0.9 : 1
            x: bookMarkGrid.currentItem.x
            y: bookMarkGrid.currentItem.y
            Rectangle
            {
                anchors.fill: parent
                radius: 45
                gradient :
                    Gradient {
                    GradientStop {position : 0.0; color : tepee.highLightColor}
                    GradientStop {position : 1.0; color : tepee.highLightColor2}
                }
                border.color: "grey"
                border.width: 1
                opacity:  0.4
                smooth : true
            }

            BookmarkWebThumbnail
            {
                id : bookmarkDelegate
                url : bookMarkAddr
                title : bookMarkTitle
                opacity : (title == "new_elem_@") ? 0 : 1
                mobileView: mobileView
                width : bookmarkListRec.width / 4
                height : bookmarkListRec.width / 4
                anchors.centerIn: parent
                context : thumbloader
                radius : 0
                onThumbnailMaximized:
                {
                    book_flip.flipView();
                    //                            Qt.openUrlExternally(bookmarkDelegate.url); // Pour ouvrir site dans browser par defaut sur phone
                    load_url_timer.start();
                }
                Timer
                {
                    id : load_url_timer
                    interval : 1000; running : false; repeat : false
                    onTriggered :
                    {
                        bookMarkFull.url = bookmarkDelegate.url;
                    }
                }
            }

            MouseArea
            {
                id : del_ma
                anchors.fill : parent
                onClicked:
                {
                    curBookId = bookId;
                    console.log(bookId);
                    bookmarkDelegate.thumbnailMaximized();
                }

                onPressAndHold:
                {
                    console.log(bookId);
                    curBookId = bookId
                    //                    bookMarkGrid.currentIndex = index;

                    if (bookmarkDelegate.title == "new_elem_@")
                    {
                        addBookButton.text = "Add";
                        delBookButton.text = "Cancel";
                        input_title.inputText = "";
                        input_addr.inputText = "http://";
                    }
                    else
                    {
                        addBookButton.text = "Update";
                        delBookButton.text = "Del";
                        input_title.inputText = bookmarkDelegate.title;
                        input_addr.inputText = bookmarkDelegate.url;
                    }
                    bookmarkListRec.opacity = 0;
                    new_book_input.opacity = 1;
                }
            }


            Item
            {
                width : bookmarkListRec.width / 3
                height : bookmarkListRec.height / 3
                anchors.centerIn: parent
                opacity : (bookmarkDelegate.title == "new_elem_@") ? 1 : 0
                Text
                {
                    font.pointSize: tepee.textSize
                    color: "white"
                    text : "New BookMark"
                    anchors.centerIn: parent
                }
            }
        }
    }

}


