#ifndef BOOKMARKLOGIC_H
#define BOOKMARKLOGIC_H

#include <QObject>
#include <QUrl>
#include "listmodel.h"
#include "Description.h"
#include <QSqlRecord>
#include <sstream>
#include <QDateTime>

class BookMarkElem : public ListItem
{
    Q_OBJECT
public :
    enum BookMarkRoles
    {
        bookTitleRole = Qt::UserRole + 1,
        bookAddrRole,
        bookIdRole
    };

    BookMarkElem(QObject *p = 0);
    BookMarkElem(QString title, QString addr, QString, QObject *p = 0);

    //INHERITED FROM LISTITEM
    int id() const;
    QVariant data(int role) const;
    QHash<int, QByteArray> roleNames() const;
    /////////////////////////
    QString getBookTitle() const;
    QUrl getBookAddr() const;
    QString getIdTime() const;
    void setBookTitle(QString);
    void setBookAddr(QString);


private :
    QString bookTitle;
    QUrl bookAddr;
    QString idTime;
    int     bookId;

    static int nextId;

};

class BookMarkLogic : public QObject
{
    Q_OBJECT

private :
    ListModel *bookMarksMod;
    QList<QSqlRecord> QL;
public:
    explicit BookMarkLogic(QObject *parent = 0);
    ListModel *getBookMarksModel();
    bool        addBookMark(QString title , QString addr);
    void        editBookMark(QString title, QString addr, int id);
    void        removeBookMark(int id);
    void        LoadBMfromDB();
signals:
    void SendQueryBM(QString query, int);
public slots:
    void rcvBM(QList<QSqlRecord>, int);
    
};

#endif // BOOKMARKLOGIC_H
