import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5


// CREER UN EVENT LOGIC QUI SERA UNE LISTITEM CONTENANT POUR CHAQUE ELEM
// PLUSIEURS MODEL AU LIEU DES PLUSISEURS CHAMPS HABITUELS


Item
{
    property int mobileView : tepee.mobileRes
    property string contactList : ""
    property int currentElemId : -1;

    id : event_item
    width: main_win_rec.width - (2 * mobileView)
    height: main_win_rec.height -(2 * mobileView)
    y : mobileView
    x : mobileView

    Item
    {
        id : item_cur_event
        anchors.fill: parent
        Behavior on opacity { PropertyAnimation { duration : 500}}
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            smooth : true
            radius : 45
            border.color : "grey"
            border.width : 2
        }
        ListView
        {
            id : list_event
            orientation: ListView.Vertical
            anchors.fill: parent
            model: eventModel
            delegate: event_delegate
            clip : true
        }
        Button
        {
            id : new_event_button
            opacity: 1
            anchors
            {
                top : parent.bottom
                topMargin : - tepee.mobileRes / 2
                horizontalCenter : parent.horizontalCenter
            }
            resImg: tepee.mobileRes
            text :"New"
            buttonColor : "blue"
            buttonShape : "round"
            onButtonClicked:
            {
                new_event_item.opacity = 1;
                item_cur_event.opacity = 0;
                del_new_event_button.text = "Cancel";
            }
        }
    }

    //Date Picker
    DatePicker
    {
        opacity : 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        id : start_date_picker
        anchors.fill: parent
        backButton: true
        viewType: 1
        onBackButtonClicked:
        {
            date_button.text = "   Date \n" + start_date_picker.currentDayNum + "/" + (start_date_picker.currentMonthNum + 1) + "/" + start_date_picker.currentYear
            start_date_picker.opacity = 0;
            new_event_item.opacity = 1;
            new_event_button.opacity = 1;
        }
    }

    //Hour Picker
    TimePicker
    {
        id : start_time_picker
        opacity : 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        backButton: true
        onBackButtonClicked:
        {
            hour_button.text = "  Time \n" + (start_time_picker.currentHour < 10 ? "0" : "") + start_time_picker.currentHour + " : " + ((start_time_picker.currentMin < 10) ? "0" : "") + start_time_picker.currentMin;
            start_time_picker.opacity = 0;
            new_event_item.opacity = 1;
            new_event_button.opacity = 1;
        }
    }

    //NEW EVENT AREA
    Item
    {
        id : new_event_item
        anchors.fill: parent
        opacity : 0;
        Behavior on opacity { PropertyAnimation { duration : 500}}
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            smooth : true
            radius : 45
            border.color : "grey"
            border.width : 2
        }

        Flickable
        {
            id : new_event_flick
            clip : true
            anchors.fill : parent
            contentHeight: 3 *   height
            contentWidth: width

            Item
            {
                id : event_titleItem
                height : 2 * tepee.mobileRes
                anchors
                {
                    top: parent.top
                    left : parent.left
                    right : parent.right
                    margins : tepee.mobileRes / 8
                }
                Rectangle
                {
                    anchors.fill: parent
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    radius : 25
                    border
                    {
                        width : 1
                        color : "grey"
                    }
                }
                Text
                {

                    id : event_titleText
                    color : "white"
                    font.pointSize : tepee.textSize + 2
                    anchors
                    {
                        horizontalCenter : parent.horizontalCenter
                        top : parent.top
                    }
                    text : "Event Title"
                }
                TextBox
                {
                    id : title_Event
                    width : 3 * tepee.mobileRes
                    anchors.bottom : parent.verticalCenter
                    anchors.margins: tepee.mobileRes / 8
                    anchors.left: parent.left
                    titleText: "Title :"
                    inputText:  ""

                }
            }
            // CONTACT SELECTOR
            Item
            {
                id : contact_selector
                height : 2 * tepee.mobileRes
                anchors
                {
                    top : event_titleItem.bottom
                    left : parent.left
                    right : parent.right
                    margins : tepee.mobileRes / 8
                }
                Rectangle
                {
                    anchors.fill: parent
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    radius : 25
                    border
                    {
                        width : 1
                        color : "grey"
                    }
                }
                Text
                {

                    id : contact_titleText
                    color : "white"
                    font.pointSize : tepee.textSize + 2
                    anchors
                    {
                        horizontalCenter : parent.horizontalCenter
                        top : parent.top
                    }
                    text : "Contacts"
                }

                ListView
                {
                    orientation: ListView.Horizontal
                    id : contact_sel_listview
                    anchors
                    {
                        top : parent.top
                        left : parent.left
                        right : parent.right
                        bottom : parent.bottom
                        margins : contact_titleText.height
                    }
                    spacing : tepee.mobileRes / 8
                    model : contactModel
                    delegate: contact_delegate
                }
            }

            // Area And Date Selector
            Item
            {
                id : area_date_selector
                height : 2 * tepee.mobileRes
                anchors
                {
                    top : contact_selector.bottom
                    left : parent.left
                    right : parent.right
                    margins : tepee.mobileRes / 8
                }
                Rectangle
                {
                    anchors.fill: parent
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    radius : 25
                    border
                    {
                        width : 1
                        color : "grey"
                    }
                }
                Text
                {
                    color : "white"
                    font.pointSize : tepee.textSize + 2
                    anchors
                    {
                        horizontalCenter : parent.horizontalCenter
                        top : parent.top
                    }
                    text : "Location & Date"
                }
                TextBox
                {
                    id : countryLocEvent
                    width : 3 * tepee.mobileRes
                    anchors.bottom : parent.verticalCenter
                    anchors.margins: tepee.mobileRes / 8
                    anchors.left: parent.left
                    titleText: "Country :"
                    inputText:  ""
                }
                TextBox
                {
                    id : cityLocEvent
                    width : 3 * tepee.mobileRes
                    anchors.top : parent.verticalCenter
                    anchors.margins: tepee.mobileRes / 8
                    anchors.left: parent.left
                    titleText : "City :   "
                    inputText: ""
                }
                SquareQmlButton
                {
                    id : date_button
                    width : tepee.mobileRes
                    height : width
                    text : "Date"
                    anchors
                    {
                        right : hour_button.left
                        verticalCenter : parent.verticalCenter
                        margins : tepee.mobileRes / 2
                    }
                    onButtonClicked:
                    {
                        start_date_picker.opacity = 1;
                        new_event_item.opacity = 0;
                        new_event_button.opacity = 0;
                    }
                }
                SquareQmlButton
                {
                    id : hour_button
                    width : tepee.mobileRes
                    height : width
                    text : "Time"
                    anchors
                    {
                        right : parent.right
                        verticalCenter : parent.verticalCenter
                        margins : tepee.mobileRes / 2
                    }
                    onButtonClicked:
                    {
                        new_event_button.opacity = 0;
                        start_time_picker.opacity = 1;
                        new_event_item.opacity = 0;
                    }
                }

            }
            // EVENT DESCRIPTION
            Item
            {
                id : event_decription
                height : 2 * tepee.mobileRes
                anchors
                {
                    top : area_date_selector.bottom
                    left : parent.left
                    right : parent.right
                    margins : tepee.mobileRes / 8
                }
                Rectangle
                {
                    anchors.fill: parent
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    radius : 25
                    border
                    {
                        width : 1
                        color : "grey"
                    }
                }
                Text
                {
                    id : event_decription_txt
                    color : "white"
                    font.pointSize : tepee.textSize + 2
                    anchors
                    {
                        horizontalCenter : parent.horizontalCenter
                        top : parent.top
                    }
                    text : "Event Description"
                }
                TextEditArea
                {
                    id : textarea_event_desc
                    anchors
                    {
                        top : event_decription_txt.bottom
                        left : parent.left
                        right : parent.right
                        bottom : parent.bottom
                        leftMargin : tepee.mobileRes / 4
                        rightMargin : tepee.mobileRes / 4
                        bottomMargin : tepee.mobileRes / 4
                    }
                    inputText: ""
                    titleText: ""
                    mobileView: tepee.mobileRes
                }
            }

            Button
            {
                id : save_new_event_button

                anchors{
                    top : event_decription.bottom
                    right : parent.horizontalCenter
                    margins : tepee.mobileRes / 8
                }
                resImg : tepee.mobileRes
                opacity : 1
                text : "Save"
                buttonColor: "blue"
                buttonShape: "rectangle"
                onButtonClicked:
                {
                    new_event_item.opacity = 0;
                    item_cur_event.opacity = 1;
                    contact_sel_listview.opacity = 1;

                    // save in base
                    if (currentElemId == -1)
                        apCtrl.addEvent(title_Event.inputText, textarea_event_desc.inputText, countryLocEvent.inputText, cityLocEvent.inputText,start_date_picker.currentDayNum +"." + start_date_picker.currentMonthNum+ "." + start_date_picker.currentYear, start_time_picker.currentHour + "." + start_time_picker.currentMin + ".00" , apCtrl.getUserFirstName(), apCtrl.getUserLastName(), contactList);
                    else
                        apCtrl.editEvent(title_Event.inputText, textarea_event_desc.inputText, countryLocEvent.inputText, cityLocEvent.inputText,start_date_picker.currentDayNum +"." + start_date_picker.currentMonthNum+ "." + start_date_picker.currentYear, start_time_picker.currentHour + "." + start_time_picker.currentMin + ".00" , apCtrl.getUserFirstName(), apCtrl.getUserLastName(), contactList, currentElemId);

                    contactList = "";
                    countryLocEvent.inputText = "";
                    cityLocEvent.inputText = "";
                    textarea_event_desc.inputText = "";
                    date_button.text = "Date";
                    hour_button.text = "Hour";
                    title_Event.inputText = "";
                }
            }
            Button
            {
                id : del_new_event_button

                anchors{
                    top : event_decription.bottom
                    left : parent.horizontalCenter
                    margins : tepee.mobileRes / 8
                }
                resImg : tepee.mobileRes
                opacity : 1
                text : "Del"
                buttonColor: "red"
                buttonShape: "rectangle"
                onButtonClicked:
                {
                    new_event_item.opacity = 0;
                    item_cur_event.opacity = 1;
                    if (text == "Del")
                    {
                        apCtrl.removeEvent(currentElemId);
                    }
                    contact_sel_listview.opacity = 1;
                    currentElemId = -1;
                    contactList = "";
                    title_Event.inputText = "";
                    countryLocEvent.inputText = "";
                    cityLocEvent.inputText = "";
                    textarea_event_desc.inputText = "";
                    date_button.text = "Date";
                    hour_button.text = "Hour";
                }
            }
        }
        ScrollBar
        {
            id: verticalScrollBar
            width: 12; height: new_event_flick.height - 12
            anchors.right: new_event_flick.right
            opacity: 0
            orientation: Qt.Vertical
            position: new_event_flick.visibleArea.yPosition
            pageSize: new_event_flick.visibleArea.heightRatio
        }

        states:
            [
            State
            {
                name: "ShowBars"
                when: new_event_flick.movingVertically
                PropertyChanges { target: verticalScrollBar; opacity: 1 }
            }
        ]
    }




    // CONTACT_SELECT
    Component
    {
        id : contact_delegate
        Item
        {
            id : contact_item
            scale : contact_del_ma.pressed ? 0.9 : 1
            property bool selected : false
            width : Math.floor((contact_sel_listview.width / 5) - (tepee.mobileRes / 4))
            height : contact_sel_listview.height
            Rectangle
            {
                radius : 15
                anchors.fill: parent
                color : (!contact_item.selected) ? tepee.elemBackColor : "blue"
                opacity : tepee.elemBackOpacity
                border
                {
                    width : 1
                    color : "grey"
                }
            }
            Text
            {
                width : 0.8 * parent.width
                anchors
                {
                    bottom : parent.verticalCenter
                    horizontalCenter : parent.horizontalCenter
                }
                clip : true
                color : "white"
                font.pointSize: tepee.textSize
                text : contact_firstname
            }
            Text
            {
                clip : true
                width : 0.8 * parent.width
                anchors
                {
                    top : parent.verticalCenter
                    horizontalCenter : parent.horizontalCenter
                }
                color : "white"
                font.pointSize:  tepee.textSize
                text : contact_lastname
            }

            MouseArea
            {
                id : contact_del_ma
                anchors.fill: parent
                onClicked:
                {
                    contact_item.selected = !contact_item.selected;
                    if (contact_username)
                    {
                        console.log(contact_username);
                        if (contact_item.selected)
                        {
                            contactList += (contact_username + " ");
                        }
                        else
                        {
                            var ss = new String(contactList);
                            contactList = ss.replace((contact_username + " "), "");
                        }
                        console.log("{" + contactList + "}");
                    }

                }
            }
        }
    }

    // COMPONENT DELEGATE
    Component
    {
        id : event_delegate
        Item
        {
            height : 3 * mobileView
            width : main_win_rec.width - (2 * mobileView)
            scale : detail_event.pressed ? 0.9 : 1
            Rectangle
            {
                radius : 15
                anchors.fill: parent
                anchors
                {
                    top : parent.top
                    left : parent.left
                    right : parent.right
                    margins : tepee.mobileRes / 8
                }

                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity

                border
                {
                    width : 1
                    color : "grey"
                }
            }
            Text
            {
                text :  event_title
                color : "white"
                font.pointSize: tepee.textSize
                anchors.top : parent.top
                anchors.horizontalCenter: parent.horizontalCenter
            }

            Item
            {
                id : rec_event_location_aff
                width: 3 * mobileView
                height : mobileView / 2
                anchors
                {
                    top: parent.top
                    topMargin : mobileView / 2
                    right:parent.right
                    rightMargin :  mobileView
                }

                Rectangle
                {
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    smooth : true
                    radius : 45
                    border.color : "grey"
                    border.width : 2
                    anchors.fill: parent
                }
                Text
                {
                    text: "Location"
                    color: "white"
                    font.pointSize: tepee.textSize
                    anchors.top : parent.top
                    anchors.topMargin: -mobileView / 6
                    anchors.horizontalCenter: parent.horizontalCenter
                }

                Text
                {
                    id : coucitytext
                    text : event_country + " , " + event_city
                    color : "white"
                    font.pointSize: tepee.textSize
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.verticalCenter: parent.verticalCenter
                }
            }

            Item
            {
                id : datetimetext_rec
                width: datetimetext.width  + 2
                height : rec_event_location_aff.height
                anchors
                {
                    top: rec_event_location_aff.bottom
                    topMargin: mobileView / 2
                    left: rec_event_location_aff.left
                    right: rec_event_location_aff.right
                }

                Rectangle
                {
                    anchors.fill: parent
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    smooth : true
                    radius : 45
                    border.color : "grey"
                    border.width : 2
                }
                Text
                {
                    text: "Date & Time"
                    color: "white"
                    font.pointSize: tepee.textSize
                    anchors.top : parent.top
                    anchors.topMargin: -mobileView / 6
                    anchors.horizontalCenter: parent.horizontalCenter
                }
                Text
                {
                    id : datetimetext
                    text : event_date + " - " + event_hour
                    color : "white"
                    font.pointSize: tepee.textSize
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.verticalCenter: parent.verticalCenter
                }
            }

            Item
            {
                id : bytext_rec
                width: bytext.width  + 2
                height : rec_event_location_aff.height
                anchors
                {
                    top: datetimetext_rec.bottom
                    topMargin: mobileView / 4
                    left: rec_event_location_aff.left
                    right: rec_event_location_aff.right
                }

                Rectangle
                {
                    anchors.fill: parent
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    smooth : true
                    radius : 45
                    border.color : "grey"
                    border.width : 2
                }
                Text
                {
                    text: "By"
                    color: "white"
                    font.pointSize: tepee.textSize
                    anchors.top : parent.top
                    anchors.topMargin: -mobileView / 6
                    anchors.horizontalCenter: parent.horizontalCenter
                }
                Text
                {
                    id : bytext
                    text : event_creator_fname + " " + event_creator_lname
                    color : "white"
                    font.pointSize: tepee.textSize
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.verticalCenter: parent.verticalCenter
                }
            }
            Item
            {
                id : descriptiontext_rec
                width: datetimetext.width  + 2
                height : rec_event_location_aff.height
                anchors
                {
                    left : parent.left
                    leftMargin : mobileView / 2
                    right : rec_event_location_aff.left
                    rightMargin : mobileView / 2
                    top : rec_event_location_aff.top
                    bottom : datetimetext_rec.bottom
                }
                Rectangle
                {
                    anchors.fill: parent
                    color : tepee.elemBackColor
                    opacity : tepee.elemBackOpacity
                    smooth : true
                    radius : 45
                    border.color : "grey"
                    border.width : 2

                }
                Text
                {
                    clip: true
                    width: descriptiontext_rec.width
                    anchors.fill: parent
                    anchors.leftMargin: mobileView / 3
                    anchors.rightMargin: mobileView / 3
                    anchors.bottomMargin: mobileView / 4
                    text : event_description
                    color: "white"
                    font.pointSize: tepee.textSize
                }

                Text
                {
                    text: "Description"
                    color: "white"
                    font.pointSize: tepee.textSize
                    anchors.top : parent.top
                    anchors.topMargin: -mobileView / 6
                    anchors.horizontalCenter: parent.horizontalCenter
                }

            }
            MouseArea
            {
                id : detail_event
                anchors.fill: parent
                onClicked:
                {
                    currentElemId = event_id;
                    item_cur_event.opacity = 0;
                    title_Event.inputText = event_title;
                    contact_sel_listview.opacity = 0;
                    new_event_item.opacity = 1;
                    cityLocEvent.inputText = event_city;
                    countryLocEvent.inputText = event_country;
                    textarea_event_desc.inputText = event_description;
                    del_new_event_button.text = "Del";

                }
            }
        }
    }
    Item
    {
        id : showDetailEvent
        anchors.fill: parent
        Behavior on opacity { PropertyAnimation { duration : 500}}
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            smooth : true
            radius : 45
            border.color : "grey"
            border.width : 2
        }
        opacity : 0
    }
}
