#include "notelogic.h"

int NoteElem::nextId = 0;

NoteElem::NoteElem(QObject *parent) : ListItem(parent)
{
    this->noteTitle = "Title";
    this->noteContent = "Content";
    this->noteId = NoteElem::nextId++;
}

NoteElem::NoteElem(QString title, QString content, QString time,  QObject*parent) : ListItem(parent)
{
    this->noteTitle = title;
    this->noteContent = content;
    this->idTime = time;
    this->noteId = NoteElem::nextId++;
}

int         NoteElem::id() const
{
    return (this->getNoteId());
}

QVariant        NoteElem::data(int role) const
{
    switch (role)
    {
    case titleRole :
        return this->getNoteTitle();
    case contentRole :
        return this->getNoteContent();
    case idRole :
        return this->getNoteId();
    default :
        return QVariant();
    }
}

QHash<int, QByteArray> NoteElem::roleNames() const
{
    QHash<int, QByteArray> roles;
    roles[titleRole] = "notetitle";
    roles[contentRole] = "notecontent";
    roles[idRole] = "noteId";
    return roles;
}

QString         NoteElem::getIdTime() const
{
    return this->idTime;
}

QString         NoteElem::getNoteTitle() const
{
    return (this->noteTitle);
}

QString         NoteElem::getNoteContent() const
{
    return (this->noteContent);
}

int         NoteElem::getNoteId() const
{
    return (this->noteId);
}

void            NoteElem::setNoteContent(QString s)
{
    this->noteContent = s;
}

void            NoteElem::setNoteTitle(QString s)
{
    this->noteTitle = s;
}

void NoteLogic::rcvNote(QList<QSqlRecord>q, int i)
{
    if (i == FILLNOTE)
    {
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        this->notesMod->removeRows(0, this->notesMod->rowCount());
        while (it != q.end())
        {
            if ((*it).value("status").toInt() != DEL)
                this->notesMod->appendRow(new NoteElem((*it).value("title").toString(), (*it).value("content").toString(), (*it).value("id").toString(), this->notesMod));
            ++it;
        }
    }

}

NoteLogic::NoteLogic() : QObject()
{
    this->notesMod = new ListModel(new NoteElem, 0);
}


void NoteLogic::LoadNote()
{
    QString q= "SELECT * FROM note";
    emit(SendQueryNote(q, FILLNOTE));
}

ListModel* NoteLogic::getNotesModel()
{
    return (this->notesMod);
}

bool             NoteLogic::addNote(QString t, QString c)
{
    if (t.isEmpty() || c.isEmpty())
        return (false);

    QString query;
    QString times = QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");

    this->notesMod->appendRow(new NoteElem(t, c, times, this->notesMod));

    query = "INSERT INTO note (id, lastup ,title, content, status) VALUES ('";
    query += times;
    query += "', '";
    query += times;
    query += "', '";
    query += t;
    query += "', '";
    query += c;
    query += "', ";
    query += QString::number(MODIF);
    query += ");";
    emit (SendQueryNote(query, SETNOTE));
    return (true);
}

void            NoteLogic::editNote(QString title, QString content, int id)
{
    if (title.isEmpty() || content.isEmpty())
        return ;
    NoteElem *n = (NoteElem *)this->notesMod->find(id);
    if (n != NULL)
    {
        QString query;
        query = "UPDATE note SET title ='";
        query+= title;
        query += "' , content = '";
        query +=  content;
        query += "', status = ";
        query += QString::number(MODIF);
        query += ", lastup = '";
        query +=  QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        query += "' WHERE id = '";
        query += n->getIdTime();
        query += "' AND status != ";
        query += QString::number(DEL);
        n->setNoteTitle(title);
        n->setNoteContent(content);
        std::cout << query.toStdString() << std::endl;
        this->notesMod->updateModelFromElem(n);
        emit (SendQueryNote(query, SETNOTE));
    }
}

void            NoteLogic::removeNote(int id)
{
    ListItem *n = this->notesMod->find(id);
    if (n == NULL)
        return ;
    int row = this->notesMod->getRowFromItem(n);
    if (row > -1)
    {
        NoteElem *nn = (NoteElem *)this->notesMod->find(id);
        QString query;

        query = "UPDATE note SET status =";
        query += QString::number(DEL);
        query += ", lastup = '";
        query += QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        query += "' WHERE id = '";
        query += nn->getIdTime();
        query += "'";
        emit (SendQueryNote(query, SETNOTE));
        this->notesMod->removeRow(row);
    }
}
