/*
 * salut-plugin: An account plugin for telepathy-salut
 * Copyright (C) 2009 Collabora, Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>

#include "salut-plugin.h"

#include <librtcom-accounts-widgets/rtcom-param-string.h>
#include <librtcom-accounts-widgets/rtcom-param-int.h>
#include <librtcom-accounts-widgets/rtcom-param-bool.h>
#include <librtcom-accounts-widgets/rtcom-login.h>
#include <librtcom-accounts-widgets/rtcom-edit.h>

#include <hildon/hildon-entry.h>
#include <hildon/hildon-defines.h>

#include <telepathy-glib/connection-manager.h>
#include <telepathy-glib/util.h>

ACCOUNT_DEFINE_PLUGIN (SalutPlugin, salut_plugin, LONGCAT_TYPE);

static void
salut_plugin_init (SalutPlugin *self)
{
  g_object_set (self,
      "name", "salut",
      "caps", RTCOM_PLUGIN_CAPABILITY_ADVANCED,
      NULL);
}

static void
fill_advanced_table (Longcat *plugin,
    RtcomAccountService *service,
    AccountItem *account,
    GtkWidget *table)
{
  GtkWidget *label, *widget;

  /* Published name */
  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_STRING,
          "field", "published-name",
          "can-next", TRUE,
          NULL));

  label = gtk_label_new ("Published name");
  g_object_set (label, "xalign", 0.0, NULL);
  gtk_widget_show (label);

  gtk_table_attach (GTK_TABLE (table), label,
      0, /* left */
      1, /* right */
      0, /* top */
      1, /* bottom */
      GTK_SHRINK | GTK_FILL, 0, 0, 0);

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      1, /* left */
      2, /* right */
      0, /* top */
      1, /* bottom */
      GTK_EXPAND | GTK_FILL, 0, 0, 0);

  /* Email */
  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_STRING,
          "field", "email",
          "can-next", TRUE,
          NULL));

  /* Disable auto-capitalisation */
  g_object_set (widget, "hildon-input-mode",
      HILDON_GTK_INPUT_MODE_FULL | HILDON_GTK_INPUT_MODE_DICTIONARY, NULL);

  label = gtk_label_new ("E-mail");
  g_object_set (label, "xalign", 0.0, NULL);
  gtk_widget_show (label);

  gtk_table_attach (GTK_TABLE (table), label,
      0, /* left */
      1, /* right */
      1, /* top */
      2, /* bottom */
      GTK_SHRINK | GTK_FILL, 0, 0, 0);

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      1, /* left */
      2, /* right */
      1, /* top */
      2, /* bottom */
      GTK_EXPAND | GTK_FILL, 0, 0, 0);

  /* JID */
  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_STRING,
          "field", "jid",
          "can-next", TRUE,
          NULL));

  /* Disable auto-capitalisation */
  g_object_set (widget, "hildon-input-mode",
      HILDON_GTK_INPUT_MODE_FULL | HILDON_GTK_INPUT_MODE_DICTIONARY, NULL);

  label = gtk_label_new ("Jabber ID");
  g_object_set (label, "xalign", 0.0, NULL);
  gtk_widget_show (label);

  gtk_table_attach (GTK_TABLE (table), label,
      0, /* left */
      1, /* right */
      2, /* top */
      3, /* bottom */
      GTK_SHRINK | GTK_FILL, 0, 0, 0);

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      1, /* left */
      2, /* right */
      2, /* top */
      3, /* bottom */
      GTK_EXPAND | GTK_FILL, 0, 0, 0);
}

static void
fill_page (Longcat *plugin,
    GtkWidget *table)
{
  GtkWidget *first_name_label, *first_name_entry;
  GtkWidget *last_name_label, *last_name_entry;
  GtkWidget *nickname_label, *nickname_entry;

  /* First name */
  first_name_label = gtk_label_new ("First name");
  g_object_set (first_name_label, "xalign", 0.0, NULL);
  gtk_widget_show (first_name_label);

  first_name_entry = g_object_new (RTCOM_TYPE_PARAM_STRING,
      "field", "first-name",
      "can-next", FALSE,
      "visibility", TRUE,
      "required", TRUE,
      NULL);
  gtk_widget_show (first_name_entry);

  gtk_table_attach (GTK_TABLE (table), first_name_label, 0, 1, 0, 1,
      GTK_FILL, GTK_SHRINK, HILDON_MARGIN_DOUBLE, 0);
  gtk_table_attach (GTK_TABLE (table), first_name_entry, 1, 2, 0, 1,
      GTK_FILL | GTK_EXPAND, GTK_SHRINK, 0, 0);

  /* Last name */
  last_name_label = gtk_label_new ("Last name");
  g_object_set (last_name_label, "xalign", 0.0, NULL);
  gtk_widget_show (last_name_label);

  last_name_entry = g_object_new (RTCOM_TYPE_PARAM_STRING,
      "field", "last-name",
      "can-next", FALSE,
      "visibility", TRUE,
      "required", TRUE,
      NULL);
  gtk_widget_show (last_name_entry);

  gtk_table_attach (GTK_TABLE (table), last_name_label, 0, 1, 1, 2,
      GTK_FILL, GTK_SHRINK, HILDON_MARGIN_DOUBLE, 0);
  gtk_table_attach (GTK_TABLE (table), last_name_entry, 1, 2, 1, 2,
      GTK_FILL | GTK_EXPAND, GTK_SHRINK, 0, 0);

  /* Nickname */
  nickname_label = gtk_label_new ("Nickname");
  g_object_set (nickname_label, "xalign", 0.0, NULL);
  gtk_widget_show (nickname_label);

  nickname_entry = g_object_new (RTCOM_TYPE_PARAM_STRING,
      "field", "nickname",
      "can-next", FALSE,
      "visibility", TRUE,
      "required", FALSE,
      NULL);
  gtk_widget_show (nickname_entry);

  gtk_table_attach (GTK_TABLE (table), nickname_label, 0, 1, 2, 3,
      GTK_FILL, GTK_SHRINK, HILDON_MARGIN_DOUBLE, 0);
  gtk_table_attach (GTK_TABLE (table), nickname_entry, 1, 2, 2, 3,
      GTK_FILL | GTK_EXPAND, GTK_SHRINK, 0, 0);
}

static GtkWidget *
get_login_page (Longcat *plugin,
    RtcomAccountItem *account)
{
  return g_object_new (RTCOM_TYPE_LOGIN,
      "items-mask", RTCOM_ACCOUNT_PLUGIN (plugin)->capabilities,
      "account", account,
      NULL);
}

static GtkWidget *
get_edit_page (Longcat *plugin,
    RtcomAccountItem *account)
{
  return g_object_new (RTCOM_TYPE_EDIT,
      "items-mask", RTCOM_ACCOUNT_PLUGIN (plugin)->capabilities,
      "account", account,
      NULL);
}

static void
salut_plugin_class_init (SalutPluginClass *klass)
{
  LongcatClass *cat_class = LONGCAT_CLASS (klass);

  cat_class->get_edit_page = get_edit_page;
  cat_class->get_login_page = get_login_page;
  cat_class->fill_advanced_table = fill_advanced_table;
  cat_class->fill_page = fill_page;
}
