/*
 * longcat: An account plugin for a telepathy connection manager
 * Copyright (C) 2009 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _LONGCAT_H_
#define _LONGCAT_H_

#include <librtcom-accounts-widgets/rtcom-account-plugin.h>

G_BEGIN_DECLS

#define LONGCAT_TYPE (longcat_get_type ())
#define LONGCAT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), LONGCAT_TYPE, Longcat))
#define LONGCAT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), LONGCAT_TYPE, LongcatClass))
#define IS_LONGCAT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LONGCAT_TYPE))
#define IS_LONGCAT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), LONGCAT_TYPE))
#define LONGCAT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), LONGCAT_TYPE, LongcatClass))

typedef struct _LongcatClass LongcatClass;
typedef struct _Longcat Longcat;

struct _Longcat
{
  RtcomAccountPlugin parent_instance;
};

struct _LongcatClass
{
  RtcomAccountPluginClass parent_class;

  void (*fill_advanced_table) (Longcat *plugin, RtcomAccountService *service,
      AccountItem *account, GtkWidget *table);

  GtkWidget * (*get_login_page) (Longcat *plugin, RtcomAccountItem *account);

  GtkWidget * (*get_edit_page) (Longcat *plugin, RtcomAccountItem *account);

  void (*fill_page) (Longcat *plugin, GtkTable *page_table);

  gpointer _padding[8];
};

GType longcat_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* _LONGCAT_H_ */
