/*
 * idle-plugin: An account plugin for telepathy-idle
 * Copyright (C) 2009 Collabora, Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>

#include "idle-plugin.h"

#include <librtcom-accounts-widgets/rtcom-param-string.h>
#include <librtcom-accounts-widgets/rtcom-param-int.h>
#include <librtcom-accounts-widgets/rtcom-param-bool.h>
#include <librtcom-accounts-widgets/rtcom-login.h>
#include <librtcom-accounts-widgets/rtcom-edit.h>

#include <hildon/hildon-entry.h>
#include <hildon/hildon-defines.h>

#include <telepathy-glib/connection-manager.h>
#include <telepathy-glib/util.h>

ACCOUNT_DEFINE_PLUGIN (IdlePlugin, idle_plugin, LONGCAT_TYPE);

static void
idle_plugin_init (IdlePlugin *self)
{
  g_object_set (self,
      "name", "idle",
      "caps", RTCOM_PLUGIN_CAPABILITY_ADVANCED,
      NULL);
}

static void
fill_advanced_table (Longcat *plugin,
    RtcomAccountService *service,
    AccountItem *account,
    GtkWidget *table)
{
  GtkWidget *label, *widget;
  gchar *range, *def;
  TpConnectionManagerParam *params, *p, *ssl = NULL, *port = NULL;

  params = service->protocol->params;

  for (p = params; p != NULL && p->name != NULL; p++)
    {
      if (!tp_strdiff (p->name, "use-ssl"))
        ssl = p;
      else if (!tp_strdiff (p->name, "port"))
        port = p;

      if (ssl != NULL && port != NULL)
        break;
    }

  /* Use SSL */
  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_BOOL,
          "label", "Use SSL",
          "can_focus", TRUE,
          "field", "use-ssl",
          "xalign", 0.0,
          NULL));

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      0, /* left */
      2, /* right */
      0, /* top */
      1, /* bottom */
      GTK_EXPAND | GTK_FILL, 0, 0, 0);

  hildon_check_button_set_active (HILDON_CHECK_BUTTON (widget),
      g_value_get_boolean (&ssl->default_value));

  /* Port */
  range = g_strdup_printf ("0:%u", G_MAXUINT16);

  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_INT,
          "field", "port",
          "range", range,
          "can-next", TRUE,
          NULL));

  def = g_strdup_printf ("%" G_GUINT16_FORMAT,
      g_value_get_uint (&port->default_value));

  hildon_entry_set_text (HILDON_ENTRY (widget), def);

  g_free (range);
  g_free (def);

  label = gtk_label_new ("Port");
  g_object_set (label, "xalign", 0.0, NULL);
  gtk_widget_show (label);

  gtk_table_attach (GTK_TABLE (table), label,
      0, /* left */
      1, /* right */
      1, /* top */
      2, /* bottom */
      GTK_SHRINK | GTK_FILL, 0, 0, 0);

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      1, /* left */
      2, /* right */
      1, /* top */
      2, /* bottom */
      GTK_EXPAND | GTK_FILL, 0, 0, 0);

  /* Password */
  widget = GTK_WIDGET (g_object_new (RTCOM_TYPE_PARAM_STRING,
          "field", "password",
          "can-next", TRUE,
          "visibility", FALSE,
          NULL));

  /* Disable auto-capitalisation/dictionary, but keep invisible text */
  g_object_set (widget, "hildon-input-mode",
      HILDON_GTK_INPUT_MODE_FULL | HILDON_GTK_INPUT_MODE_INVISIBLE, NULL);

  label = gtk_label_new ("Password");
  g_object_set (label, "xalign", 0.0, NULL);
  gtk_widget_show (label);

  gtk_table_attach (GTK_TABLE (table), label,
      0, /* left */
      1, /* right */
      2, /* top */
      3, /* bottom */
      GTK_SHRINK | GTK_FILL, 0, 0, 0);

  rtcom_widget_set_account (RTCOM_WIDGET (widget),
      RTCOM_ACCOUNT_ITEM (account));
  gtk_widget_show (widget);

  gtk_table_attach (GTK_TABLE (table), widget,
      1, /* left */
      2, /* right */
      2, /* top */
      3, /* bottom */
      GTK_EXPAND | GTK_FILL, 0, 0, 0);
}

static void
fill_page (Longcat *plugin,
    GtkWidget *table)
{
  GtkWidget *nickname_label, *nickname_entry;
  GtkWidget *server_label, *server_entry;
  GtkWidget *real_name_label, *real_name_entry;

  /* Nickname */
  nickname_label = gtk_label_new ("Nickname");
  g_object_set (nickname_label, "xalign", 0.0, NULL);
  gtk_widget_show (nickname_label);

  nickname_entry = g_object_new (RTCOM_TYPE_PARAM_STRING,
      "field", "account",
      "can-next", FALSE,
      "visibility", TRUE,
      "required", TRUE,
      NULL);
  gtk_widget_show (nickname_entry);

  /* Disable auto-capitalisation/dictionary */
  g_object_set (nickname_entry, "hildon-input-mode",
      HILDON_GTK_INPUT_MODE_FULL, NULL);

  gtk_table_attach (GTK_TABLE (table), nickname_label, 0, 1, 0, 1,
      GTK_FILL, GTK_SHRINK, HILDON_MARGIN_DOUBLE, 0);
  gtk_table_attach (GTK_TABLE (table), nickname_entry, 1, 2, 0, 1,
      GTK_FILL | GTK_EXPAND, GTK_SHRINK, 0, 0);

  /* Server */
  server_label = gtk_label_new ("Server");
  g_object_set (server_label, "xalign", 0.0, NULL);
  gtk_widget_show (server_label);

  server_entry = g_object_new (RTCOM_TYPE_PARAM_STRING,
      "field", "server",
      "can-next", FALSE,
      "visibility", TRUE,
      "required", TRUE,
      NULL);
  gtk_widget_show (server_entry);

  /* Disable auto-capitalisation/dictionary */
  g_object_set (server_entry, "hildon-input-mode",
      HILDON_GTK_INPUT_MODE_FULL, NULL);

  gtk_table_attach (GTK_TABLE (table), server_label, 0, 1, 1, 2,
      GTK_FILL, GTK_SHRINK, HILDON_MARGIN_DOUBLE, 0);
  gtk_table_attach (GTK_TABLE (table), server_entry, 1, 2, 1, 2,
      GTK_FILL | GTK_EXPAND, GTK_SHRINK, 0, 0);

  /* Real name */
  real_name_label = gtk_label_new ("Real name");
  g_object_set (real_name_label, "xalign", 0.0, NULL);
  gtk_widget_show (real_name_label);

  real_name_entry = g_object_new (RTCOM_TYPE_PARAM_STRING,
      "field", "fullname",
      "can-next", FALSE,
      "visibility", TRUE,
      "required", FALSE,
      NULL);
  gtk_widget_show (real_name_entry);

  gtk_table_attach (GTK_TABLE (table), real_name_label, 0, 1, 2, 3,
      GTK_FILL, GTK_SHRINK, HILDON_MARGIN_DOUBLE, 0);
  gtk_table_attach (GTK_TABLE (table), real_name_entry, 1, 2, 2, 3,
      GTK_FILL | GTK_EXPAND, GTK_SHRINK, 0, 0);
}

static GtkWidget *
get_login_page (Longcat *plugin,
    RtcomAccountItem *account)
{
  return g_object_new (RTCOM_TYPE_LOGIN,
      "items-mask", RTCOM_ACCOUNT_PLUGIN (plugin)->capabilities,
      "account", account,
      NULL);
}

static GtkWidget *
get_edit_page (Longcat *plugin,
    RtcomAccountItem *account)
{
  return g_object_new (RTCOM_TYPE_EDIT,
      "items-mask", RTCOM_ACCOUNT_PLUGIN (plugin)->capabilities,
      "account", account,
      NULL);
}

static void
idle_plugin_class_init (IdlePluginClass *klass)
{
  LongcatClass *cat_class = LONGCAT_CLASS (klass);

  cat_class->get_login_page = get_login_page;
  cat_class->get_edit_page = get_edit_page;
  cat_class->fill_advanced_table = fill_advanced_table;
  cat_class->fill_page = fill_page;
}
