/*
 * butterfly-plugin: An account plugin for telepathy-butterfly
 * Copyright (C) 2009 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _BUTTERFLY_PLUGIN_H_
#define _BUTTERFLY_PLUGIN_H_

#include "longcat.h"

G_BEGIN_DECLS

#define BUTTERFLY_TYPE_PLUGIN (butterfly_plugin_get_type ())
#define BUTTERFLY_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUTTERFLY_TYPE_PLUGIN, ButterflyPlugin))
#define BUTTERFLY_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), BUTTERFLY_TYPE_PLUGIN, ButterflyPluginClass))
#define BUTTERFLY_IS_PLUGIN(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUTTERFLY_TYPE_PLUGIN))
#define BUTTERFLY_IS_PLUGIN_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), BUTTERFLY_TYPE_PLUGIN))
#define BUTTERFLY_PLUGIN_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), BUTTERFLY_TYPE_PLUGIN, ButterflyPluginClass))

typedef struct _ButterflyPluginClass ButterflyPluginClass;
typedef struct _ButterflyPlugin ButterflyPlugin;

struct _ButterflyPluginClass
{
  LongcatClass parent_class;
};

struct _ButterflyPlugin
{
  Longcat parent_instance;
};

GType butterfly_plugin_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* _BUTTERFLY_PLUGIN_H_ */
