using GLib;
using Sqlite;

public class Tear.DBQueue : Object {

	public Database db;
	public string[] table;  // Crap! libgee version on the tablets is too old and i can't use multidimensional arrays... 
	public int nr;
	public int nc;
	public int iter;

	construct {

        if (DEBUG)
			warning ("constructing dbqueue");

		if (!FileUtils.test(tear_folder, FileTest.EXISTS))
			DirUtils.create_with_parents(tear_folder, 0775);
        FileUtils.chmod(tear_folder, 0775);

		Database.enable_shared_cache(false);
		
		this.table = new string[1000];   // Dirty and will probably break at some time... I hope they fix += for older libs soon.

		db = this.open_tear_db (quickdb_name);

		this.push ("PRAGMA temp_store = MEMORY;");
        if (DEBUG)
			warning ( "sqlite: temp store memory" );
		this.push ("PRAGMA journal_mode = TRUNCATE;");
        if (DEBUG)
			warning ( "sqlite: journal mode truncate" );
		this.push ("PRAGMA read_uncommitted = 1");
        if (DEBUG)
			warning ( "sqlite: read uncommited" );
		this.push ("PRAGMA synchronous = OFF;");
        if (DEBUG)
			warning ( "sqlite: synchronous" );
		
	    if (DEBUG)
			warning ( "db opened" );

		int result = this.push ("CREATE TABLE IF NOT EXISTS quickdata(idx INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT, addr TEXT, path TEXT, type TEXT, access_date INT, close_date INT, visits INT NOT NULL DEFAULT 1, opened INT NOT NULL DEFAULT 0);");
        if (result != Sqlite.OK) {
            warning ("Cannot create table 'quickdata': %d, %s\n", result, db.errmsg ());
            Gtk.main_quit();
        }
		result = this.push ("ALTER TABLE `quickdata` ADD COLUMN `close_date` INT;");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot add column 'close_date': %d, %s\n", result, db.errmsg ());
        }
		result = this.push ("ALTER TABLE `quickdata` ADD COLUMN `visits` INT NOT NULL DEFAULT 1;");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot add column 'visits': %d, %s\n", result, db.errmsg ());
        }
		result = this.push ("ALTER TABLE `quickdata` ADD COLUMN `opened` INT NOT NULL DEFAULT 0;");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot add column 'opened': %d, %s\n", result, db.errmsg ());
        }
        
//		this.push ("DROP TRIGGER IF EXISTS `visits_increment`;");
		result = this.push ("""CREATE TRIGGER IF NOT EXISTS `visits_increment` AFTER UPDATE OF `access_date` ON `quickdata`
				BEGIN
					UPDATE `quickdata` SET `visits` = `new`.`visits` + 1 WHERE `idx` = `new`.`idx`;
				END;
		""");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot create trigger 'visits_increment': %d, %s\n", result, db.errmsg ());
        }

//		this.push ("DROP TABLE IF EXISTS `settings`;");
		result = this.push ("CREATE TABLE IF NOT EXISTS `options` (`idx` INTEGER PRIMARY KEY AUTOINCREMENT, `option` TEXT, `value` TEXT, `public` TEXT, `default` TEXT, `title` TEXT, `enum` TEXT, `type` TEXT DEFAULT 'string');");
        if (result != Sqlite.OK) {
            warning ("Cannot create table 'options': %d, %s\n", result, db.errmsg ());
            Gtk.main_quit();
        }
		result = this.push ("ALTER TABLE `options` ADD COLUMN `default` TEXT;");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot add column 'default': %d, %s\n", result, db.errmsg ());
        }
		result = this.push ("ALTER TABLE `options` ADD COLUMN `title` TEXT;");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot add column 'title': %d, %s\n", result, db.errmsg ());
        }
		result = this.push ("ALTER TABLE `options` ADD COLUMN `enum` TEXT;");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot add column 'enum': %d, %s\n", result, db.errmsg ());
        }
		result = this.push ("ALTER TABLE `options` ADD COLUMN `type` TEXT DEFAULT 'string';");
        if (result != Sqlite.OK && DEBUG) {
            warning ("Cannot add column 'type': %d, %s\n", result, db.errmsg ());
        }
        
//		this.push ("DROP VIEW IF EXISTS `history`;");
//		this.push ("CREATE TEMP VIEW `history` AS SELECT DISTINCT (`addr`) as `addr`, `name`, `access_date`, `close_date` FROM `quickdata` WHERE `type` = 'history' ORDER BY `access_date` DESC LIMIT 100;");
		this.push ("DROP VIEW IF EXISTS `bookmark`;");
		this.push ("CREATE TEMP VIEW `bookmark` AS SELECT DISTINCT (`addr`) as `addr`, `name`, `access_date` FROM `quickdata` WHERE `type` = 'bookmark';");
		
        if (DEBUG)
			warning ( "views created" );
	}

	private Database? open_tear_db (string tear_path) {
	    Database db;
	    int result;
	    
		result = Database.open (tear_path, out db);
        if (result != Sqlite.OK)
            warning ("Can't open/create database: %d, %s\n", result, db.errmsg ());

        if (DEBUG)
			warning ( "database opened" );
			
//		db.busy_timeout(10000);

		return db;
	}

	public int push (string sql) {
	    int result;
		
   		db.exec ("BEGIN;");
		result = db.exec ( sql );
   		db.exec ("COMMIT;");
		
		return result;
	}

	public string[]? pull (string sql, out int nrows, out int ncols, out int result) {
	    string errmsg;
	    
		result = this.get_table ( sql, out errmsg );
		
        if (result != Sqlite.OK) {
        	warning (db.errmsg());
	        return null;
		}

		nrows = this.nr;
		ncols = this.nc;
		
		return this.table;
	}


	static int get_table_cb(int n_columns, string[] values, string[] column_names){
		int i; int x;

		if (dbqueue.iter == 0) {
			for ( i=0; i < n_columns; i++ ) {
				dbqueue.table[i] = column_names[i];
			}
				
			dbqueue.iter++;
			dbqueue.nc = n_columns;
		}
		
		x = dbqueue.iter * n_columns;
		for ( i=0; i < n_columns; i++ ) {
			dbqueue.table[x+i] = values[i];
		}
			
		dbqueue.iter++;
		
		return 0;
	}
	
	public int get_table( string sql, out string errmsg ){
		int result;

		this.nr = 0; 
		this.nc = 0;
		this.iter = 0;
		
	  	result = db.exec( sql, get_table_cb, out errmsg );
	  	this.nr = this.iter-1;

		return result;
	}
	
}
