# -*- coding: utf-8 -*-
'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
import xml.etree.ElementTree as ET

class XMLWriter(object):
    # TODO: implement meta.data version information like TC
    def __init__(self, file, versionnr=31):
        self.__file = file
        self.__versionnr = versionnr
    
    def write(self, taskModel):
        domImplementation = xml.dom.getDOMImplementation()
        self.document = domImplementation.createDocument(None, 'tasks', None)
        # TODO: meta.data version info needed here too
        pi = self.document.createProcessingInstruction('taskcoach', 
            'release="%s" tskversion="%d"'%(1, 
            self.__versionnr))
        self.document.insertBefore(pi, self.document.documentElement)
        for rootTask in taskModel.rootItems():
            self.document.documentElement.appendChild(self.taskNode(rootTask))
        
        self.document.writexml(self.__fd, newl='\n', encoding=self.__fd.encoding)
    
    def taskNode(self, task):
        return node
