#ifndef SYSTEM_INFO_WIDGET_H
#define SYSTEM_INFO_WIDGET_H
#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>

struct cpu_info{
    gint last_user, last_nice, last_sys, last_idle;
};

G_BEGIN_DECLS

typedef struct _SystemInfoWidget SystemInfoWidget;
typedef struct _SystemInfoWidgetClass SystemInfoWidgetClass;

#define SYSTEM_INFO_TYPE_HOME_PLUGIN    (system_info_home_plugin_get_type ())
#define SYSTEM_INFO_HOME_PLUGIN(obj)    (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYSTEM_INFO_TYPE_HOME_PLUGIN, SystemInfoWidget))
#define SYSTEM_INFO_HOME_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST    ((klass), SYSTEM_INFO_TYPE_HOME_PLUGIN, SystemInfoWidgetClass))
#define SYSTEM_INFO_OUT_IS_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE    ((obj), SYSTEM_INFO_TYPE_HOME_PLUGIN))
#define SYSTEM_INFO_OUT_IS_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE    ((klass), SYSTEM_INFO_TYPE_HOME_PLUGIN))
#define SYSTEM_INFO_OUT_IS_HOME_PLUGIN_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS  ((obj), SYSTEM_INFO_TYPE_HOME_PLUGIN, SystemInfoWidgetClass))

struct _SystemInfoWidget
{
    HDHomePluginItem hitem;
    struct cpu_info info;
    GtkLabel *cpu;
    GtkLabel *memory;
    gint id;
};

struct _SystemInfoWidgetClass
{
    HDHomePluginItemClass parent_class;
};

GType system_info_home_plugin_get_type(void);

G_END_DECLS

#endif
