#!/bin/sh

set -e

# wipe out temporary autotools files, necessary
# when switching between distros
rm -rf aclocal.m4 autom4te.cache config.guess config.sub config.h.in configure depcomp install-sh ltmain.sh missing

(cd src && ./gen-makefile-am.sh)

libtoolize -c
if [ -n "$SBOX_PRELOAD" ]; then
  # I broke fakeroot in my Fremantle SDK when I installed the Harmattan SDK,
  # since the upgraded fakeroot in Scratchbox is apparently not all that
  # backwards compatible. Since I don't want to uninstall the Harmattan SDK
  # and reinstall the Fremantle SDK, I seem to need this hack.
  aclocal-1.9 -I /targets/links/arch_tools/share/aclocal
else
  aclocal-1.9
fi
autoheader
automake-1.9 -a -c
autoconf
