const char *SyncEvolutionXML =
"<?xml version=\"1.0\"?>\n"
"<!-- SYNTHESIS SYNCML CLIENT Version 3.2 Configuration file -->\n"
"\n"
"<sysync_config version=\"1.0\">\n"
"\n"
"  <configvar name=\"logpath\" value=\"$(defout_path)\"/>\n"
"\n"
"  <!-- this string is output to every session debug logfile to identify the config in use -->\n"
"  <configidstring>SyncEvolution client config</configidstring>\n"
"\n"
"  <!-- information about maximum supported message and object size (in bytes) -->\n"
"  <maxmsgsize/>\n"
"  <maxobjsize/>\n"
"\n"
"  <!-- information for DevInf -->\n"
"  <model/>\n"
"  <manufacturer/>\n"
"  <hardwareversion/>\n"
"  <firmwareversion/>\n"
"  <devicetype/>\n"
"  <configdate/>\n"
"\n"
"  <debug/>\n"
"\n"
"  <transport type=\"xpt\">\n"
"    <!-- allow HTTP 1.1 kepp-alive (multiple request-answer-exchanges in single TCP connection) -->\n"
"    <keepconnection>true</keepconnection>\n"
"  </transport>\n"
"\n"
"\n"
"  <scripting>\n"
"    <looptimeout>5</looptimeout>\n"
"\n"
"    <function><![CDATA[\n"
"      // create a UID\n"
"      string newuid() {\n"
"        return \"syuid\" + NUMFORMAT(RANDOM(1000000),6,\"0\") + \".\" + (string)MILLISECONDS(NOW());\n"
"      }\n"
"    ]]></function>\n"
"    <macro name=\"VCARD_BEFOREWRITE_SCRIPT_EVOLUTION\"><![CDATA[\n"
"      // a wordaround for cellphone in evolution. for incoming contacts, if there is only one CELL,\n"
"      // strip the HOME or WORK flag from it. Evolution then should show it. */\n"
"      INTEGER i, wanted, cell_phones;\n"
"      i = 0;\n"
"      cell_phones = 0;\n"
"      while(i < SIZE(TEL_FLAGS)) {\n"
"        // 0x10 is the flag of 'cell' type of telephone\n"
"        if(TEL_FLAGS[i] & 0x10) {\n"
"          cell_phones = cell_phones + 1;\n"
"          wanted = i;\n"
"        }\n"
"        i = i + 1;\n"
"      }\n"
"      if(cell_phones == 1) {\n"
"        TEL_FLAGS[wanted] = 0x10;\n"
"      }\n"
"\n"
"      // Google sends TYPE=WORK and TYPE=HOME when it means\n"
"      // normal VOICE phone numbers. Add that flag when\n"
"      // importing into Evolution, because Evolution does not\n"
"      // display the numbers without VOICE.\n"
"      i = 0;\n"
"      while(i < SIZE(TEL_FLAGS)) {\n"
"        if(TEL_FLAGS[i] == 1 || TEL_FLAGS[i] == 2) {\n"
"          TEL_FLAGS[i] = TEL_FLAGS[i] | 8;\n"
"        }\n"
"        i = i + 1;\n"
"      }\n"
"    ]]></macro>\n"
"    <macro name=\"VCALENDAR_20TO10_PRIORITY_CONVERSION\"><![CDATA[\n"
"      //vCalendar10 has different interpretation from iCalendar20 in 'priority'.\n"
"      //see mappings:  \n"
"      //  Category      vCalendar1.0     iCalendar2.0\n"
"      //   undefined         0               0\n"
"      //   high              1             1 ~ 4\n"
"      //   normal            2               5\n"
"      //   low               3             6 ~ bigger\n"
"      if(PRIORITY<5 && PRIORITY>0) {\n"
"        PRIORITY=1;\n"
"      }else if(PRIORITY==5){\n"
"        PRIORITY=2;\n"
"      }else if(PRIORITY>5){\n"
"        PRIORITY=3;\n"
"      } // 0 is undefined and remains unchanged\n"
"    ]]></macro>\n"
"    <macro name=\"VCALENDAR_10TO20_PRIORITY_CONVERSION\"><![CDATA[\n"
"      if(PRIORITY==2) {\n"
"        PRIORITY=5;\n"
"      }else if(PRIORITY==3){\n"
"        PRIORITY=7;\n"
"      } //others remain unchanged\n"
"    ]]></macro>\n"
"    <macro name=\"VCALENDAR10_BEFOREWRITE_SCRIPT\"><![CDATA[\n"
"      $VCALENDAR_20TO10_PRIORITY_CONVERSION;\n"
"    ]]></macro>\n"
"    <macro name=\"VCALENDAR10_AFTERREAD_SCRIPT\"><![CDATA[\n"
"      $VCALENDAR_10TO20_PRIORITY_CONVERSION;\n"
"    ]]></macro>\n"
"\n"
"    <macro name=\"VCARD_INCOMING_NAMECHANGE_SCRIPT\"><![CDATA[\n"
"      STRING tmp;\n"
"      tmp=NORMALIZED(FN);\n"
"      if (tmp==EMPTY){\n"
"        tmp=N_FIRST;\n"
"        if (N_MIDDLE != EMPTY) {\n"
"          if (tmp != EMPTY) {\n"
"            tmp = tmp + \" \";\n"
"          }\n"
"          tmp = tmp + N_MIDDLE;\n"
"        }\n"
"        if (N_LAST != EMPTY) {\n"
"          if (tmp != EMPTY) {\n"
"            tmp = tmp + \" \";\n"
"          }\n"
"          tmp = tmp + N_LAST;\n"
"        }\n"
"        FN = tmp;\n"
"      }\n"
"    ]]></macro>\n"
"\n"
"		<!-- define script macros for scripts that are used by both vCalendar 1.0 and iCalendar 2.0 -->\n"
"\n"
"    <macro name=\"VCALENDAR_INCOMING_SCRIPT\"><![CDATA[\n"
"      STRING MATCHES[];\n"
"      STRING CAT,CN,EM;\n"
"      INTEGER i;\n"
"      // make sure we have all trailing and leading spaces eliminated\n"
"      DESCRIPTION=NORMALIZED(DESCRIPTION);\n"
"      SUMMARY=NORMALIZED(SUMMARY);\n"
"      // make sure that we have a DESCRIPTION\n"
"      if (DESCRIPTION==EMPTY) DESCRIPTION=SUMMARY;\n"
"      // calendar or todo\n"
"      if (ISEVENT) {\n"
"        // VEVENT\n"
"        // - handle duration cases \n"
"        if (ISDURATION(DURATION)) {\n"
"          if (DTEND==EMPTY) DTEND = DTSTART + DURATION;\n"
"          if (DTSTART==EMPTY) DTSTART = DTEND - DURATION;\n"
"        }\n"
"        // - detect alldays in vCalendar 1.0 (0:00-0:00 or 23:59 localtime)\n"
"        i = ALLDAYCOUNT(DTSTART,DTEND,TRUE);\n"
"        if (ITEMDATATYPE()==\"vCalendar10\" && i>0) {\n"
"          // DTSTART and DTEND represent allday event, make them date-only values\n"
"          // - convert start to user zone (or floating) so it represents midnight\n"
"          DTSTART = CONVERTTOUSERZONE(DTSTART);\n"
"          MAKEALLDAY(DTSTART,DTEND,i);\n"
"        }\n"
"\n"
"        // Make sure that all EXDATE times are in the same timezone as the start\n"
"        // time. Some servers send them as UTC, which is all fine and well, but\n"
"        // only if the timezone definition doesn't change. Also, libical does not\n"
"        // handle such UTC EXDATEs, so let's convert it while the UTC and\n"
"        // time zone definition (hopefully) are in sync.\n"
"        if (TIMEZONE(DTSTART) != \"UTC\" && !ISFLOATING(DTSTART)) {\n"
"          i = 0;\n"
"          timestamp exdate;\n"
"          while (i<SIZE(EXDATES)) {\n"
"            exdate = EXDATES[i];\n"
"            if (!ISDATEONLY(exdate) &&\n"
"                (TIMEZONE(exdate) == \"UTC\" || ISFLOATING(exdate))) {\n"
"              // \"unfloat\" floating time stamps: not sure whether that occcurs\n"
"              // in practice, but it looks as wrong as UTC EXDATEs\n"
"              EXDATES[i] = CONVERTTOZONE(exdate,DTSTART,TRUE);\n"
"            }\n"
"            i=i+1;\n"
"          }\n"
"        }\n"
"        // If vcalendar1.0, rrule is not secondly, minutely, or hourly, we strip time information\n"
"        // and only reserve date information\n"
"        if (ITEMDATATYPE()==\"vCalendar10\" && RR_FREQ!=\"h\" && RR_FREQ!=\"m\" && RR_FREQ!=\"s\") {\n"
"          timestamp exdate;\n"
"          i = 0;\n"
"          while (i<SIZE(EXDATES)) {\n"
"            exdate = EXDATES[i];\n"
"            if (!ISDATEONLY(exdate)) {\n"
"              EXDATES[i] = DATEONLY(exdate);\n"
"            }\n"
"            i=i+1;\n"
"          }  \n"
"        }\n"
"\n"
"        // - shape attendees (and make sure ATTENDEES[] is assigned even for empty email addresses)\n"
"        i=0;\n"
"        while(i<SIZE(ATTENDEES) || i<SIZE(ATTENDEE_CNS)) {\n"
"          PARSEEMAILSPEC(ATTENDEES[i], CN, EM);\n"
"          ATTENDEES[i] = EM; // pure email address\n"
"          // in case we have no specific common name, use the one extracted from the email\n"
"          // This catches the vCalendar 1.0 case and eventually ill-formed iCalendar 2.0 as well\n"
"          if (ATTENDEE_CNS[i]==EMPTY)\n"
"            ATTENDEE_CNS[i]=CN;\n"
"          // default participation status to needs-action\n"
"          if (ATTENDEE_PARTSTATS[i]==EMPTY)\n"
"            ATTENDEE_PARTSTATS[i]=1; // 1=needs action\n"
"          i=i+1;\n"
"        }\n"
"        // - shape organizer\n"
"        PARSEEMAILSPEC(ORGANIZER, CN, EM);\n"
"        ORGANIZER = EM; // pure email address\n"
"        if (ORGANIZER_CN==EMPTY)\n"
"          ORGANIZER_CN=CN;\n"
"      }\n"
"      else {\n"
"        // VTODO\n"
"        // - make sure we have at least a summary\n"
"        if (SUMMARY==EMPTY) SUMMARY=DESCRIPTION; // use description if we don't have a summary\n"
"        if (SUMMARY==EMPTY) SUMMARY=\"unnamed\"; // set dummy summary if we still don't have one\n"
"        // due shaping for non-iCalendar 2.0\n"
"        if (ITEMDATATYPE()==\"vCalendar10\" && ALLDAYCOUNT(DUE,DUE,TRUE,TRUE)>0) {\n"
"        	DUE = DATEONLY(DUE);\n"
"        }\n"
"        if (ITEMDATATYPE()==\"vCalendar10\") {\n"
"          $VCALENDAR_10TO20_PRIORITY_CONVERSION;\n"
"        }\n"
"      }\n"
"      // a workaround for funambol: adding 'action' for 'alarm'\n"
"      if (ITEMDATATYPE()==\"iCalendar20\") {\n"
"        if (ALARM_TIME!=EMPTY && ALARM_ACTION==EMPTY) {\n"
"            ALARM_ACTION = \"DISPLAY\";\n"
"        }\n"
"      }\n"
"    ]]></macro>\n"
"\n"
"    <macro name=\"VCALENDAR_OUTGOING_SCRIPT\"><![CDATA[\n"
"      // set UTC time of generation for iCalendar 2.0 DTSTAMP\n"
"      DGENERATED = NOW();\n"
"      // make sure we have all trailing and leading spaces eliminated\n"
"      DESCRIPTION=NORMALIZED(DESCRIPTION);\n"
"      SUMMARY=NORMALIZED(SUMMARY);\n"
"      if (ISEVENT) {\n"
"        // VEVENT\n"
"        // - combine attendee email address and common name into single string for vCalendar 1.0\n"
"        if (ITEMDATATYPE()==\"vCalendar10\") {\n"
"          i=0;\n"
"          while(i<SIZE(ATTENDEES)) {\n"
"            ATTENDEES[i] = MAKEEMAILSPEC(ATTENDEE_CNS[i], ATTENDEES[i]);\n"
"            i=i+1;\n"
"          }\n"
"          ORGANIZER = MAKEEMAILSPEC(ORGANIZER_CN, ORGANIZER);\n"
"        }\n"
"      }\n"
"      else {\n"
"        // VTODO \n"
"        // interal representation is iCalendar20\n"
"        if (ITEMDATATYPE()==\"vCalendar10\") {\n"
"          $VCALENDAR_20TO10_PRIORITY_CONVERSION;\n"
"        }\n"
"      }\n"
"      // make sure we have at least a summary\n"
"      if (SUMMARY==EMPTY) SUMMARY=SUBSTR(DESCRIPTION,0,32); // derive from description\n"
"      if (SUMMARY==EMPTY) SUMMARY=\"unnamed\"; // in case description is empty as well\n"
"      // make sure that we have a DESCRIPTION\n"
"      if (DESCRIPTION==EMPTY) DESCRIPTION=SUMMARY;\n"
"      // do NOT send duration (some servers crash when doing so)\n"
"      DURATION = UNASSIGNED;\n"
"      // shape alarm\n"
"      if (ALARM_TIME!=EMPTY) {\n"
"        if (ITEMDATATYPE()==\"iCalendar20\") {\n"
"          if (ALARM_ACTION==EMPTY) ALARM_ACTION = \"AUDIO\";\n"
"        }\n"
"        else {\n"
"          if (ALARM_MSG==EMPTY) ALARM_MSG=\"alarm\";\n"
"        }\n"
"      }\n"
"    ]]></macro>\n"
"\n"
"  </scripting>\n"
"\n"
"\n"
"  <datatypes>\n"
"\n"
"    <!-- list of internal fields representing vCard data -->\n"
"    <fieldlist name=\"contacts\">\n"
"      <field name=\"REV\" type=\"timestamp\" compare=\"never\" age=\"yes\"/>\n"
"\n"
"      <!-- Name elements -->\n"
"      <field name=\"N_LAST\" type=\"string\" compare=\"always\"/>\n"
"      <field name=\"N_FIRST\" type=\"string\" compare=\"always\"/>\n"
"      <field name=\"N_MIDDLE\" type=\"string\" compare=\"always\"/>\n"
"      <field name=\"N_PREFIX\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"N_SUFFIX\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"NICKNAME\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"TITLE\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"\n"
"      <field name=\"FN\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"FILE-AS\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"\n"
"      <field name=\"GENDER\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"\n"
"      <!-- categories and classification -->\n"
"      <field name=\"CATEGORIES\" array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"\n"
"      <!-- organisation -->\n"
"      <field name=\"ORG_NAME\" type=\"string\" compare=\"slowsync\" merge=\"fillempty\"/>\n"
"      <field name=\"ORG_DIVISION\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"ORG_OFFICE\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"ORG_TEAM\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"ROLE\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"\n"
"      <!-- birthday and anniversary (not necessarily the same) -->\n"
"      <field name=\"BDAY\" type=\"date\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"ANNIVERSARY\" type=\"date\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"\n"
"      <!-- telephone numbers -->\n"
"      <field name=\"TEL\"         array=\"yes\" type=\"telephone\" compare=\"conflict\"/>\n"
"      <field name=\"TEL_FLAGS\"   array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 0 -->\n"
"      <field name=\"TEL_LABEL\"   array=\"yes\" type=\"string\"    compare=\"conflict\"/> <!-- offset 1 -->\n"
"      <field name=\"TEL_ID\"      array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 2 -->\n"
"      <field name=\"TEL_SLOT\"    array=\"yes\" type=\"integer\"   compare=\"never\"/>    <!-- offset 3 -->\n"
"\n"
"      <!-- emails -->\n"
"      <field name=\"EMAIL\"       array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"      <field name=\"EMAIL_FLAGS\" array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 0 -->\n"
"      <field name=\"EMAIL_LABEL\" array=\"yes\" type=\"string\"    compare=\"conflict\"/> <!-- offset 1 -->\n"
"      <field name=\"EMAIL_ID\"    array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 2 -->\n"
"      <field name=\"EMAIL_SLOT\"  array=\"yes\" type=\"integer\"   compare=\"never\"/>    <!-- offset 3 -->\n"
"\n"
"      <!-- web addresses -->\n"
"      <field name=\"WEB\"         array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"WEB_FLAGS\"   array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 0 -->\n"
"      <field name=\"WEB_LABEL\"   array=\"yes\" type=\"string\"    compare=\"conflict\"/> <!-- offset 1 -->\n"
"      <field name=\"WEB_ID\"      array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 2 -->\n"
"\n"
"      <!-- would be nicer to have as part of WEB, but parser/encoder does not support mapping\n"
"           with more than one property per field -->\n"
"      <field name=\"CALURI\"      array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"FBURL\"       array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"BLOGURL\"     array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"VIDEOURL\"    array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"\n"
"      <!-- related persons: should be turned into array, like WEB and CALURI/FBURL -->\n"
"      <field name=\"MANAGER\"    type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"ASSISTANT\"  type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"SPOUSE\"     type=\"string\" compare=\"conflict\"/>\n"
"\n"
"      <!-- does this person want HTML mails? Valid values are TRUE/FALSE; a \"boolean\"\n"
"           type would be useful, maybe add that later. -->\n"
"      <field name=\"WANTS_HTML\"  type=\"string\" compare=\"conflict\"/>\n"
"\n"
"      <!-- chat handles: should be turned into one array, like WEB and CALURI/FBURL -->\n"
"      <field name=\"AIM_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"AIM_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"GADUGADU_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"GADUGADU_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"GROUPWISE_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"GROUPWISE_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"ICQ_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"ICQ_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"JABBER_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"JABBER_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"MSN_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"MSN_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"YAHOO_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"YAHOO_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"SKYPE_HANDLE\"      array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"SKYPE_SLOT\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"SIP_HANDLE\"        array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"SIP_SLOT\"          array=\"yes\" type=\"string\" compare=\"conflict\"/>\n"
"\n"
"      <!-- home address -->\n"
"      <field name=\"ADR_STREET\"        array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"      <field name=\"ADR_ADDTL\"         array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"      <field name=\"ADR_STREET_FLAGS\"  array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 0 (from ADR_STREET_FLAGS) -->\n"
"      <field name=\"ADR_STREET_LABEL\"  array=\"yes\" type=\"string\"    compare=\"conflict\"/> <!-- offset 1 -->\n"
"      <field name=\"ADR_STREET_ID\"     array=\"yes\" type=\"integer\"   compare=\"conflict\"/> <!-- offset 2 -->\n"
"      <field name=\"ADR_POBOX\"         array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"      <field name=\"ADR_CITY\"          array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"      <field name=\"ADR_REG\"           array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"      <field name=\"ADR_ZIP\"           array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"      <field name=\"ADR_COUNTRY\"       array=\"yes\" type=\"multiline\" compare=\"conflict\"/>\n"
"\n"
"      <!-- Note -->\n"
"      <field name=\"NOTE\" type=\"multiline\" compare=\"conflict\" merge=\"lines\"/>\n"
"\n"
"      <!-- Photo -->\n"
"      <field name=\"PHOTO\" type=\"blob\" compare=\"never\" merge=\"fillempty\"/>\n"
"      <field name=\"PHOTO_TYPE\" type=\"integer\" compare=\"never\" merge=\"fillempty\"/>\n"
"\n"
"    </fieldlist>\n"
"\n"
"    <!-- vCard profile -->\n"
"    <mimeprofile name=\"vCard\" fieldlist=\"contacts\">\n"
"\n"
"      <profile name=\"VCARD\" nummandatory=\"0\"> <!-- we allow records without \"N\" as Address book can store them -->\n"
"        <property name=\"VERSION\">\n"
"          <value conversion=\"version\"/>\n"
"        </property>\n"
"\n"
"        <property onlyformode=\"standard\" name=\"PRODID\" mandatory=\"no\">\n"
"          <value conversion=\"prodid\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"REV\">\n"
"          <value field=\"REV\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"N\" values=\"5\" mandatory=\"yes\"> <!-- Note: makes N parse and generate even if not in remote's CTCap -->\n"
"          <value index=\"0\" field=\"N_LAST\"/>\n"
"          <value index=\"1\" field=\"N_FIRST\"/>\n"
"          <value index=\"2\" field=\"N_MIDDLE\"/>\n"
"          <value index=\"3\" field=\"N_PREFIX\"/>\n"
"          <value index=\"4\" field=\"N_SUFFIX\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"FN\">\n"
"          <value field=\"FN\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-EVOLUTION-FILE-AS\">\n"
"          <value field=\"FILE-AS\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-GENDER\">\n"
"          <value field=\"GENDER\"/>\n"
"        </property>\n"
"\n"
"        <!-- onlyformode=\"standard\": not part of vCard 2.1, but some\n"
"             peers (like the Funambol server) accept it anyway in\n"
"             vCard 2.1 -->\n"
"        <property name=\"NICKNAME\">\n"
"          <value field=\"NICKNAME\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"TITLE\">\n"
"          <value field=\"TITLE\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"CATEGORIES\" values=\"list\" valueseparator=\",\" altvalueseparator=\";\" > <!-- non-standard, but 1:1 as in vCard 3.0 (NOT like in vCalendar 1.0, where separator is \";\") -->\n"
"          <value field=\"CATEGORIES\"/>\n"
"          <position field=\"CATEGORIES\" repeat=\"array\" increment=\"1\" minshow=\"0\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"ORG\" values=\"4\">\n"
"          <value index=\"0\" field=\"ORG_NAME\"/>\n"
"          <value index=\"1\" field=\"ORG_DIVISION\"/>\n"
"          <value index=\"2\" field=\"ORG_OFFICE\"/>\n"
"          <value index=\"3\" field=\"ORG_TEAM\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"ROLE\">\n"
"          <value field=\"ROLE\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"TEL\">\n"
"          <value field=\"TEL\"/>\n"
"          <position field=\"TEL\" repeat=\"array\" increment=\"1\" minshow=\"1\"/>\n"
"          <parameter name=\"TYPE\" default=\"yes\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"TEL_FLAGS\" conversion=\"multimix\" combine=\",\">\n"
"              <enum name=\"HOME\"     value=\"B0\"/>\n"
"              <enum name=\"WORK\"     value=\"B1\"/>\n"
"              <enum mode=\"ignore\"   value=\"B2\"/> <!-- OTHER -->\n"
"              <enum name=\"VOICE\"    value=\"B3\"/>\n"
"              <enum name=\"CELL\"     value=\"B4\"/>\n"
"              <enum name=\"FAX\"      value=\"B5\"/>\n"
"              <enum name=\"PAGER\"    value=\"B6\"/>\n"
"              <enum name=\"PREF\"     value=\"B7\"/>\n"
"              <enum name=\"CAR\"      value=\"B8\"/>\n"
"              <enum name=\"X-EVOLUTION-CALLBACK\" value=\"B9\"/>\n"
"              <enum name=\"X-EVOLUTION-RADIO\" value=\"B10\"/>\n"
"              <enum name=\"X-EVOLUTION-TELEX\" value=\"B11\"/>\n"
"              <enum name=\"X-EVOLUTION-TTYTDD\" value=\"B12\"/>\n"
"\n"
"              <enum mode=\"prefix\" name=\"X-CustomLabel-\" value=\"1.L\"/>\n"
"              <enum mode=\"prefix\" name=\"X-Synthesis-Ref\" value=\"2.L\"/>\n"
"            </value>\n"
"          </parameter>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"TEL_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"        <property name=\"EMAIL\">\n"
"          <value field=\"EMAIL\"/>\n"
"          <position field=\"EMAIL\" repeat=\"array\" increment=\"1\" minshow=\"1\"/>\n"
"          <parameter name=\"TYPE\" default=\"yes\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"EMAIL_FLAGS\" conversion=\"multimix\" combine=\",\">\n"
"              <enum name=\"HOME\"     value=\"B0\"/>\n"
"              <enum name=\"WORK\"     value=\"B1\"/>\n"
"              <enum mode=\"ignore\"   value=\"B2\"/> <!-- OTHER -->\n"
"              <enum name=\"INTERNET\" value=\"B3\"/>\n"
"\n"
"              <enum mode=\"prefix\" name=\"X-CustomLabel-\" value=\"1.L\"/>\n"
"              <enum mode=\"prefix\" name=\"X-Synthesis-Ref\" value=\"2.L\"/>\n"
"            </value>\n"
"          </parameter>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"EMAIL_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"        <property name=\"URL\">\n"
"          <value field=\"WEB\"/>\n"
"          <position field=\"WEB\" repeat=\"array\" increment=\"1\" minshow=\"1\"/>\n"
"          <parameter name=\"TYPE\" default=\"yes\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"WEB_FLAGS\" conversion=\"multimix\" combine=\",\">\n"
"              <enum name=\"HOME\"     value=\"B0\"/>\n"
"              <enum name=\"WORK\"     value=\"B1\"/>\n"
"              <enum mode=\"ignore\"   value=\"B2\"/> <!-- OTHER -->\n"
"              <enum name=\"PREF\"     value=\"B3\"/>\n"
"\n"
"              <enum mode=\"prefix\" name=\"X-CustomLabel-\" value=\"1.L\"/>\n"
"              <enum mode=\"prefix\" name=\"X-Synthesis-Ref\" value=\"2.L\"/>\n"
"            </value>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"        <property name=\"CALURI\" suppressempty=\"yes\">\n"
"          <value field=\"CALURI\" show=\"yes\"/>\n"
"        </property>\n"
"        <property name=\"FBURL\" suppressempty=\"yes\">\n"
"          <value field=\"FBURL\" show=\"yes\"/>\n"
"        </property>\n"
"        <property name=\"X-EVOLUTION-BLOG-URL\" suppressempty=\"yes\">\n"
"          <value field=\"BLOGURL\" show=\"yes\"/>\n"
"        </property>\n"
"        <property name=\"X-EVOLUTION-VIDEO-URL\" suppressempty=\"yes\">\n"
"          <value field=\"VIDEOURL\" show=\"yes\"/>\n"
"        </property>\n"
"\n"
"        <!-- item for SyncML server: EVOLUTION rule not active,\n"
"             both X-EVOLUTION-MANAGER and X-MANAGER are sent.\n"
"\n"
"             item from SyncML server: EVOLUTION rule not active,\n"
"             both X-EVOLUTION-MANAGER and X-MANAGER are checked,\n"
"             but X-EVOLUTION-MANAGER later so that it overwrites\n"
"             a value set earlier by X-MANAGER (if any). This is\n"
"             a more or less arbitrary priority, chosen because\n"
"             servers that know about SyncEvolution (ScheduleWorld,\n"
"             Memotoo) use the X-EVOLUTION variant.\n"
"\n"
"             item to/from Evolution: EVOLUTION rule is active,\n"
"             only X-EVOLUTION-MANAGER is used. -->\n"
"        <property name=\"X-EVOLUTION-MANAGER\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"          <value field=\"MANAGER\" show=\"yes\"/>\n"
"        </property>\n"
"        <property name=\"X-MANAGER\" suppressempty=\"yes\" rule=\"EVOLUTION\"/> <!-- disables the X-MANAGER for EVOLUTION -->\n"
"        <property name=\"X-MANAGER\" suppressempty=\"yes\" rule=\"other\">\n"
"          <value field=\"MANAGER\" show=\"yes\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-EVOLUTION-ASSISTANT\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"          <value field=\"ASSISTANT\" show=\"yes\"/>\n"
"        </property>\n"
"        <property name=\"X-ASSISTANT\" suppressempty=\"yes\" rule=\"EVOLUTION\"/>\n"
"        <property name=\"X-ASSISTANT\" suppressempty=\"yes\" rule=\"other\">\n"
"          <value field=\"ASSISTANT\" show=\"yes\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-EVOLUTION-SPOUSE\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"          <value field=\"SPOUSE\" show=\"yes\"/>\n"
"        </property>\n"
"        <property name=\"X-SPOUSE\" suppressempty=\"yes\" rule=\"EVOLUTION\"/>\n"
"        <property name=\"X-SPOUSE\" suppressempty=\"yes\" rule=\"other\">\n"
"          <value field=\"SPOUSE\" show=\"yes\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-EVOLUTION-ANNIVERSARY\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"          <value field=\"ANNIVERSARY\" show=\"yes\"/>\n"
"        </property>\n"
"        <property name=\"X-ANNIVERSARY\" suppressempty=\"yes\" rule=\"EVOLUTION\"/>\n"
"        <property name=\"X-ANNIVERSARY\" suppressempty=\"yes\" rule=\"other\">\n"
"          <value field=\"ANNIVERSARY\" show=\"yes\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-MOZILLA-HTML\">\n"
"          <value field=\"WANTS_HTML\" show=\"yes\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-AIM\" suppressempty=\"yes\">\n"
"          <value field=\"AIM_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"AIM_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"        <property name=\"X-GADUGADU\" suppressempty=\"yes\">\n"
"          <value field=\"GADUGADU_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"GADUGADU_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"        <property name=\"X-GROUPWISE\" suppressempty=\"yes\">\n"
"          <value field=\"GROUPWISE_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"GROUPWISE_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"        <property name=\"X-ICQ\" suppressempty=\"yes\">\n"
"          <value field=\"ICQ_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"ICQ_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"        <property name=\"X-JABBER\" suppressempty=\"yes\">\n"
"          <value field=\"JABBER_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"JABBER_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"        <property name=\"X-MSN\" suppressempty=\"yes\">\n"
"          <value field=\"MSN_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"MSN_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"        <property name=\"X-YAHOO\" suppressempty=\"yes\">\n"
"          <value field=\"YAHOO_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"YAHOO_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"        <property name=\"X-SKYPE\" suppressempty=\"yes\"> \n"
"          <value field=\"SKYPE_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"SKYPE_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"        <property name=\"X-SIP\" suppressempty=\"yes\">\n"
"          <value field=\"SIP_HANDLE\"/>\n"
"          <parameter name=\"X-EVOLUTION-UI-SLOT\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"SIP_SLOT\"/>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"        <property name=\"ADR\" values=\"7\">\n"
"          <value index=\"0\" field=\"ADR_POBOX\"/>\n"
"          <value index=\"1\" field=\"ADR_ADDTL\"/>\n"
"          <value index=\"2\" field=\"ADR_STREET\"/>\n"
"          <value index=\"3\" field=\"ADR_CITY\"/>\n"
"          <value index=\"4\" field=\"ADR_REG\"/>\n"
"          <value index=\"5\" field=\"ADR_ZIP\"/>\n"
"          <value index=\"6\" field=\"ADR_COUNTRY\"/>\n"
"          <position field=\"ADR_POBOX\" repeat=\"array\" increment=\"1\" minshow=\"1\"/>\n"
"          <parameter name=\"TYPE\" default=\"yes\" positional=\"no\" show=\"yes\">\n"
"            <value field=\"ADR_STREET_FLAGS\" conversion=\"multimix\" combine=\",\">\n"
"              <enum name=\"HOME\"     value=\"B0\"/>\n"
"              <enum name=\"WORK\"     value=\"B1\"/>\n"
"              <enum mode=\"ignore\"   value=\"B2\"/> <!-- OTHER -->\n"
"\n"
"              <enum mode=\"prefix\" name=\"X-CustomLabel-\" value=\"1.L\"/>\n"
"              <enum mode=\"prefix\" name=\"X-Synthesis-Ref\" value=\"2.L\"/>\n"
"            </value>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"        <property name=\"BDAY\">\n"
"          <value field=\"BDAY\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"NOTE\" filter=\"no\">\n"
"          <value field=\"NOTE\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"PHOTO\" filter=\"no\">\n"
"          <value field=\"PHOTO\" conversion=\"BLOB_B64\"/>\n"
"          <parameter name=\"TYPE\" default=\"no\" show=\"yes\">\n"
"            <value field=\"PHOTO_TYPE\">\n"
"              <enum name=\"JPEG\" value=\"0\"/>\n"
"            </value>\n"
"          </parameter>\n"
"        </property>\n"
"\n"
"      </profile>\n"
"    </mimeprofile>\n"
"\n"
"    <!-- vCard 2.1 datatype, using vCard profile defined above -->\n"
"    <datatype name=\"vCard21\" basetype=\"vcard\">\n"
"      <version>2.1</version>\n"
"      <use mimeprofile=\"vCard\"/>\n"
"     <incomingscript><![CDATA[\n"
"        $VCARD_INCOMING_NAMECHANGE_SCRIPT\n"
"      ]]></incomingscript>\n"
"    </datatype>\n"
"\n"
"    <!-- vCard 3.0 datatype, using vCard profile defined above -->\n"
"    <datatype name=\"vCard30\" basetype=\"vcard\">\n"
"      <version>3.0</version>\n"
"      <use mimeprofile=\"vCard\"/>\n"
"      <incomingscript><![CDATA[\n"
"        $VCARD_INCOMING_NAMECHANGE_SCRIPT\n"
"      ]]></incomingscript>\n"
"    </datatype>\n"
"\n"
"\n"
"    <!-- common field list for events and todos (both represented by vCalendar/iCalendar) -->\n"
"    <fieldlist name=\"calendar\">\n"
"      <field name=\"ISEVENT\" type=\"integer\" compare=\"always\"/>\n"
"\n"
"      <field name=\"DMODIFIED\" type=\"timestamp\" compare=\"never\" age=\"yes\"/>\n"
"      <field name=\"DCREATED\" type=\"timestamp\" compare=\"never\"/>\n"
"\n"
"      <field name=\"DGENERATED\" type=\"timestamp\" compare=\"never\"/>\n"
"\n"
"      <field name=\"UID\" type=\"string\" compare=\"never\"/>\n"
"\n"
"      <field name=\"CATEGORIES\" array=\"yes\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"CLASS\" type=\"integer\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"TRANSP\" type=\"integer\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"\n"
"      <field name=\"SUMMARY\" type=\"multiline\" compare=\"always\"/>\n"
"      <field name=\"DESCRIPTION\" type=\"multiline\" compare=\"slowsync\" merge=\"lines\"/>\n"
"      <field name=\"LOCATION\" type=\"multiline\" compare=\"slowsync\" merge=\"lines\"/>\n"
"      <field name=\"URL\" type=\"url\" compare=\"conflict\"/>\n"
"\n"
"      <!-- recurrence rule block, fields must be in that order, including\n"
"           DTSTART as last field !! -->\n"
"      <field name=\"RR_FREQ\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"RR_INTERVAL\" type=\"integer\" compare=\"conflict\"/>\n"
"      <field name=\"RR_FMASK\" type=\"integer\" compare=\"conflict\"/>\n"
"      <field name=\"RR_LMASK\" type=\"integer\" compare=\"conflict\"/>\n"
"      <field name=\"RR_END\" type=\"timestamp\" compare=\"conflict\"/>\n"
"\n"
"      <!-- Note: DTSTART/DTEND are compared in the <comparescript>,\n"
"                 therefore compare is set no \"never\" here -->\n"
"      <field name=\"DTSTART\" type=\"timestamp\" compare=\"never\"/>\n"
"      <field name=\"DTEND\" type=\"timestamp\" compare=\"never\"/>\n"
"      <field name=\"DURATION\" type=\"timestamp\" compare=\"never\"/>\n"
"      <field name=\"COMPLETED\" type=\"timestamp\" compare=\"never\"/>\n"
"      <field name=\"DUE\" type=\"timestamp\" compare=\"never\"/>\n"
"\n"
"      <field name=\"GEO_LAT\" type=\"string\" compare=\"never\"/>\n"
"      <field name=\"GEO_LONG\" type=\"string\" compare=\"never\"/>\n"
"\n"
"      <field name=\"PRIORITY\" type=\"integer\" compare=\"conflict\"/>\n"
"      <field name=\"STATUS\" type=\"integer\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"PERCENT_COMPLETE\" type=\"integer\" compare=\"conflict\"/>\n"
"\n"
"      <field name=\"ALARM_TIME\" type=\"timestamp\" compare=\"conflict\"/>\n"
"      <field name=\"ALARM_SNOOZE\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"ALARM_REPEAT\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"ALARM_MSG\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"ALARM_ACTION\" type=\"string\" compare=\"conflict\"/>\n"
"      <field name=\"ALARM_REL\" type=\"integer\" compare=\"never\"/>\n"
"      <field name=\"ALARM_UID\" type=\"string\" compare=\"conflict\"/>\n"
"\n"
"      <!-- non-standard -->\n"
"      <field name=\"PARENT_UID\" type=\"string\" compare=\"never\"/>\n"
"\n"
"      <!-- for events -->\n"
"      <field name=\"EXDATES\" array=\"yes\" type=\"timestamp\" compare=\"never\"/>\n"
"\n"
"      <field name=\"ORIGSTART\" array=\"no\" type=\"timestamp\" compare=\"never\"/>\n"
"      <field name=\"SEQNO\" array=\"no\" type=\"integer\" compare=\"never\"/>\n"
"\n"
"      <field name=\"ATTENDEES\" array=\"yes\" type=\"string\" compare=\"never\"/>\n"
"      <field name=\"ATTENDEE_CNS\" array=\"yes\" type=\"string\" compare=\"never\"/>\n"
"      <field name=\"ATTENDEE_PARTSTATS\" array=\"yes\" type=\"integer\" compare=\"never\"/>\n"
"      <field name=\"ATTENDEE_ROLE\" array=\"yes\" type=\"integer\" compare=\"never\"/>\n"
"      <field name=\"ATTENDEE_RSVP\" array=\"yes\" type=\"integer\" compare=\"never\"/>\n"
"      <field name=\"ATTENDEE_LANG\" array=\"yes\" type=\"string\" compare=\"never\"/>\n"
"      <field name=\"ATTENDEE_CUTYPE\" array=\"yes\" type=\"integer\" compare=\"never\"/>\n"
"      <field name=\"ORGANIZER\" array=\"no\" type=\"string\" compare=\"never\"/>\n"
"      <field name=\"ORGANIZER_CN\" array=\"no\" type=\"string\" compare=\"never\"/>\n"
"\n"
"    </fieldlist>\n"
"\n"
"\n"
"    <!-- vCalendar with VTODO and VEVENT variants -->\n"
"    <mimeprofile name=\"vCalendar\" fieldlist=\"calendar\">\n"
"\n"
"      <vtimezonegenmode>current</vtimezonegenmode>\n"
"      <tzidgenmode>olson</tzidgenmode>\n"
"\n"
"      <profile name=\"VCALENDAR\" nummandatory=\"1\">\n"
"\n"
"        <property name=\"VERSION\" mandatory=\"yes\">\n"
"          <value conversion=\"version\"/>\n"
"        </property>\n"
"\n"
"        <property onlyformode=\"standard\" name=\"PRODID\" mandatory=\"no\">\n"
"          <value conversion=\"prodid\"/>\n"
"        </property>\n"
"\n"
"        <property onlyformode=\"old\" name=\"TZ\" filter=\"false\" suppressempty=\"yes\">\n"
"          <value field=\"DTSTART\" conversion=\"tz\"/>\n"
"        </property>\n"
"\n"
"        <property onlyformode=\"old\" name=\"DAYLIGHT\" mode=\"daylight\" filter=\"false\" suppressempty=\"yes\">\n"
"          <value field=\"DTSTART\" conversion=\"daylight\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"GEO\" values=\"2\" suppressempty=\"yes\" onlyformode=\"old\" valueseparator=\",\">\n"
"          <!-- LON,LAT in vCalendar 1.0 -->\n"
"          <value index=\"0\" field=\"GEO_LAT\"/>\n"
"          <value index=\"1\" field=\"GEO_LONG\"/>\n"
"        </property>\n"
"\n"
"        <subprofile onlyformode=\"standard\" name=\"VTIMEZONE\" mode=\"vtimezones\"/>\n"
"\n"
"        <!-- sub-profile for todoz -->\n"
"        <subprofile name=\"VTODO\" nummandatory=\"1\" showifselectedonly=\"yes\" field=\"ISEVENT\" value=\"0\">\n"
"\n"
"          <property name=\"LAST-MODIFIED\" suppressempty=\"yes\">\n"
"            <value field=\"DMODIFIED\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"DTSTAMP\" suppressempty=\"yes\" onlyformode=\"standard\">\n"
"            <value field=\"DGENERATED\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"DCREATED\" suppressempty=\"yes\" onlyformode=\"old\">\n"
"            <value field=\"DCREATED\"/>\n"
"          </property>\n"
"          <property name=\"CREATED\" suppressempty=\"yes\" onlyformode=\"standard\">\n"
"            <value field=\"DCREATED\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"UID\" suppressempty=\"yes\">\n"
"            <value field=\"UID\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"SEQUENCE\" suppressempty=\"yes\">\n"
"            <value field=\"SEQNO\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"GEO\" values=\"2\" suppressempty=\"yes\" onlyformode=\"standard\" valueseparator=\";\">\n"
"            <!-- LAT;LON in iCalendar 2.0 -->\n"
"            <value index=\"0\" field=\"GEO_LONG\"/>\n"
"            <value index=\"1\" field=\"GEO_LAT\"/>\n"
"          </property>\n"
"\n"
"          <property onlyformode=\"standard\" name=\"CATEGORIES\" values=\"list\" valueseparator=\",\" suppressempty=\"yes\">\n"
"            <value field=\"CATEGORIES\" />\n"
"            <position field=\"CATEGORIES\" repeat=\"array\" minshow=\"0\"/>\n"
"          </property>\n"
"\n"
"          <property onlyformode=\"old\" name=\"CATEGORIES\" values=\"list\" valueseparator=\";\" altvalueseparator=\",\" suppressempty=\"yes\">\n"
"            <value field=\"CATEGORIES\" />\n"
"            <position field=\"CATEGORIES\" repeat=\"array\" minshow=\"0\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"CLASS\" suppressempty=\"yes\">\n"
"            <value field=\"CLASS\">\n"
"              <enum name=\"PUBLIC\"       value=\"0\"/>\n"
"              <enum name=\"PRIVATE\"      value=\"1\"/>\n"
"              <enum name=\"CONFIDENTIAL\" value=\"2\"/>\n"
"            </value>\n"
"          </property>\n"
"\n"
"          <property name=\"SUMMARY\" mandatory=\"yes\">\n"
"            <value field=\"SUMMARY\"/>\n"
"          </property>\n"
"\n"
"          <!-- DESCRIPTION is an optional property and libical does not like\n"
"               empty properties, so suppress it here. However, in the scripts\n"
"               we ensure that the DESCRIPTION field should never be empty. -->\n"
"          <property name=\"DESCRIPTION\" suppressempty=\"yes\" mandatory=\"no\">\n"
"            <value field=\"DESCRIPTION\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"LOCATION\" suppressempty=\"yes\" mandatory=\"no\">\n"
"            <value field=\"LOCATION\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"URL\" suppressempty=\"yes\" mandatory=\"no\">\n"
"            <value field=\"URL\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"DTSTART\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"            <value field=\"DTSTART\" conversion=\"autodate\"/>\n"
"            <parameter onlyformode=\"standard\" name=\"TZID\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DTSTART\" conversion=\"TZID\"/>\n"
"            </parameter>\n"
"            <parameter onlyformode=\"standard\" name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DTSTART\" conversion=\"VALUETYPE\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"COMPLETED\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"            <value field=\"COMPLETED\" conversion=\"autoenddate\"/>\n"
"            <parameter onlyformode=\"standard\" name=\"TZID\" default=\"no\" show=\"yes\">\n"
"              <value field=\"COMPLETED\" conversion=\"TZID\"/>\n"
"            </parameter>\n"
"            <parameter onlyformode=\"standard\" name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"COMPLETED\" conversion=\"VALUETYPE\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"DUE\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"            <value field=\"DUE\" conversion=\"autodate\"/>\n"
"            <parameter onlyformode=\"standard\" name=\"TZID\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DUE\" conversion=\"TZID\"/>\n"
"            </parameter>\n"
"            <parameter onlyformode=\"standard\" name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DUE\" conversion=\"VALUETYPE\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"PRIORITY\" suppressempty=\"yes\">\n"
"            <value field=\"PRIORITY\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"STATUS\" onlyformode=\"standard\" suppressempty=\"yes\">\n"
"            <value field=\"STATUS\" conversion=\"emptyonly\">\n"
"              <enum name=\"COMPLETED\"      value=\"0\"/>\n"
"              <enum name=\"NEEDS-ACTION\"   value=\"1\"/>\n"
"              <enum name=\"IN-PROCESS\"     value=\"2\"/>\n"
"              <enum name=\"CANCELLED\"      value=\"3\"/>\n"
"              <enum name=\"ACCEPTED\"       value=\"4\"/>\n"
"              <enum name=\"TENTATIVE\"      value=\"5\"/>\n"
"              <enum name=\"DELEGATED\"      value=\"6\"/>\n"
"              <enum name=\"DECLINED\"       value=\"7\"/>\n"
"              <enum name=\"SENT\"           value=\"8\"/>\n"
"              <enum name=\"CONFIRMED\"      value=\"9\"/>\n"
"              <enum name=\"DRAFT\"          value=\"10\"/>\n"
"              <enum name=\"FINAL\"          value=\"11\"/>\n"
"            </value>\n"
"          </property>\n"
"\n"
"          <property name=\"STATUS\" onlyformode=\"old\" suppressempty=\"yes\">\n"
"            <value field=\"STATUS\" conversion=\"emptyonly\">\n"
"              <enum name=\"COMPLETED\"      value=\"0\"/>\n"
"              <enum name=\"NEEDS ACTION\"   value=\"1\"/>\n"
"              <enum mode=\"defaultvalue\"   value=\"1\"/> <!-- catch unknown, but also non-conformant NEEDS_ACTION -->\n"
"              <enum name=\"IN PROCESS\"     value=\"2\"/>\n"
"              <enum name=\"CANCELLED\"      value=\"3\"/>\n"
"              <enum name=\"ACCEPTED\"       value=\"4\"/>\n"
"              <enum name=\"TENTATIVE\"      value=\"5\"/>\n"
"              <enum name=\"DELEGATED\"      value=\"6\"/>\n"
"              <enum name=\"DECLINED\"       value=\"7\"/>\n"
"              <enum name=\"SENT\"           value=\"8\"/>\n"
"              <enum name=\"CONFIRMED\"      value=\"9\"/>\n"
"              <enum name=\"DRAFT\"          value=\"10\"/>\n"
"              <enum name=\"FINAL\"          value=\"11\"/>\n"
"            </value>\n"
"          </property>\n"
"\n"
"          <property name=\"PERCENT-COMPLETE\" onlyformode=\"standard\" suppressempty=\"yes\">\n"
"            <value field=\"PERCENT_COMPLETE\"/>\n"
"          </property>          \n"
"\n"
"          <!-- AALARM and DALARM both use the same fields -->\n"
"          <property name=\"AALARM\" onlyformode=\"old\" values=\"4\" suppressempty=\"yes\">\n"
"            <value index=\"0\" field=\"ALARM_TIME\" conversion=\"emptyonly\"/>\n"
"            <value index=\"1\" field=\"ALARM_SNOOZE\" conversion=\"emptyonly\"/>\n"
"            <value index=\"2\" field=\"ALARM_REPEAT\" conversion=\"emptyonly\"/>\n"
"            <value index=\"3\" field=\"ALARM_MSG\" conversion=\"emptyonly\"/>\n"
"          </property>\n"
"          <property name=\"DALARM\" onlyformode=\"old\" values=\"4\" suppressempty=\"yes\">\n"
"            <value index=\"0\" field=\"ALARM_TIME\" conversion=\"emptyonly\"/>\n"
"            <value index=\"1\" field=\"ALARM_SNOOZE\" conversion=\"emptyonly\"/>\n"
"            <value index=\"2\" field=\"ALARM_REPEAT\" conversion=\"emptyonly\"/>\n"
"            <value index=\"3\" field=\"ALARM_MSG\" conversion=\"emptyonly\"/>\n"
"          </property>\n"
"\n"
"          <subprofile onlyformode=\"standard\" name=\"VALARM\" nummandatory=\"1\" field=\"ALARM_TIME\">\n"
"            <property name=\"TRIGGER\" suppressempty=\"no\" mandatory=\"yes\">\n"
"              <value field=\"ALARM_TIME\"/>\n"
"              <parameter name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"                <value field=\"ALARM_TIME\" conversion=\"FULLVALUETYPE\"/>\n"
"              </parameter>\n"
"              <parameter name=\"RELATED\" default=\"no\" show=\"yes\">\n"
"                <value field=\"ALARM_REL\">\n"
"                  <enum mode=\"ignore\" value=\"0\"/>\n"
"                  <enum name=\"START\" value=\"1\"/>\n"
"                  <enum name=\"END\"   value=\"2\"/>\n"
"                </value>\n"
"              </parameter>\n"
"            </property>\n"
"            <property name=\"ACTION\" suppressempty=\"yes\" mandatory=\"yes\">\n"
"              <value field=\"ALARM_ACTION\"/>\n"
"            </property>\n"
"            <property name=\"DESCRIPTION\" suppressempty=\"yes\">\n"
"              <value field=\"ALARM_MSG\"/>\n"
"            </property>\n"
"            <property name=\"REPEAT\" suppressempty=\"yes\">\n"
"              <value field=\"ALARM_REPEAT\"/>\n"
"            </property>\n"
"            <property name=\"X-EVOLUTION-ALARM-UID\" suppressempty=\"yes\">\n"
"              <value field=\"ALARM_UID\"/>\n"
"            </property>\n"
"          </subprofile>\n"
"\n"
"          <property onlyformode=\"old\" name=\"RELATED-TO\" suppressempty=\"yes\">\n"
"            <value field=\"PARENT_UID\"/>\n"
"          </property>\n"
"\n"
"          <property onlyformode=\"standard\" name=\"RELATED-TO\" suppressempty=\"yes\">\n"
"            <value field=\"PARENT_UID\"/>\n"
"            <parameter onlyformode=\"standard\" name=\"RELTYPE\" default=\"no\" positional=\"yes\" show=\"yes\">\n"
"              <value>\n"
"                <enum name=\"PARENT\"/>\n"
"                <enum mode=\"defaultvalue\" name=\"other\"/>\n"
"              </value>\n"
"              <position hasnot=\"other\" shows=\"PARENT\" field=\"PARENT_UID\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"        </subprofile>\n"
"\n"
"        <!-- sub-profile for event -->\n"
"        <subprofile name=\"VEVENT\" nummandatory=\"1\" showifselectedonly=\"yes\" field=\"ISEVENT\" value=\"1\">\n"
"\n"
"          <property name=\"LAST-MODIFIED\" suppressempty=\"yes\">\n"
"            <value field=\"DMODIFIED\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"DTSTAMP\" suppressempty=\"yes\" onlyformode=\"standard\">\n"
"            <value field=\"DGENERATED\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"DCREATED\" suppressempty=\"yes\" onlyformode=\"old\">\n"
"            <value field=\"DCREATED\"/>\n"
"          </property>\n"
"          <property name=\"CREATED\" suppressempty=\"yes\" onlyformode=\"standard\">\n"
"            <value field=\"DCREATED\"/>\n"
"          </property>\n"
"\n"
"\n"
"          <property name=\"UID\" suppressempty=\"yes\">\n"
"            <value field=\"UID\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"SEQUENCE\" suppressempty=\"yes\">\n"
"            <value field=\"SEQNO\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"GEO\" values=\"2\" suppressempty=\"yes\" onlyformode=\"standard\" valueseparator=\";\">\n"
"            <!-- LAT;LON in iCalendar 2.0 -->\n"
"            <value index=\"0\" field=\"GEO_LONG\"/>\n"
"            <value index=\"1\" field=\"GEO_LAT\"/>\n"
"          </property>\n"
"\n"
"          <property onlyformode=\"standard\" name=\"CATEGORIES\" values=\"list\" valueseparator=\",\" suppressempty=\"yes\">\n"
"            <value field=\"CATEGORIES\" />\n"
"            <position field=\"CATEGORIES\" repeat=\"array\" minshow=\"0\"/>\n"
"          </property>\n"
"\n"
"          <property onlyformode=\"old\" name=\"CATEGORIES\" values=\"list\" valueseparator=\";\" altvalueseparator=\",\" suppressempty=\"yes\">\n"
"            <value field=\"CATEGORIES\" />\n"
"            <position field=\"CATEGORIES\" repeat=\"array\" minshow=\"0\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"CLASS\" suppressempty=\"yes\">\n"
"            <value field=\"CLASS\">\n"
"              <enum name=\"PUBLIC\"       value=\"0\"/>\n"
"              <enum name=\"PRIVATE\"      value=\"1\"/>\n"
"              <enum name=\"CONFIDENTIAL\" value=\"2\"/>\n"
"            </value>\n"
"          </property>\n"
"\n"
"\n"
"          <property name=\"TRANSP\" suppressempty=\"yes\" onlyformode=\"standard\">\n"
"            <value field=\"TRANSP\">\n"
"              <enum name=\"OPAQUE\"       value=\"0\"/>\n"
"              <enum name=\"TRANSPARENT\"  value=\"1\"/>\n"
"              <enum name=\"TENTATIVE\"     value=\"2\"/> <!-- according to Oracle de facto usage in vCalendar 1.0 -->\n"
"              <enum name=\"OUT_OF_OFFICE\" value=\"3\"/> <!-- according to Oracle de facto usage in vCalendar 1.0 -->\n"
"              <enum mode=\"defaultvalue\" value=\"0\"/>\n"
"            </value>\n"
"          </property>\n"
"          <property name=\"TRANSP\" suppressempty=\"yes\" onlyformode=\"old\">\n"
"            <value field=\"TRANSP\"/> <!-- directly numeric in vCalendar 1.0 -->\n"
"          </property>\n"
"\n"
"\n"
"          <property name=\"PRIORITY\" suppressempty=\"yes\">\n"
"            <value field=\"PRIORITY\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"SUMMARY\" mandatory=\"yes\">\n"
"            <value field=\"SUMMARY\"/>\n"
"          </property>\n"
"\n"
"          <!-- DESCRIPTION is an optional property and libical does not like\n"
"               empty properties, so suppress it here. However, in the scripts\n"
"               we ensure that the DESCRIPTION field should never be empty. -->\n"
"          <property name=\"DESCRIPTION\" suppressempty=\"yes\" mandatory=\"no\">\n"
"            <value field=\"DESCRIPTION\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"LOCATION\" suppressempty=\"yes\" mandatory=\"no\">\n"
"            <value field=\"LOCATION\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"DTSTART\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"            <value field=\"DTSTART\" conversion=\"autodate\"/>\n"
"            <parameter onlyformode=\"standard\" name=\"TZID\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DTSTART\" conversion=\"TZID\"/>\n"
"            </parameter>\n"
"            <parameter onlyformode=\"standard\" name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DTSTART\" conversion=\"VALUETYPE\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <!-- recurrence rule (with delayed parsing, as it is dependent on DTSTART) -->\n"
"          <property name=\"RRULE\" suppressempty=\"yes\" delayedparsing=\"2\">\n"
"            <!-- Note: RR_FREQ is the beginning of a block of fields\n"
"                 suitable for the \"rrule\" conversion mode -->\n"
"            <value field=\"RR_FREQ\" conversion=\"rrule\"/>\n"
"          </property>\n"
"\n"
"          <!-- Symbian uses this, so it might make the client work with symbian-prepared servers better -->\n"
"          <property name=\"X-RECURRENCE-ID\" suppressempty=\"yes\" onlyformode=\"old\">\n"
"            <value field=\"ORIGSTART\" conversion=\"autodate\"/>\n"
"          </property>\n"
"\n"
"          <property name=\"RECURRENCE-ID\" suppressempty=\"yes\" onlyformode=\"standard\" delayedparsing=\"1\">\n"
"            <value field=\"ORIGSTART\" conversion=\"autodate\"/>\n"
"            <parameter name=\"TZID\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ORIGSTART\" conversion=\"TZID\"/>\n"
"            </parameter>\n"
"            <parameter name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ORIGSTART\" conversion=\"VALUETYPE\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <!-- ScheduleWorld has a problem (bugzilla.moblin.org #2226)\n"
"               with the EXDATE:value1,value2 format (correct in iCalendar 2.0):\n"
"               as a workaround, accept all valid formats plus ; but\n"
"               generate separate properties with one value each. -->\n"
"          <property name=\"EXDATE\" values=\"expandedlist\" suppressempty=\"yes\" onlyformode=\"standard\" delayedparsing=\"1\" valueseparator=\",\" altvalueseparator=\";\">\n"
"            <value field=\"EXDATES\"/>\n"
"            <position field=\"EXDATES\" repeat=\"array\" increment=\"1\" minshow=\"0\"/>\n"
"            <parameter name=\"TZID\" default=\"no\" show=\"yes\">\n"
"              <value field=\"EXDATES\" conversion=\"TZID\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"EXDATE\" values=\"list\" suppressempty=\"yes\" onlyformode=\"old\" delayedparsing=\"1\" valueseparator=\";\" altvalueseparator=\",\">\n"
"            <value field=\"EXDATES\"/>\n"
"            <position field=\"EXDATES\" repeat=\"array\" increment=\"1\" minshow=\"0\"/>\n"
"          </property>\n"
"\n"
"\n"
"          <property name=\"DTEND\" suppressempty=\"yes\" delayedparsing=\"1\">\n"
"            <value field=\"DTEND\" conversion=\"autoenddate\"/>\n"
"            <parameter onlyformode=\"standard\" name=\"TZID\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DTEND\" conversion=\"TZID\"/>\n"
"            </parameter>\n"
"            <parameter onlyformode=\"standard\" name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"DTEND\" conversion=\"VALUETYPE\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"DURATION\" suppressempty=\"yes\" delayedparsing=\"1\" onlyformode=\"standard\">\n"
"            <value field=\"DURATION\"/>\n"
"            <parameter onlyformode=\"standard\" name=\"VALUE\" default=\"no\" show=\"no\">\n"
"              <value field=\"DURATION\" conversion=\"VALUETYPE\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"ATTENDEE\" suppressempty=\"yes\" onlyformode=\"old\">\n"
"            <value field=\"ATTENDEES\"/>\n"
"            <parameter name=\"ROLE\" default=\"no\" positional=\"yes\" show=\"yes\">\n"
"              <value>\n"
"                <enum name=\"ORGANIZER\"/>\n"
"              </value>\n"
"              <position has=\"ORGANIZER\" field=\"ORGANIZER\" overwriteempty=\"yes\"/>\n"
"              <position hasnot=\"ORGANIZER\" field=\"ATTENDEES\" repeat=\"array\" increment=\"1\" overwriteempty=\"yes\"/>\n"
"            </parameter>\n"
"            <parameter name=\"STATUS\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ATTENDEE_PARTSTATS\">\n"
"                <enum name=\"NEEDS ACTION\"   value=\"1\"/>\n"
"                <enum mode=\"defaultvalue\"   value=\"1\"/> <!-- catch unknown, but also non-conformant NEEDS_ACTION -->\n"
"                <enum name=\"ACCEPTED\"       value=\"4\"/>\n"
"                <enum name=\"DECLINED\"       value=\"7\"/>\n"
"                <enum name=\"TENTATIVE\"      value=\"5\"/>\n"
"                <enum name=\"DELEGATED\"      value=\"6\"/>\n"
"              </value>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"ATTENDEE\" suppressempty=\"yes\" onlyformode=\"standard\">\n"
"            <value field=\"ATTENDEES\" conversion=\"mailto\"/>\n"
"            <position field=\"ATTENDEES\" repeat=\"array\" increment=\"1\" minshow=\"0\"/>\n"
"            <parameter name=\"CN\" default=\"no\" show=\"yes\" shownonempty=\"yes\">\n"
"              <value field=\"ATTENDEE_CNS\"/>\n"
"            </parameter>\n"
"            <parameter name=\"PARTSTAT\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ATTENDEE_PARTSTATS\">\n"
"                <enum name=\"NEEDS-ACTION\"   value=\"1\"/>\n"
"                <enum mode=\"defaultvalue\"   value=\"1\"/> <!-- catch unknown, but also non-conformant NEEDS_ACTION -->\n"
"                <enum name=\"ACCEPTED\"       value=\"4\"/>\n"
"                <enum name=\"DECLINED\"       value=\"7\"/>\n"
"                <enum name=\"TENTATIVE\"      value=\"5\"/>\n"
"                <enum name=\"DELEGATED\"      value=\"6\"/>\n"
"              </value>\n"
"            </parameter>\n"
"            <parameter name=\"ROLE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ATTENDEE_ROLE\">\n"
"                <enum name=\"CHAIR\"            value=\"1\"/>\n"
"                <enum name=\"REQ-PARTICIPANT\"  value=\"2\"/>\n"
"                <enum name=\"OPT-PARTICIPANT\"  value=\"3\"/>\n"
"                <enum name=\"NON-PARTICIPANT\"  value=\"4\"/>\n"
"              </value>\n"
"            </parameter>\n"
"            <parameter name=\"RSVP\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ATTENDEE_RSVP\">\n"
"                <enum name=\"TRUE\"             value=\"1\"/>\n"
"                <enum name=\"FALSE\"            value=\"0\"/>\n"
"              </value>\n"
"            </parameter>\n"
"            <parameter name=\"LANGUAGE\" show=\"yes\">\n"
"              <value field=\"ATTENDEE_LANG\"/>\n"
"            </parameter>\n"
"            <parameter name=\"CUTYPE\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ATTENDEE_CUTYPE\">\n"
"                <enum name=\"INDIVIDUAL\"  value=\"1\"/>\n"
"                <enum name=\"GROUP\"       value=\"2\"/>\n"
"                <enum name=\"RESOURCE\"    value=\"3\"/>\n"
"                <enum name=\"ROOM\"        value=\"4\"/>\n"
"                <enum name=\"UNKNOWN\"     value=\"5\"/>\n"
"              </value>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"          <property name=\"ORGANIZER\" suppressempty=\"yes\" onlyformode=\"standard\">\n"
"            <value field=\"ORGANIZER\" conversion=\"mailto\"/>\n"
"            <parameter name=\"CN\" default=\"no\" show=\"yes\">\n"
"              <value field=\"ORGANIZER_CN\"/>\n"
"            </parameter>\n"
"          </property>\n"
"\n"
"\n"
"          <!-- AALARM and DALARM both use the same fields -->\n"
"          <property name=\"AALARM\" onlyformode=\"old\" values=\"4\" suppressempty=\"yes\">\n"
"            <value index=\"0\" field=\"ALARM_TIME\" conversion=\"emptyonly\"/>\n"
"            <value index=\"1\" field=\"ALARM_SNOOZE\" conversion=\"emptyonly\"/>\n"
"            <value index=\"2\" field=\"ALARM_REPEAT\" conversion=\"emptyonly\"/>\n"
"            <value index=\"3\" field=\"ALARM_MSG\" conversion=\"emptyonly\"/>\n"
"          </property>\n"
"          <property name=\"DALARM\" onlyformode=\"old\" values=\"4\" suppressempty=\"yes\">\n"
"            <value index=\"0\" field=\"ALARM_TIME\" conversion=\"emptyonly\"/>\n"
"            <value index=\"1\" field=\"ALARM_SNOOZE\" conversion=\"emptyonly\"/>\n"
"            <value index=\"2\" field=\"ALARM_REPEAT\" conversion=\"emptyonly\"/>\n"
"            <value index=\"3\" field=\"ALARM_MSG\" conversion=\"emptyonly\"/>\n"
"          </property>\n"
"\n"
"          <subprofile onlyformode=\"standard\" name=\"VALARM\" nummandatory=\"1\" field=\"ALARM_TIME\">\n"
"            <property name=\"TRIGGER\" suppressempty=\"no\" mandatory=\"yes\">\n"
"              <value field=\"ALARM_TIME\"/>\n"
"              <parameter name=\"VALUE\" default=\"no\" show=\"yes\">\n"
"                <value field=\"ALARM_TIME\" conversion=\"FULLVALUETYPE\"/>\n"
"              </parameter>\n"
"              <parameter name=\"RELATED\" default=\"no\" show=\"yes\">\n"
"                <value field=\"ALARM_REL\">\n"
"                  <enum mode=\"ignore\" value=\"0\"/>\n"
"                  <enum name=\"START\" value=\"1\"/>\n"
"                  <enum name=\"END\"   value=\"2\"/>\n"
"                </value>\n"
"              </parameter>\n"
"            </property>\n"
"            <property name=\"ACTION\" suppressempty=\"yes\" mandatory=\"yes\">\n"
"              <value field=\"ALARM_ACTION\"/>\n"
"            </property>\n"
"            <property name=\"DESCRIPTION\" suppressempty=\"yes\">\n"
"              <value field=\"ALARM_MSG\"/>\n"
"            </property>\n"
"            <property name=\"REPEAT\" suppressempty=\"yes\">\n"
"              <value field=\"ALARM_REPEAT\"/>\n"
"            </property>\n"
"            <property name=\"X-EVOLUTION-ALARM-UID\" suppressempty=\"yes\">\n"
"              <value field=\"ALARM_UID\"/>\n"
"            </property>\n"
"          </subprofile>\n"
"\n"
"        </subprofile>\n"
"        \n"
"      </profile>\n"
"    </mimeprofile>\n"
"\n"
"\n"
"    <!-- vCalendar 1.0 datatype, using vCalendar profile defined above -->\n"
"    <datatype name=\"vCalendar10\" basetype=\"vcalendar\">\n"
"      <version>1.0</version>\n"
"      <use mimeprofile=\"vCalendar\"/>\n"
"\n"
"      <incomingscript><![CDATA[\n"
"        $VCALENDAR_INCOMING_SCRIPT\n"
"      ]]></incomingscript>\n"
"      \n"
"      <outgoingscript><![CDATA[\n"
"        $VCALENDAR_OUTGOING_SCRIPT\n"
"      ]]></outgoingscript>\n"
"\n"
"    </datatype>\n"
"\n"
"\n"
"    <!-- iCalendar 2.0 datatype, using vCalendar profile defined above -->\n"
"    <datatype name=\"iCalendar20\" basetype=\"vcalendar\">\n"
"      <version>2.0</version>\n"
"      <use mimeprofile=\"vCalendar\"/>\n"
"\n"
"      <incomingscript><![CDATA[\n"
"        $VCALENDAR_INCOMING_SCRIPT\n"
"      ]]></incomingscript>\n"
"\n"
"\n"
"      <outgoingscript><![CDATA[\n"
"        $VCALENDAR_OUTGOING_SCRIPT\n"
"      ]]></outgoingscript>\n"
"\n"
"    </datatype>\n"
"\n"
"\n"
"    <!-- list of internal fields representing plain text note data -->\n"
"    <fieldlist name=\"Note\">\n"
"      <field name=\"SYNCLVL\" type=\"integer\" compare=\"never\"/>\n"
"      <field name=\"SUBJECT\" type=\"multiline\" compare=\"always\"/>\n"
"      <field name=\"TEXT\" type=\"multiline\" compare=\"conflict\" merge=\"lines\"/>\n"
"    </fieldlist>\n"
"\n"
"    <textprofile name=\"Note\" fieldlist=\"Note\">\n"
"      <linemap field=\"SUBJECT\">\n"
"        <numlines>1</numlines>\n"
"        <inheader>false</inheader>\n"
"        <allowempty>true</allowempty>\n"
"        <filterkeyword>SUBJECT</filterkeyword>\n"
"      </linemap>\n"
"      <linemap field=\"TEXT\">\n"
"        <numlines>0</numlines>\n"
"        <inheader>false</inheader>\n"
"        <allowempty>true</allowempty>\n"
"      </linemap>\n"
"    </textprofile>\n"
"\n"
"    <datatype name=\"note10\" basetype=\"text\">\n"
"      <use profile=\"Note\"/>\n"
"      <typestring>text/plain</typestring>\n"
"      <versionstring>1.0</versionstring>\n"
"    </datatype>\n"
"\n"
"    <datatype name=\"note11\" basetype=\"text\">\n"
"      <use profile=\"Note\"/>\n"
"      <typestring>text/plain</typestring>\n"
"      <versionstring>1.1</versionstring>\n"
"    </datatype>\n"
"\n"
"\n"
"    <!-- list of internal fields representing vBookmark data -->\n"
"    <fieldlist name=\"bookmarks\">\n"
"      <field name=\"REV\" type=\"timestamp\" compare=\"never\" age=\"yes\"/>\n"
"      <field name=\"SYNCLVL\" type=\"integer\" compare=\"never\"/>\n"
"\n"
"      <!-- Name -->\n"
"      <field name=\"TITLE\" type=\"string\" compare=\"always\"/>\n"
"\n"
"      <!-- categories and classification -->\n"
"      <field name=\"CATEGORIES\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"      <field name=\"CLASS\" type=\"string\" compare=\"conflict\" merge=\"fillempty\"/>\n"
"\n"
"      <!-- web addresses -->\n"
"      <field name=\"URL\" type=\"url\" compare=\"slowsync\" merge=\"fillempty\"/>\n"
"\n"
"      <!-- Note -->\n"
"      <field name=\"NOTE\" type=\"multiline\" compare=\"conflict\" merge=\"lines\"/>\n"
"\n"
"    </fieldlist>\n"
"\n"
"    <!-- vBookmark profile -->\n"
"    <mimeprofile name=\"vBookmark\" fieldlist=\"bookmarks\">\n"
"\n"
"      <profile name=\"VBKM\" nummandatory=\"0\">\n"
"        <property name=\"VERSION\">\n"
"          <value conversion=\"version\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"X-LAST-MODIFIED\">\n"
"          <value field=\"REV\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"TITLE\">\n"
"          <value field=\"TITLE\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"URL\">\n"
"          <value field=\"URL\"/>\n"
"        </property>\n"
"\n"
"        <!-- non-standard properties -->\n"
"\n"
"        <property name=\"CATEGORIES\">\n"
"          <value field=\"CATEGORIES\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"CLASS\" suppressempty=\"yes\">\n"
"          <value field=\"CLASS\"/>\n"
"        </property>\n"
"\n"
"        <property name=\"NOTE\" filter=\"no\">\n"
"          <value field=\"NOTE\"/>\n"
"        </property>\n"
"\n"
"      </profile>\n"
"    </mimeprofile>\n"
"\n"
"    <!-- vBookmark datatype, using vBookmark profile defined above -->\n"
"    <datatype name=\"vBookmark10\" basetype=\"mimedir\">\n"
"      <typestring>text/x-vbookmark</typestring>\n"
"      <versionstring>1.0</versionstring>\n"
"      <use profile=\"vBookmark\"/>\n"
"    </datatype>\n"
"\n"
"    <fieldlists/>\n"
"    <profiles/>\n"
"    <datatypes/>\n"
"  </datatypes>\n"
"\n"
"\n"
"  <client type=\"plugin\">\n"
"    <binfilespath>$(binfilepath)</binfilespath>\n"
"    <defaultauth/>\n"
"\n"
"    <!-- SyncEvolution has traditionally not folded long lines in\n"
"         vCard.  Testing showed that servers still have problems with\n"
"         it, so avoid it by default -->\n"
"    <donotfoldcontent>yes</donotfoldcontent>\n"
"\n"
"    <fakedeviceid/>\n"
"\n"
"    <datastore/>\n"
"\n"
"    <remoterule name=\"EVOLUTION\">\n"
"      <deviceid>none - this rule is activated via its name in MAKE/PARSETEXTWITHPROFILE() macro calls</deviceid>\n"
"    </remoterule>\n"
"\n"
"    <remoterules/>\n"
"  </client>\n"
"\n"
"</sysync_config>\n"
;
