#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
 
#include "sync-time-now-menu-widget.h"
 
#define SYNC_TIME_NOW_MENU_WIDGET_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj,   \
                            TYPE_SYNC_TIME_NOW_MENU_WIDGET, SyncTimeNowMenuWidgetPrivate))
 
struct _SyncTimeNowMenuWidgetPrivate
{
    GtkWidget *label;
    gpointer data;
};
 
HD_DEFINE_PLUGIN_MODULE (SyncTimeNowMenuWidget, sync_time_now_menu_widget,   HD_TYPE_STATUS_MENU_ITEM);
 
static void
sync_time_now_menu_widget_class_finalize (SyncTimeNowMenuWidgetClass *klass) {}
 
static void
sync_time_now_menu_widget_class_init (SyncTimeNowMenuWidgetClass *klass)
{
    g_type_class_add_private (klass, sizeof (SyncTimeNowMenuWidgetPrivate));
}


static void button_clicked_callback( GtkWidget *widget, gpointer   data )
{
  system("rdate -s -n pool.ntp.org");
}


static void
sync_time_now_menu_widget_init (SyncTimeNowMenuWidget *plugin)
{
    plugin->priv = SYNC_TIME_NOW_MENU_WIDGET_GET_PRIVATE (plugin);
 
    GtkIconTheme *icon_theme = gtk_icon_theme_get_default ();
    GList *list = gtk_icon_theme_list_icons (icon_theme, NULL);
    GdkPixbuf *pixbuf = gtk_icon_theme_load_icon (icon_theme, "general_email",
                    STATUS_AREA_ICON_SIZE, GTK_ICON_LOOKUP_NO_SVG, NULL);
    hd_status_plugin_item_set_status_area_icon (HD_STATUS_PLUGIN_ITEM (plugin), pixbuf);
    g_object_unref (pixbuf);
 
    GtkWidget *b = gtk_button_new_with_label ("Sync time Now");
    gtk_signal_connect (GTK_OBJECT (b), "clicked",
                        GTK_SIGNAL_FUNC (button_clicked_callback), NULL);

    gtk_widget_show_all (b);
 
    plugin->priv->label = b;
 
    gtk_container_add (GTK_CONTAINER (plugin), plugin->priv->label);
 
    gtk_widget_show_all (plugin->priv->label);
 
   gtk_widget_show (GTK_WIDGET (plugin));
}

