#!/usr/bin/python2.5

#################################################################
##   swappolube  -  Configuration UI for the swappolube script ##
#################################################################

##Author: Christos Zamantzas <christos.zamantzas@gmail.com>
##Version: 0.3-0

import os
import sys
import time

from PyQt4 import QtGui,QtCore
from PyQt4.QtCore import SIGNAL, Qt
from PyQt4.QtGui import *

from swappolubeUI import *

##############################################################

Path         = '/home/user/.swappolube/'      # temp path of files
AppPath      = '/opt/swappolube/'             # application path
ConfigFile   = 'swappolube_config_temp'       # name of temp config file
DefaultFile  = 'swappolube_config_default'    # name of default config file
MainPath     = '/etc/event.d/'                # main path
MainFile     = 'tuning'                       # tuning file


##############################################################

def CheckFile(Path, File):
    """ Check if a file exists. """

    try:
        f = open(Path + File, 'r')
        f.close()
    except:
        return False
    else:
        return True

##############################################################
        
def showMessage(message):
    """
    Method to display a message to the user that waits for a confirmation.
    """

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          

##############################################################  

def showQuickMessage(message):
    """
    Method to display a message to the user.
    """

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          

##############################################################  

def doUpdateConfig():
    """
    Update the config file with the edited.
    """

    time.sleep(1)
    try:
       os.system('cp %s %s' % (Path + ConfigFile, MainPath + MainFile))
    except:
       return False
    else: 
       return True
       
# ##############################################################

class MyMainWindow(QtGui.QMainWindow):
        def __init__(self, parent=None):
        
             ##Build parent user interface
             QtGui.QWidget.__init__(self, parent)
             self.ui = Ui_swappolube()
             self.ui.setupUi(self)
             
             ##Connect the GUI Buttons with actions
               ##Create Settings
             QtCore.QObject.connect(self.ui.btnCreateConfig, QtCore.SIGNAL('clicked()'), self.doCreateConfig)
             QtCore.QObject.connect(self.ui.btnApplyConfig, QtCore.SIGNAL('clicked()'), self.doApplyConfig)
             QtCore.QObject.connect(self.ui.btnSetCurrent, QtCore.SIGNAL('clicked()'), self.doSetCurrent)
             QtCore.QObject.connect(self.ui.btnSetProposed, QtCore.SIGNAL('clicked()'), self.doSetProposed)
             
               ##Connect Menu Buttons 
             QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
             QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)
             QtCore.QObject.connect(self.ui.actionCredits, QtCore.SIGNAL('triggered()'), self.doCredits)
             QtCore.QObject.connect(self.ui.actionDelete_Tunings, QtCore.SIGNAL('triggered()'), self.doDeleteTunings)
             
             ##Set default values in the GUI
             self.doSetCurrent()

        ##Create Methods
                
        def doAbout(self):
             msg = "The SWAPPOLUBE Editor is a user interface to the configuration of several parameters of the N900 kernel with the aim to make it faster.\n"
             msg += "It provides the ability to change a number of parameters while in operation and if chosen will make them persistent by adding a script to event.d to set them after each boot.\n"
             msg += "Additional information could be found in http://wiki.maemo.org/Swappolube"
             QMessageBox.about(self, "About - SWAPPOLUBE editor", msg)

        def doCredits(self):
             msg = unichr(int('00A9', 16)) + "2010, Christos Zamantzas (saturn)\n"
             msg += unichr(int('00A9', 16)) + "2010, Ernesto de Bernardis (debernardis)\n\n"
             msg += "Configuration Interface for several kernel parameters\n"
             msg += "Distributed under GPL ver. 2"
             QMessageBox.about(self, "Credits - SWAPPOLUBE Editor", msg)
 
        def doDeleteTunings(self): ##FIXME: check if file was deleted!!
             os.system('rm /etc/event.d/tuning')
             message = 'The tuning file has been removed from the boot sequence.\nOn next reboot, the system will start with its default configuration.'
             showMessage(message)

        def doSetCurrent(self): ##FIXME: separate reading and setting to two methods!!!
             """Set current values in the GUI"""
             
             ##Set values for enable/disable   
             self.ui.radioKillAllocatingTask.setChecked(False)
             self.ui.radioPageCluster.setChecked(False)
             self.ui.radioLaptopMode.setChecked(False)
             self.ui.radioDirtyExpireCentisecs.setChecked(False)
             self.ui.radioTCPTimestamps.setChecked(False)
             self.ui.radioDirtyWritebackCentisecs.setChecked(False)
             self.ui.radioTCPNoMetricsSave.setChecked(False)
             self.ui.radioVFSCachePressure.setChecked(False)
             self.ui.radioDirtyRatio.setChecked(False)
             self.ui.radioSwappiness.setChecked(False)
             self.ui.radioDirtyBGDRatio.setChecked(False)

             ##Set Values for checkboxes
             
             if os.popen('cat /proc/sys/vm/oom_kill_allocating_task').read().strip('\n') == '1':
                self.ui.checkBoxKillAllocatingTask.setChecked(True)
             else:
                self.ui.checkBoxKillAllocatingTask.setChecked(False)

             if os.popen('cat /proc/sys/net/ipv4/tcp_timestamps').read().strip('\n') == '1':
               self.ui.checkBoxTCPTimestamps.setChecked(True)
             else:
               self.ui.checkBoxTCPTimestamps.setChecked(False)

             if os.popen('cat /proc/sys/net/ipv4/tcp_no_metrics_save').read().strip('\n') == '1':
               self.ui.checkBoxTCPNoMetricsSave.setChecked(True)
             else:
               self.ui.checkBoxTCPNoMetricsSave.setChecked(False)

             ##Set values for lineEdits
             LaptopMode = os.popen('cat /proc/sys/vm/laptop_mode').read().strip('\n')
             DirtyRatio = os.popen('cat /proc/sys/vm/dirty_ratio').read().strip('\n')
             Swappiness = os.popen('cat /proc/sys/vm/swappiness').read().strip('\n')
             DirtyBGDRatio = os.popen('cat /proc/sys/vm/dirty_background_ratio').read().strip('\n')
             readVFSCachePressure = os.popen('cat /proc/sys/vm/vfs_cache_pressure').read().strip('\n')
             PageCluster = os.popen('cat /proc/sys/vm/page-cluster').read().strip('\n')
             DirtyWritebackCentisecs = os.popen('cat /proc/sys/vm/dirty_writeback_centisecs').read().strip('\n')
             DirtyExpireCentisecs = os.popen('cat /proc/sys/vm/dirty_expire_centisecs').read().strip('\n')
             
             self.ui.lineLaptopMode.setText("%s" % LaptopMode)
             self.ui.lineDirtyRatio.setText("%s" % DirtyRatio)
             self.ui.lineSwappiness.setText("%s" % Swappiness)
             self.ui.lineDirtyBGDRatio.setText("%s" % DirtyBGDRatio)  
             self.ui.lineVFSCachePressure.setText("%s" % readVFSCachePressure)
             self.ui.linePageCluster.setText("%s" % PageCluster)
             self.ui.lineDirtyWritebackCentisecs.setText("%s" % DirtyWritebackCentisecs )
             self.ui.lineDirtyExpireCentisecs.setText("%s" % DirtyExpireCentisecs)

             message = 'The CURRENT configuration options are shown.'
             showQuickMessage(message)

        def doSetProposed(self): ##FIXME: outsourse proposed values to a file!!!
             """ Set default values in the GUI """
             
             ##Set values for enable/disable   
             self.ui.radioKillAllocatingTask.setChecked(True)
             self.ui.radioPageCluster.setChecked(True)
             self.ui.radioLaptopMode.setChecked(True)
             self.ui.radioDirtyExpireCentisecs.setChecked(True)
             self.ui.radioTCPTimestamps.setChecked(True)
             self.ui.radioDirtyWritebackCentisecs.setChecked(True)
             self.ui.radioTCPNoMetricsSave.setChecked(True)
             self.ui.radioVFSCachePressure.setChecked(False)
             self.ui.radioDirtyRatio.setChecked(True)
             self.ui.radioSwappiness.setChecked(True)
             self.ui.radioDirtyBGDRatio.setChecked(True)

             ##Set Values for checkboxes
             self.ui.checkBoxKillAllocatingTask.setChecked(True)
             self.ui.checkBoxTCPTimestamps.setChecked(False)
             self.ui.checkBoxTCPNoMetricsSave.setChecked(True)

             ##Set values for lineEdits
             self.ui.lineLaptopMode.setText("1")
             self.ui.lineDirtyRatio.setText("95")
             self.ui.lineSwappiness.setText("30")
             self.ui.lineDirtyBGDRatio.setText("60")  
             self.ui.lineVFSCachePressure.setText("100")
             self.ui.linePageCluster.setText("0")
             self.ui.lineDirtyWritebackCentisecs.setText("0")
             self.ui.lineDirtyExpireCentisecs.setText("0")

             message = 'The PROPOSED configuration options are shown.'
             showQuickMessage(message)
             
        def doApplyConfig(self):
             """ Apply the configuration shown in the gui now! It will be lost on next reboot."""
             
             message = 'Please wait. Update in progress..'
             showQuickMessage(message)
             
             ##Read GUI.
             DirtyRatio = self.ui.lineDirtyRatio.text()
             Swappiness = self.ui.lineSwappiness.text()
             DirtyBGDRatio = self.ui.lineDirtyBGDRatio.text()  
             PageCluster = self.ui.linePageCluster.text()
             DirtyExpireCentisecs = self.ui.lineDirtyExpireCentisecs.text()
             DirtyWritebackCentisecs = self.ui.lineDirtyWritebackCentisecs.text()
             LaptopMode = self.ui.lineLaptopMode.text()
             VFSCachePressure = self.ui.lineVFSCachePressure.text()
                
             if  self.ui.checkBoxKillAllocatingTask.isChecked() == True:
                KillAllocatingTask = '1'
             else:
                KillAllocatingTask = '0'
             if self.ui.checkBoxTCPTimestamps.isChecked() == True:
                TCPTimestamps = '1'
             else:
                TCPTimestamps = '0'
             if self.ui.checkBoxTCPNoMetricsSave.isChecked() == True:
                TCPNoMetricsSave = '1'
             else:
                TCPNoMetricsSave = '0'
              
             ##Update the values.
             if self.ui.radioKillAllocatingTask.isChecked() == True:
               os.system('sudo %supdateTuning KillAllocatingTask %s' % (AppPath, KillAllocatingTask) )
             if self.ui.radioPageCluster.isChecked() == True:
               os.system('sudo %supdateTuning PageCluster %s' % (AppPath, PageCluster) )
             if self.ui.radioLaptopMode.isChecked() == True:
               os.system('sudo %supdateTuning LaptopMode %s' % (AppPath, LaptopMode) )
             if self.ui.radioDirtyExpireCentisecs.isChecked() == True:
               os.system('sudo %supdateTuning DirtyExpireCentisecs %s' % (AppPath, DirtyExpireCentisecs) )
             if self.ui.radioTCPTimestamps.isChecked() == True:
               os.system('sudo %supdateTuning TCPTimestamps %s' % (AppPath, TCPTimestamps) )
             if self.ui.radioDirtyWritebackCentisecs.isChecked() == True:
               os.system('sudo %supdateTuning DirtyWritebackCentisecs %s' % (AppPath, DirtyWritebackCentisecs) )
             if self.ui.radioTCPNoMetricsSave.isChecked() == True:
               os.system('sudo %supdateTuning TCPNoMetricsSave %s' % (AppPath, TCPNoMetricsSave) )
             if self.ui.radioDirtyRatio.isChecked() == True:
               os.system('sudo %supdateTuning DirtyRatio %s' % (AppPath, DirtyRatio) )
             if self.ui.radioSwappiness.isChecked() == True:
               os.system('sudo %supdateTuning Swappiness %s' % (AppPath, Swappiness) )
             if self.ui.radioDirtyBGDRatio.isChecked() == True:
               os.system('sudo %supdateTuning DirtyBGDRatio %s' % (AppPath, DirtyBGDRatio) )
             if self.ui.radioVFSCachePressure.isChecked() == True:
               os.system('sudo %supdateTuning VFSCachePressure %s' % (AppPath, VFSCachePressure) )
             message = 'The new configuration has been applied to the system.'
             showMessage(message)
             
        def doCreateConfig(self):
             message = 'Please wait. Update in progress..'
             showQuickMessage(message)

             ##Read GUI.
             DirtyRatio = self.ui.lineDirtyRatio.text()
             Swappiness = self.ui.lineSwappiness.text()
             DirtyBGDRatio = self.ui.lineDirtyBGDRatio.text()  
             PageCluster = self.ui.linePageCluster.text()
             DirtyExpireCentisecs = self.ui.lineDirtyExpireCentisecs.text()
             DirtyWritebackCentisecs = self.ui.lineDirtyWritebackCentisecs.text()
             LaptopMode = self.ui.lineLaptopMode.text()
             VFSCachePressure = self.ui.lineVFSCachePressure.text()
                
             if  self.ui.checkBoxKillAllocatingTask.isChecked() == True:
                KillAllocatingTask = '1'
             else:
                KillAllocatingTask = '0'
             if self.ui.checkBoxTCPTimestamps.isChecked() == True:
                TCPTimestamps = '1'
             else:
                TCPTimestamps = '0'
             if self.ui.checkBoxTCPNoMetricsSave.isChecked() == True:
                TCPNoMetricsSave = '1'
             else:
                TCPNoMetricsSave = '0'
            
             ##Update of the config file.
             if CheckFile(Path, ConfigFile) == True:
                try:
                   os.remove( Path + ConfigFile )
                except:
                   message = 'FATAL ERROR: The temp configuration file could not be removed.\nThe application will now exit..'
                   showMessage(message)
                   sys.exit(1)
                else:
                   pass 
             else:
                pass 

             destination = open( Path + ConfigFile, "w" )

             destination.write('description "N900 tuning"\n')
             destination.write('author "swappolube editor"\n')
             destination.write('\n')
             destination.write('\n')
             destination.write('console output\n')
             destination.write('\n')
             destination.write('start on started hildon-desktop\n')
             destination.write('\n')
             destination.write('\n')
             destination.write('script\n')
             if self.ui.radioKillAllocatingTask.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/oom_kill_allocating_task\n' % KillAllocatingTask) 
             if self.ui.radioPageCluster.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/page-cluster\n' % PageCluster) 
             if self.ui.radioLaptopMode.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/laptop_mode\n' % LaptopMode) 
             if self.ui.radioDirtyExpireCentisecs.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/dirty_expire_centisecs\n' % DirtyExpireCentisecs) 
             if self.ui.radioTCPTimestamps.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/net/ipv4/tcp_timestamps\n' % TCPTimestamps) 
             if self.ui.radioDirtyWritebackCentisecs.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/dirty_writeback_centisecs\n' % DirtyWritebackCentisecs) 
             if self.ui.radioTCPNoMetricsSave.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/net/ipv4/tcp_no_metrics_save\n' % TCPNoMetricsSave) 
             if self.ui.radioDirtyRatio.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/dirty_ratio\n' % DirtyRatio) 
             if self.ui.radioSwappiness.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/swappiness\n' % Swappiness) 
             if self.ui.radioDirtyBGDRatio.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/dirty_background_ratio\n' % DirtyBGDRatio) 
             if self.ui.radioVFSCachePressure.isChecked() == True:
               destination.write('       echo "%s" > /proc/sys/vm/vfs_cache_pressure\n' % VFSCachePressure) 
             destination.write('end script\n')
             destination.close()
             
             ##Update destination file
             if doUpdateConfig() == True:
                message = 'The new configuration has been created and copied to event.d folder.'
                showMessage(message)
             else:
                message = 'FATAL ERROR: The new configuration could not be created.'
                showMessage(message)
            
##############################################################
             
if __name__ == "__main__": 
        
          ##Check with what priviledges the GUI has been executed
          if os.geteuid() == 0:
             message ='ERROR: The swappolube editor cannot be executed as root. Exiting..'
             showMessage(message)
             sys.exit(1)
          
          ##Check if temp folder is available   
          if os.path.exists(Path) == False:
             os.system('mkdir %s' % Path)
          else:
             pass
       
          # #Open Dialog Window
          app = QtGui.QApplication(sys.argv)
          myapp = MyMainWindow()
          myapp.show()
          sys.exit(app.exec_())