/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of StultitiaSimplex.
 *
 *  StultitiaSimplex is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  StultitiaSimplex is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with StultitiaSimplex.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pa_utils.h"

#include <string.h>
#include <pulse/ext-stream-restore.h>

static bool availability_checked = false;
static bool is_available = false;
static char *monitor_name = NULL;

void get_sink_info_list_callback(pa_context *context, const pa_sink_info *info, int eol, void *data){
    (void) context;
    (void) data;

    if(eol == 0){
        qDebug("Sink: %s -- Monitor source: %s -- Monitor index: %d", info->name, info->monitor_source_name, info->monitor_source);
        if(monitor_name == NULL){
            qDebug("Using %s as monitor.", info->monitor_source_name);
            monitor_name = new char[strlen(info->monitor_source_name)];
            strcpy(monitor_name, info->monitor_source_name);
        }
    }else{
        qDebug("Sending signal...");
        pa_threaded_mainloop_signal(threaded_main_loop, 0);
    }
}

#ifndef Q_WS_MAEMO_5
const char *get_monitor_name(){
    pa_context_get_sink_info_list(context, get_sink_info_list_callback, NULL);

    do{
        pa_threaded_mainloop_lock(threaded_main_loop);
        pa_threaded_mainloop_wait(threaded_main_loop);
        qDebug("Received signal...");
    }while(monitor_name == NULL);
    pa_threaded_mainloop_unlock(threaded_main_loop);

    qDebug("Got monitor: %s", monitor_name);
    return (const char*) monitor_name;
}
#else
const char *get_monitor_name(){
    return "sink.hw0.monitor";
}
#endif

bool pa_available(){
    if(! availability_checked){
        int context_available;
        context_available = context_create();
        context_stop();

        is_available = (context_available == 0);
        availability_checked = true;
    }
    return is_available;
}
