#include "networkhelper.h"

NetworkHelper::NetworkHelper(QObject *parent) :
    QObject(parent)
{
}

void NetworkHelper::setNetworkAccessManager(QNetworkAccessManager *manager) {
    nam = manager;
}

// doWebRequest in C++
void NetworkHelper::doWebRequest(QString sid, QString method, QString itemURL, int params) {
    QNetworkRequest request;
    request.setUrl(QUrl(itemURL));

    if (params==1) {
        request.setAttribute(QNetworkRequest::ConnectionEncryptedAttribute, true);
        request.setRawHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    if(sid.length()>0 && params<2) {
        //request.setRawHeader("Authorization", "GoogleLogin auth=" + sid);
        request.setRawHeader("GData-Version", "2");
    }

    if (method=="GET") {
        #ifdef DBG
        qDebug() << "QNetworkManager: GET" << itemURL;
        #endif
        reply = nam->get(request);
    }
    // This is for login only
    else if (method=="POST") {
        #ifdef DBG
        qDebug() << "QNetworkManager: POST" << itemURL;
        #endif

        QByteArray data;
        QUrl urlParams;

        // parse out username/password from itemURL
        int startIdx = itemURL.indexOf("Email=") + 6;
        int endIdx   = itemURL.indexOf("&Passwd");
        QString username = itemURL.mid(startIdx,endIdx-startIdx);

        int pwdStartIdx = itemURL.indexOf("Passwd=") + 7;
        QString password = itemURL.mid(pwdStartIdx);

        itemURL = itemURL.mid(0, startIdx-7);

        #ifdef DBG
        qDebug() << itemURL << " " << username << " " << password;
        #endif

        request.setUrl(QUrl(itemURL));

        urlParams.addQueryItem("Email", username);
        urlParams.addQueryItem("Passwd", password);
        urlParams.addQueryItem("service", "finance");
        urlParams.addQueryItem("source",  "stockona");
        data = urlParams.encodedQuery();
        reply = nam->post(request, data);
        emit statusChanged("Parsing");

        connect(reply, SIGNAL(readyRead()), this, SLOT(parseAuth()));
        //connect(reply, SIGNAL(error(QNetworkReply::NetworkError)),
        //        this, SLOT(slotError(QNetworkReply::NetworkError)));
        //connect(reply, SIGNAL(sslErrors(QList<QSslError>)),
        //        this, SLOT(slotSslErrors(QList<QSslError>)));
    }
}

void NetworkHelper::parseAuth() {
    if (reply->error()) {
        emit statusChanged("failed");
        #ifdef DBG
        qDebug() << reply->error() << ":" << reply->errorString();
        #endif
    }

    QByteArray dataBin = reply->readAll();

    #ifdef DBG
    qDebug() << dataBin;
    #endif

    QString data(dataBin);
    data = data.trimmed();

    // login
    int equalIndex = data.indexOf("Auth=", 0);

    if ( equalIndex < 0 ) {
        return;
    }

    auth = data.mid(equalIndex+5);

    #ifdef DBG
    qDebug() << "######" << auth;
    #endif

    // XML
    // - parsePfo()
    // - parsePos()
    //QDomDocument doc;
    //QDomElement rootNode = doc.documentElement();

    // JSON

    // CSV
}

