import QtQuick 1.0

// Portrait detail windows
Rectangle {
    id: portraitDetail
    anchors.fill: parent
    color: "ivory"
    opacity: 0

    Text {
        id: symbolBox
        anchors { left: parent.left; leftMargin: 10 }

        smooth: txtSmooth
        font.bold: true
        font.pixelSize: listFontSize
        text: myName //posView.model.get(posView.currentIndex).name
    }

    Text {
        id: priceBox
        anchors { top: parent.top; left: symbolBox.right; leftMargin: 20; rightMargin: 5; topMargin: 5 }

        smooth: txtSmooth
        font.pixelSize: fontSize1
        text: myQuotePrice //posView.model.get(posView.currentIndex).quotePrice
    }

    Text {
        id: gainBox
        anchors { top: priceBox.bottom; left: parent.left; leftMargin: 10; rightMargin: 5; topMargin: 5 }

        smooth: txtSmooth
        color: myQuoteChgColor //posView.model.get(posView.currentIndex).quoteChgColor
        font.pixelSize: fontSize1
        text: myQuoteChg + " (" + myQuoteChgPtg + "%)"
        //text: posView.model.get(posView.currentIndex).quoteChg + " (" + posView.model.get(posView.currentIndex).quoteChgPtg + "%)"
    }

    Text {
        id: askBidBox
        anchors { top: gainBox.bottom; left: parent.left; leftMargin: 10; rightMargin: 5; topMargin: 10 }

        smooth: txtSmooth
        color: statColor
        font.pixelSize: fontSize3 + 2
        text: "Ask: " + myQuoteAsk + " / Bid: " + myQuoteBid
        //text: "Ask: " + posView.model.get(posView.currentIndex).quoteAsk + " / Bid: " + posView.model.get(posView.currentIndex).quoteBid
    }

    Text {
        id: infoBox
        anchors { top: parent.top; right: parent.right; rightMargin: 10; topMargin: statTopMargin}

        smooth: txtSmooth
        color: statColor
        font.pixelSize: fontSize3
        horizontalAlignment: Text.AlignRight
        text: ("Share: " + myShare + "\nValue: " + myShareValue + "\nCost: " + myShareCost + "\nDayG: " + myShareDayGain + "\nGain: " + myShareGain + "\nReturn: " + myShareGainPercent + "%")
        //text: ("Share: " + posView.model.get(posView.currentIndex).share + "\nValue: " + posView.model.get(posView.currentIndex).shareValue + "\nCost: " + posView.model.get(posView.currentIndex).shareCost + "\nDayG: " + posView.model.get(posView.currentIndex).shareDayGain + "\nGain: " + posView.model.get(posView.currentIndex).shareGain + "\nReturn: " + posView.model.get(posView.currentIndex).shareGainPercent + "%")
    }

    Flickable {
        id: detailFlick
        //anchors.fill: parent
        anchors { top: infoBox.bottom; left: parent.left; right: parent.right; bottom: parent.bottom }
        anchors { bottomMargin: 10; leftMargin: 10; rightMargin: 10 }
        anchors.topMargin: 10
        contentHeight: (chartView == "") ? 500 : 750 // chart.width
        clip: true

        // Line separator
        Rectangle {
            id: separator1
            anchors { top: parent.top; }
            width: parent.width
            height: 2
            color: "#D5D5D5"
        }

        Text {
            id: detailSymText;
            anchors { left: separator1.left; top: separator1.bottom; topMargin: 10 }
            wrapMode: Text.WordWrap;
            color: statColor
            font.pixelSize: fontSize3
            text: myExg + " - " + myFullname
            //text: posView.model.get(posView.currentIndex).exchange + " - " + posView.model.get(posView.currentIndex).fullName;
        }

        SimpleButton {
            id: newsButton
            anchors { left: detailSymText.left; top: detailSymText.bottom; topMargin: 10 }
            text: "Related News"
            textSize: fontSize3

            onClicked: {
                newsView.activeFeedUrl = "http://www.google.com/finance/company_news?q=" + myExg + ":" + myName + "&output=rss";
                container.inNewsView();
            }
        }

        Text {
            id: detailRangeText;
            anchors { top: newsButton.bottom; left: parent.left; topMargin: 10;  }
            color: statColor
            wrapMode: Text.WordWrap;
            font.pixelSize: fontSize3
            text: "Day High: " + myQuoteDayHi + "\nDay Low: " + myQuoteDayLo + "\n52w High: " + myQuote52wHi + "\n52w Low: " + myQuote52wLo + "\nMkt Cap: " + myQuoteMktCap;
            //text: "Day High: " + posView.model.get(posView.currentIndex).quoteDayHi + "\nDay Low: " + posView.model.get(posView.currentIndex).quoteDayLo + "\n52w High: " + posView.model.get(posView.currentIndex).quote52wHi + "\n52w Low: " + posView.model.get(posView.currentIndex).quote52wLo + "\nMkt Cap: " + posView.model.get(posView.currentIndex).quoteMktCap;
        }

        Text {
            id: detailStatsText;
            anchors { top: newsButton.bottom; right: parent.right; topMargin: 10; }
            color: statColor
            wrapMode: Text.WordWrap;
            font.pixelSize: fontSize3
            text: "EPS: " + myQuoteEps + "\nPE: " + myQuotePe + "\nBeta: " + myQuoteBeta + "\nVol: " + myQuoteVol + "\nAvg Vol: " + myQuoteAvgVol;
            //text: "EPS: " + posView.model.get(posView.currentIndex).quoteEps + "\nPE: " + posView.model.get(posView.currentIndex).quotePe + "\nBeta: " + posView.model.get(posView.currentIndex).quoteBeta + "\nVol: " + posView.model.get(posView.currentIndex).quoteVol + "\nAvg Vol: " + posView.model.get(posView.currentIndex).quoteAvgVol;
        }

        // Line separator
        Rectangle {
            id: separator3
            anchors { top: detailStatsText.bottom; topMargin: 10 }
            width: parent.width
            height: 2
            color: "#D5D5D5"
        }

        SimpleButton{
            id: chartSel1
            width: (parent.width - 20)/5
            anchors { top: separator3.bottom; topMargin: 10 }
            text: "3m"
            textSize: fontSize2

            onClicked: { container.chartView = "3m"; }
        }
        SimpleButton{
            id: chartSel2
            width: (parent.width - 20)/5
            anchors { top: separator3.bottom; left: chartSel1.right; topMargin: 10; leftMargin: 5 }
            text: "6m"
            textSize: fontSize2

            onClicked: { container.chartView = "6m"; }
        }
        SimpleButton{
            id: chartSel3
            width: (parent.width - 20)/5
            anchors { top: separator3.bottom; left: chartSel2.right; topMargin: 10; leftMargin: 5 }
            text: "1y"
            textSize: fontSize2

            onClicked: { container.chartView = "1y"; }
        }
        SimpleButton{
            id: chartSel4
            width: (parent.width - 20)/5
            anchors { top: separator3.bottom; left: chartSel3.right; topMargin: 10; leftMargin: 5 }
            text: "2y"
            textSize: fontSize2

            onClicked: { container.chartView = "2y"; }
        }
        SimpleButton{
            id: chartSel5
            width: (parent.width - 20)/5
            anchors { top: separator3.bottom; left: chartSel4.right; right: separator3.right; topMargin: 10; leftMargin: 5 }
            text: "5y"
            textSize: fontSize2

            onClicked: { container.chartView = "5y"; }
        }

        ProgressBar {
            id: chartProgress
            width: parent.width
            height: 10
            anchors { top: chartSel1.bottom; topMargin: 5; }
            anchors.horizontalCenter: parent.horizontalCenter
            barColor: "#2954FF"
            bgColor: "#2954FF"

            progress: chart.progress

            states: State {
                name: "hideProgress"
                when: (chart.status!=Image.Loading)
                PropertyChanges { target: chartProgress; opacity: 0 }
            }
        }

        Item {
            id: chartItem
            anchors { top: chartSel1.bottom; topMargin: 20; }
            anchors.horizontalCenter: parent.horizontalCenter

            Image {
                id: chart
                anchors.horizontalCenter: parent.horizontalCenter

                width: 512
                height: 288
                source: (chartView=="") ? "" : "http://chart.finance.yahoo.com/c/" + chartView + "/s/" + Script.convertExchangeForYahoo(myName, myExg);
            }
        }
//            MouseArea {
//                id: detailMouseArea
//                anchors.fill: portraitDetail
//                onClicked: {
//                    chartView = "";
//                    container.state='';
//                    container.inMainView();
//                }
//            }
    }
}
