#ifndef FILEHANDLER_H
#define FILEHANDLER_H

#include <QIODevice>
#include <QFile>
#include <QTextStream>
#include <iostream>
#include <QObject>
#include <QString>
#include <QStringList>
#include <QList>
#include <QVariant>
#include <QDebug>

class FileHandler : public QObject
{
    Q_OBJECT

    // portfolio
    Q_PROPERTY (QVariantList localPfoName
                READ localPfoName)
    Q_PROPERTY (QVariantList localPfoNum
                READ localPfoNum)
    Q_PROPERTY (QVariantList localPfoDesc
                READ localPfoDesc)

    // position
//    Q_PROPERTY (QVariantList localPosSymbol
//                READ localPosSymbol)
//    Q_PROPERTY (QVariantList localPosShare
//                READ localPosShare)
//    Q_PROPERTY (QVariantList localPosCost
//                READ localPosCost)
//    Q_PROPERTY (QVariantList localPosStop
//                READ localPosStop)
//    Q_PROPERTY (QVariantList localPosIsYahoo
//                READ localPosIsYahoo)

public:
    explicit FileHandler(QObject *parent = 0);

    // portfolio
    void debugPfo();
    Q_INVOKABLE int storePfo();
    Q_INVOKABLE int loadPfo();
    Q_INVOKABLE void appendPfo(QString , QString , int);
    Q_INVOKABLE void removePfo(int);
    Q_INVOKABLE int deletePfo();
    // position
//    Q_INVOKABLE int storePos();
    Q_INVOKABLE int loadPos(int);
//    Q_INVOKABLE void appendPos(QString , int , int, int, bool);
//    Q_INVOKABLE void removePos(int);

    // portfolio
    QVariantList localPfoName() const { return pfoName; }
    QVariantList localPfoNum() const { return pfoNum; }
    QVariantList localPfoDesc() const { return pfoDesc; }
    // position
    QVariantList localPosSymbol() const { return posSymbol; }
    QVariantList localPosShare() const { return posShare; }
    QVariantList localPosCost() const { return posCost; }
    QVariantList localPosStop() const { return posStop; }
    QVariantList localPosIsYahoo() const { return posIsYahoo; }

signals:

public slots:

private:
    QVariantList pfoName;
    QVariantList pfoNum;
    QVariantList pfoDesc;

    QVariantList posSymbol;
    QVariantList posShare;
    QVariantList posCost;
    QVariantList posStop;
    QVariantList posIsYahoo;

};

#endif // FILEHANDLER_H
