#include "filehandler.h"

FileHandler::FileHandler(QObject *parent) :
    QObject(parent)
{
}

void FileHandler::debugPfo() {
      for (int i=0; i<pfoName.count(); i++) {
          qDebug() << pfoName[i].toString();
          qDebug() << pfoDesc[i].toString();
          qDebug() << pfoNum[i].toBool();
      }
}

Q_INVOKABLE int FileHandler::storePfo()
{
  qDebug() << "C_Info: Store pfo into portfolio.cfg";

  QFile f( "portfolio.cfg" );

  if( !f.open( QIODevice::WriteOnly ) )
  {
    qDebug() << "Failed to open for write.";

    return -1;
  }

  QTextStream ts( &f );

  if (!pfoName.isEmpty()&&!pfoNum.isEmpty()) {
      for (int i=0; i < pfoName.count(); i++) {
          ts << pfoName[i].toString() << ":" << pfoDesc[i].toString() << ":" << pfoNum[i].toInt() << endl;
          qDebug() << "C_Info: " << pfoName[i].toString() << ":" << pfoDesc[i].toString() << ":" << pfoNum[i].toInt();
      }
  }

  f.close();

  return 0;
}

Q_INVOKABLE int FileHandler::loadPfo()
{
  QFile f( "portfolio.cfg" );

  if( !f.exists() )
  {
    qDebug() << "C_Info: Local portfolio does not exist.";

    return -1;
  }

  if( !f.open( QIODevice::ReadOnly ) )
  {
    qDebug() << "C_Info: Failed to open for read.";

    return -1;
  }

  QTextStream ts( &f );

  QStringList strList;
  //QStringList::const_iterator constIterator;

  while ( !ts.atEnd() ) {
      strList = ts.readLine().split(":");

      if (strList.length()==3) {
          //for (constIterator = strList.constBegin(); constIterator != strList.constEnd(); ++constIterator) {
          //qDebug() << (*constIterator).toLocal8Bit().constData();
          //if (constIterator==strList.constBegin())
          //    pfoName.append( (*constIterator).toLocal8Bit().constData() );
          //else
          //    pfoNum.append( (*constIterator).toLocal8Bit().constData() );
          for (int i=0; i<strList.length(); i++) {
              //qDebug() << "C_Info: " << strList[i].toLocal8Bit().constData();
              if (i==0)
                  pfoName.append( strList[i].toLocal8Bit().constData() );
              else if (i==1)
                  pfoDesc.append( strList[i].toLocal8Bit().constData() );
              else
                  pfoNum.append( strList[i].toLocal8Bit().constData() );
          }
      }
      else {
          // Fix format
          //f.remove();
          qDebug() << "C_Info: Error in loading local portfolio.";

          return -1;
      }
  }

  //debugPfo();

  f.close();

  return 0;
}

Q_INVOKABLE void FileHandler::appendPfo(QString name, QString desc, int num) {
    qDebug() << "C_Info: Append: " << name << " " << desc << " " << num;
    pfoName.append(name);
    pfoDesc.append(desc);
    pfoNum.append(num);
}

Q_INVOKABLE void FileHandler::removePfo(int idx) {
    qDebug() << "C_Info: Remove entry " << idx;
    pfoName.removeAt(idx);
    pfoDesc.removeAt(idx);
    pfoNum.removeAt(idx);
}

Q_INVOKABLE int FileHandler::deletePfo() {
    QFile f( "portfolio.cfg" );

    if( !f.exists() )
    {
      qDebug() << "Local portfolio does not exist.";

      return -1;
    }

    f.remove();
    qDebug() << "Delete local portfolio.";

    f.close();

    return 0;
}

Q_INVOKABLE int FileHandler::loadPos(int idx)
{
  QString filename = pfoName[idx].toString();
  filename.append(".pos");

  QFile f( filename );

  if( !f.exists() )
  {
    qDebug() << "C_Info: Position " << pfoName[idx].toString() << " does not exist.";

    return -1;
  }

  if( !f.open( QIODevice::ReadOnly ) )
  {
    qDebug() << "C_Info: Failed to open position for read.";

    return -1;
  }

  QTextStream ts( &f );

  QStringList strList;

  while ( !ts.atEnd() ) {
      strList = ts.readLine().split(":");

      if (strList.length()==5) {
          for (int i=0; i<strList.length(); i++) {
              //qDebug() << "C_Info: " << strList[i].toLocal8Bit().constData();
              if (i==0)
                  posSymbol.append( strList[i].toLocal8Bit().constData() );
              else if (i==1)
                  posShare.append( strList[i].toLocal8Bit().constData() );
              else if (i==2)
                  posCost.append( strList[i].toLocal8Bit().constData() );
              else if (i==3)
                  posStop.append( strList[i].toLocal8Bit().constData() );
              else
                  posIsYahoo.append( strList[i].toLocal8Bit().constData() );
          }
      }
      else {
          // Fix format
          //f.remove();
          qDebug() << "C_Info: Error in loading local position.";

          return -1;
      }
  }

  //debugPos();

  f.close();

  return 0;
}
