/*
Log file
*/

import QtQuick 1.0

Item {
    id: settingMenu
    width: parent.width
    height: parent.height - header.height

    property alias username: usrNameInput.text
    property alias password: usrPwdInput.text
    property alias timer: updateFreqInput.text
    property bool usePortfolioView: false
    property bool isDarkTheme: false // for AMOLED

    property int listFontSize: 28
    property int fontSize1: listFontSize - 2

    property color textInputBg: "#E2EFFC" //"#C2DEFA"
    property color breakBg: "#D5D5D5"

    // signal interface
    signal callPfo
    signal close
    signal signout
    signal signin
    signal about

    Rectangle {
        id: background
        x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
        color: "ivory"
        border.color: "orange"
        radius: 5
    }

    Column{
        id: menuGrid
        x:10
        y:10
        width: parent.width - 2*x
        height:  parent.height - 2*y
        spacing: 10

        // Username
        Row {
            spacing: 20

            Text {
                id: usrName
                font.bold: true
                font.pixelSize: listFontSize
                text: "Username"
            }
            // Input bg
            Rectangle {
                id: usrInputBG
                x: 2
                width: settingMenu.width - 20 - x
                height: usrNameInput.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: usrNameInput
                    width: usrInputBG.width
                    maximumLength: 30
                    focus: parent.focus
                    font.pixelSize: fontSize1
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (!usrNameInput.activeFocus) {
                            usrNameInput.forceActiveFocus();
                            usrNameInput.openSoftwareInputPanel();
                        } else {
                            usrNameInput.focus = false;
                        }
                    }
                }
            }
        }

        // Password
        Row {
            spacing: 20

            Text {
                id: usrPwd
                font.bold: true
                font.pixelSize: listFontSize
                text: "Password"
            }
            // Input bg
            Rectangle {
                id: usrPwdInputBG
                x: 2
                width: settingMenu.width - 20 - x
                height: usrPwdInput.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: usrPwdInput
                    width: usrPwdInputBG.width
                    maximumLength: 30
                    focus: parent.focus
                    echoMode: TextInput.Password
                    font.pixelSize: fontSize1
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (!usrPwdInput.activeFocus) {
                            usrPwdInput.forceActiveFocus();
                            usrPwdInput.openSoftwareInputPanel();
                        } else {
                            usrPwdInput.focus = false;
                        }
                    }
                }
            }
        }

        Row {
            x: 20
            width: settingMenu.width
            height: pfo.height
            spacing: 50

            SimpleButton {
                id: signoutButton
                width: 40
                height: 40
                radius: 40
                textSize: 20
                textColor: "#696d71"
                text: "logout"
                onClicked: { settingMenu.signout(); }
            }

            SimpleButton {
                id: signinButton
                width: 40
                height: 40
                radius: 40
                textSize: 20

                text: "login"
                onClicked: { settingMenu.signin(); }
            }
        }

        // Line separator
        Rectangle {
            id: pfoRowBG
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

        Row {
            spacing: 20

            // Update frequency
            Text {
                id: updateFreq
                font.bold: true
                font.pixelSize: listFontSize
                text: "Refresh (Seconds)"
            }
            Rectangle {
                id: updateFreqInputBG
                x: 2
                width: settingMenu.width - 20 - x
                height: usrNameInput.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                TextInput {
                    id: updateFreqInput
                    //maximumLength: 5
                    inputMask: "99999"
                    text: "5"
                    focus: parent.focus
                    font.pixelSize: fontSize1
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (!updateFreqInput.activeFocus) {
                            updateFreqInput.forceActiveFocus();
                            updateFreqInput.openSoftwareInputPanel();
                        } else {
                            updateFreqInput.focus = false;
                        }
                    }
                }
            }
        }

        // Line separator
        Rectangle {
            id: usrNameSeparator
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

        // Portfolio view
        Row {
            spacing: 20

            Text {
                id: pfoView
                font.bold: true
                font.pixelSize: listFontSize
                text: "Portfolio View"
            }

            Rectangle {
                id: pfoBG
                x: 2
                width: pfoView.height
                height: pfoView.height

                color: textInputBg
                radius: 5
                border.width: 1
                border.color: "#aaa"
                smooth: true

                Rectangle {
                    id: pfoSelectBG
                    x: 4
                    y: 4
                    width: pfoView.height - 2*x
                    height: pfoView.height - 2*y
                    radius: 5
                    smooth: true
                    visible: settingMenu.usePortfolioView
                    color: "#7DBFFF"
                }

                MouseArea {
                    id: pfoViewMouseArea
                    anchors.fill: parent

                    onClicked: {
                        settingMenu.usePortfolioView = !usePortfolioView
                    }
                }
            }
        }

        // Line separator
        Rectangle {
            id: pfoViewSeparator
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

        // Select profolio
        Row {
            x: 2
            width: settingMenu.width
            height: pfo.height
            spacing: 20

            Text {
                id: pfo
                font.bold: true
                font.pixelSize: listFontSize
                text: "Select Portfolio"
            }
            TextButton {
                id: pfoButton
                text: "Portfolio"

                onClicked: { settingMenu.callPfo(); }
            }
        }

        // Line separator
        Rectangle {
            id: separatorPfo
            width: settingMenu.width
            height: 2
            color: "#D5D5D5"
        }

    }

    BackButton {
        id: backButton
        anchors { bottom: parent.bottom; left: parent.left; leftMargin: 20; bottomMargin: 20; }
        width: 65
        height: 65
        onClicked: { settingMenu.close(); }
    }

//    SimpleButton {
//        id: aboutButton
//        anchors { bottom: parent.bottom; right: parent.right; rightMargin: 20; bottomMargin: 20; }
//        width: 60
//        height: aboutButton.width
//        radius: aboutButton.width

//        color: "#F2F2F2"

//        text: "?"
//        textColor: "white"
//        textSize: 50

//        //onClicked: { settingMenu.close(); }
//    }
    TextButton {
        id: aboutButton
        anchors { bottom: parent.bottom; right: parent.right; rightMargin: 20; bottomMargin: 20; }
        width: 60
        height: aboutButton.width
        radius: aboutButton.width

        color: "#F2F2F2"
        lightColor: "#FFFFFF"
        pressColor: aboutButton.color

        text: "?"
        textColor: "white"
        textSize: 55
        textBold: true

        onClicked: { settingMenu.state = "shownAbout"; }//about(); }
    }

    About {
        id: aboutView
        anchors.fill: parent
        opacity: 0
    }

    states: [
        State {
            name: "hidden"
            PropertyChanges { target: settingMenu; y: 0 - settingMenu.height }
        },
        State {
            name: "shown"
            PropertyChanges { target: settingMenu; y: header.height }
        },
        State {
            name: "shownAbout"
            PropertyChanges { target: settingMenu; y: header.height }
            PropertyChanges { target: menuGrid; opacity: 0 }
            PropertyChanges { target: aboutView; opacity: 1 }
        }
    ]

    transitions: Transition {
        SequentialAnimation {
            PropertyAnimation {
                target: settingMenu
                properties: "y"
                duration: 300
                easing.type: "OutQuad"
            }
        }
    }
}
