import QtQuick 1.0

Item {
    id: container
    width: 640
    height: 480

    property bool txtSmooth: true
    property color backgroundColor: "ivory"
    property color currentItemColor: "#FFF8C6"
    property color pressColor: "#FDE688"
    property real listFontSize : 32

    property bool updatePos: false
    property bool editMode: false
    property bool pfoLocal: false

    property real selectedIdx: 0

    property real numPosition: 0

    signal close

    ListView {
        id: posEditView
        anchors.fill: parent
        model: posModel
        delegate: posEditDelegate
        snapMode: ListView.SnapToItem
    }

    Component {
        id: posEditDelegate

        Item {
            id: posEditDelegateItem
            width: posEditView.width
            height: 70

            Rectangle {
                id: background
                x: 5; y: 2; width: parent.width - x*2; height: parent.height - y*2
                color: container.backgroundColor
                border.color: "#3577B9"
                radius: 5
            }

            Text {
                id: nameBox
                anchors { top: background.top; left: background.left; leftMargin: 20; }

                smooth: txtSmooth
                font.bold: true
                font.pixelSize: listFontSize
                verticalAlignment: Text.AlignVCenter
                text: name
            }

            MouseArea {
                id: mouseArea
                anchors.fill: background
                onClicked: {
                    selectedIdx = index;
                    posEditDelegateItem.ListView.view.currentIndex = index;

                    //activePos = feedLink;
                    activePos = index;

                    reloadEditDialog(name, share, shareCost, false);
                    container.state = "entry";
                }
            }

            SimpleButton {
                id: deleteBox
                anchors { right: background.right; rightMargin: 10; }
                anchors.verticalCenter: background.verticalCenter
                width: 50
                color: "#FF5555"
                pressedColor: "#FC3A3A"

                visible: (pfoLocal&editMode)

                text: "X"
                textColor: (pfoLocal&editMode) ? "white" : "grey"
                textSize: listFontSize
                radius: 10

                onClicked: {
                    if (pfoLocal&editMode) {
                        //fileHandler.deletePfo();
                        posModel.remove(index);
                    }

                    container.state = "";
                }
           }

            states: [
                State {
                    name: "Pressed"
                    when: mouseArea.pressed
                    PropertyChanges { target: background; color: container.pressColor }
                },
                State {
                    name: "highlightCurrentItem"
                    when: selectedIdx == index
                    PropertyChanges { target: background; color: container.currentItemColor }
                }
            ]
        }
    }

    BackButton {
        id: backButton
        anchors { bottom: container.bottom; left: container.left; leftMargin: 20; bottomMargin: 20; }
        width: 65
        height: 65
        onClicked: { container.close(); }
    }

    TextButton {
        id: addButton
        anchors { bottom: parent.bottom; right: parent.right; rightMargin: 20; bottomMargin: 20; }
        width: 60
        height: addButton.width
        radius: addButton.width

//        color: "#F2F2F2"
//        lightColor: "#FFFFFF"
        color: "#B0D8FF"
        lightColor: addButton.color
        pressColor: addButton.color

        text: "+"
        textColor: "#B0D8FF"
        textSize: 60
        textBold: true

        onClicked: {
            resetEditDialog();
            container.state = "entry";
        }
    }

    Edit {
        id: editDialog
        state: "hidden"

        onSave: {
            //fileHandler.storePos(symbolIn.text, container.isYahooQuote);

            if (updatePos) {
                posModel.set(selectedIdx, {
                    "name": editDialog.myName,
                    "share": editDialog.myShare,
                    "shareCost": editDialog.myCost
                });
            }
            else {
                posModel.append({
                    "name": editDialog.myName,
                    "share": editDialog.myShare,
                    "shareCost": editDialog.myCost
                });
            }

            container.state = "";
        }
        onCancel: { container.state = "" }
    }

    states: [
        State {
            name: "entry"
            PropertyChanges { target: editDialog; state: "shown"  }
            PropertyChanges { target: container; updatePos: true  }
        }
    ]

    function resetEditDialog() {
        editDialog.myName   = "";
        editDialog.myShare  = "";
        editDialog.myCost   = "";
        editDialog.isYahooQuote = "";
    }

    function reloadEditDialog(name, share, cost, isYahoo) {
        editDialog.myName   = name;
        editDialog.myShare  = share;
        editDialog.myCost   = cost;
        editDialog.isYahooQuote = isYahoo;
    }
}
