import QtQuick 1.0

Rectangle {
    id: container
    color: "#7DBFFF" //#CDDAE6"
    width: 640
    height: 40

    property string text: ""
    property bool privateInAlternativeTxt: false
    property bool showBusy: false

    signal clicked
    signal callback

    Item {
        id: minimizeButton
        anchors { top: parent.top; left: parent.left; leftMargin: 10; topMargin: 0 }
        width: parent.height
        height: parent.height

        Image {
            anchors.centerIn: parent
            smooth: true
            source: "gfx/minimizeicon.png"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: {
                console.log("Minimizing");
                windowHelper.minimize();
            }
        }
    }

    Rectangle {
        id: separator1
        anchors { left: minimizeButton.right; top: parent.top; leftMargin: 10; topMargin: 2 }
        color: "#B9DCFF"
        height: parent.height - 4
        width: 2
        radius: 2
    }

    WaitIndicator {
        id: waitIndicator
        anchors { right: separator2.left; rightMargin: 20; }
        anchors { verticalCenter: parent.verticalCenter; }

        width: parent.height - 18
        height: parent.height - 18
        imageHeight: parent.height - 18
        imageWidth: parent.height - 18

        show: true//mainWindow.showBusy
    }

    Rectangle {
        id: header

        x: parent.height + 24
        color: container.color
        width: parent.width - 2*x
        height: 2*parent.height
        radius: 5
        state: "hidden"

        SimpleButton {
            id: headerDropDown
            anchors { top: parent.top; left: parent.left; right: parent.right; leftMargin: 60; rightMargin: 60}
            height: parent.height/2
            color: "white"
            textColor: "#808080"
            textBold: true
            textSize: 28
            textElide: true
        }

        // offset a bit
        Text {
            id: headerTxt
            anchors { bottom: parent.bottom; horizontalCenter: parent.horizontalCenter; top: headerDropDown.bottom}
            width: parent.width
            height: parent.height/2

            font.bold: true
            color: "white"
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter

            text: container.text
            font.pixelSize: 28
            elide: Text.ElideRight
        }

        // Flash from left to right
        ProgressBar2 {
            id: busyIndicator
            width: parent.width
            height: parent.height
            busy: mainWindow.showWaitIndicator
        }

        states: [
            State {
                name: "hidden"
                PropertyChanges { target: container; privateInAlternativeTxt: false }
                PropertyChanges { target: header; y: - header.height/2 }
            },
            State {
                name: "shown"
                PropertyChanges { target: header; y: 2 }
            }
        ]

        transitions: Transition {
            SequentialAnimation {
                PropertyAnimation {
                    target: header
                    properties: "y"
                    duration: 300
                    easing.type: "OutQuad"
                }
            }
        }
    }

    Rectangle {
        id: separator2
        anchors { right: quitButton.left; top: parent.top; rightMargin: 10; topMargin: 2 }
        color: "#B9DCFF"
        height: parent.height - 4
        width: 2
        radius: 2
    }

    Item {
        id: quitButton
        anchors { top: parent.top; right: parent.right; rightMargin: 10; topMargin: 0 }
        height: parent.height
        width: parent.height

        Image {
            // x.png is slightly above center
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            anchors.verticalCenterOffset: 1

            //anchors { top: parent.top; right: parent.right; topMargin: 1 }
            smooth: true
            source: "gfx/x.png"
        }

        MouseArea {
            anchors.fill: parent
            onClicked: {
                console.log("Exiting");
                Qt.quit();
            }
        }
    }

    CustomGesture {
        id: customGesture
        anchors.fill: header
        deltaUD: parent.height/2

        onClicked: {
            //container.clicked();
            if (header.state=="shown") {
                container.callback();
                header.state = "hidden";
            }
            else {
                container.privateInAlternativeTxt = !container.privateInAlternativeTxt;
            }
        }
        onSwipeDown: { header.state = "shown"; }
        onSwipeUp: { header.state = "hidden"; }
    }

    states: [
        State {
            name: "alternative"
            when: container.privateInAlternativeTxt == true
            PropertyChanges { target: headerTxt; text: pfoModel.get(mainWindow.pfoSelectedIdx).name; }
        },
        State {
            name: "dropdown"
            when: header.state == "shown"
            PropertyChanges { target: headerDropDown; text: "-" + pfoModel.get(mainWindow.pfoSelectedIdx).name + "-"; }
        }
    ]
}
