import QtQuick 1.0

Item {
    id: container
    width: parent.width
    height: parent.height
    z: 0.5

    property bool busy: false
    property color markColor: "white"

    Rectangle {
        id: mark
        width: 100
        height: 8
        anchors.bottom: parent.bottom
        color: markColor
        opacity: (busy) ? 0.2 : 0
        radius: 2

        x: 0

        SequentialAnimation on x {
            alwaysRunToEnd: true
            running: busy
            loops: Animation.Infinite
            PropertyAnimation { to: parent.width; duration: 800 }
            PropertyAnimation { to: 0; duration: 0 }
        }

        Behavior on opacity { NumberAnimation { duration: 80 } }
    }
}
